/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.derby;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.derby.Util;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class DerbyRegistration {
    private static final String DERBY_REGISTRATION_DIR = "JavaDB";
    private static final String DERBY_REGISTRATION_FILE = "registration_instance";
    private static final String ATTR_DERBY_HOME = "javadb_installation_home";
    private static final Logger LOGGER = Logger.getLogger(DerbyRegistration.class.getName());

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.out.println("Parameters: <nb clusterDir> <Derby home>");
            System.exit(-1);
        }
        int status = DerbyRegistration.registerDerbyInstallation(args[0], args[1]);
        System.exit(status);
    }

    private static int registerDerbyInstallation(String cluster, String derbyHome) throws IOException {
        LOGGER.log(Level.FINE, "Cluster for JavaDB registration is " + cluster);
        System.setProperty("netbeans.user", cluster);
        FileObject javaDBRegistrationDir = FileUtil.getConfigFile((String)DERBY_REGISTRATION_DIR);
        if (javaDBRegistrationDir == null && (javaDBRegistrationDir = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)DERBY_REGISTRATION_DIR)) == null) {
            LOGGER.log(Level.INFO, "Cannot register the default JavaDB. The config/JavaDB folder cannot be created.");
            return 2;
        }
        File derbyHomeFile = new File(derbyHome);
        if (!derbyHomeFile.exists()) {
            LOGGER.log(Level.INFO, "Cannot register the default JavaDB. The JavaDB installation directory " + derbyHome + " does not exist.");
            return 3;
        }
        if (!Util.isDerbyInstallLocation(derbyHomeFile)) {
            LOGGER.log(Level.INFO, "Cannot register the default JavaDB. The JavaDB installation directory " + derbyHome + " does not contain expected libraries.");
            return 4;
        }
        FileObject registrationFO = FileUtil.getConfigFile((String)"JavaDB/registration_instance");
        if (registrationFO == null) {
            try {
                registrationFO = javaDBRegistrationDir.createData(DERBY_REGISTRATION_FILE);
                registrationFO.setAttribute(ATTR_DERBY_HOME, (Object)derbyHome);
                LOGGER.log(Level.FINE, "New registration links to " + registrationFO.getAttribute(ATTR_DERBY_HOME));
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, "Cannot register JavaDB, cause " + e.getLocalizedMessage(), e);
                return 5;
            }
        } else {
            LOGGER.log(Level.INFO, "The previous registration found. Links to " + registrationFO.getAttribute(ATTR_DERBY_HOME));
        }
        return 0;
    }

    public static String getRegisteredDerbyHome() {
        FileObject registrationFO = FileUtil.getConfigFile((String)"JavaDB/registration_instance");
        String home = (String)(registrationFO == null ? null : registrationFO.getAttribute(ATTR_DERBY_HOME));
        LOGGER.log(Level.FINE, "Registered home is " + home);
        return home;
    }
}

