/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view;

import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import org.jsampler.SamplerChannelModel;
import org.jsampler.event.EffectSendsEvent;
import org.jsampler.event.EffectSendsListener;
import org.jsampler.view.FxSendTableModel;
import org.linuxsampler.lscp.FxSend;

public class FxSendTable
extends JTable {
    private final DefaultCellEditor defaultEditor;
    private final JTextField tfEditor = new JTextField();
    private final Handler eventHandler = new Handler();

    public FxSendTable(SamplerChannelModel samplerChannelModel) {
        this.setModel(new FxSendTableModel(samplerChannelModel));
        this.setSelectionMode(0);
        samplerChannelModel.addEffectSendsListener(this.getHandler());
        this.tfEditor.setBorder(BorderFactory.createEmptyBorder());
        this.defaultEditor = new DefaultCellEditor(this.tfEditor);
    }

    public FxSend getSelectedFxSend() {
        int n = this.getSelectedRow();
        if (n == -1) {
            return null;
        }
        return ((FxSendTableModel)this.getModel()).getFxSend(n);
    }

    public void setSelectedFxSend(FxSend fxSend) {
        int n = ((FxSendTableModel)this.getModel()).getFxSendPosition(fxSend);
        if (n != -1) {
            this.getSelectionModel().setSelectionInterval(n, n);
        }
    }

    public void editSelectedFxSend() {
        FxSend fxSend = this.getSelectedFxSend();
        if (fxSend == null) {
            return;
        }
        this.editCellAt(((FxSendTableModel)this.getModel()).getFxSendPosition(fxSend), 0);
        Component component = this.defaultEditor.getComponent();
        component.requestFocus();
        if (component instanceof JTextField) {
            ((JTextField)component).selectAll();
        }
    }

    @Override
    public TableCellEditor getCellEditor(int n, int n2) {
        return this.defaultEditor;
    }

    private Handler getHandler() {
        return this.eventHandler;
    }

    private class Handler
    implements EffectSendsListener {
        private Handler() {
        }

        @Override
        public void effectSendAdded(EffectSendsEvent effectSendsEvent) {
            FxSendTable.this.setSelectedFxSend(effectSendsEvent.getFxSend());
        }

        @Override
        public void effectSendRemoved(EffectSendsEvent effectSendsEvent) {
        }

        @Override
        public void effectSendChanged(EffectSendsEvent effectSendsEvent) {
        }
    }
}

