/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.ddmlib.internal.jdwp;

import java.nio.ByteBuffer;
import java.util.Locale;
import shadow.bundletool.com.android.ddmlib.Log;
import shadow.bundletool.com.android.ddmlib.internal.jdwp.chunkhandler.JdwpPacket;

public class JdwpLoggingUtils {
    public static void log(String owner, String action, JdwpPacket packet) {
        if (Log.isAtLeast(Log.LogLevel.VERBOSE)) {
            Log.v("JdwpProxy-Packet", String.format(Locale.getDefault(), "%s %s (%d)", owner, action, packet.getId()));
            packet.log(action);
        }
    }

    public static void log(String owner, String action, byte[] buffer, int length) {
        if (Log.isAtLeast(Log.LogLevel.VERBOSE)) {
            Log.v("JdwpProxy-Buffer", String.format(Locale.getDefault(), "%s %s (%d) %s", owner, action, length, JdwpLoggingUtils.formatBytesToString(buffer, length)));
        }
    }

    public static void logPacketError(String message2, ByteBuffer packet) {
        StringBuilder error = new StringBuilder();
        error.append(message2);
        int bufferData = packet.position();
        if (bufferData > 0) {
            error.append(String.format(Locale.getDefault(), "\nPacket Payload (%d): %s", bufferData, JdwpLoggingUtils.formatBytesToString(packet.array(), Math.min(bufferData, 128))));
        }
        Log.e("JdwpProxy", error.toString());
    }

    public static void logPacketError(String message2, JdwpPacket packet) {
        StringBuilder error = new StringBuilder();
        error.append(message2);
        if (packet != null) {
            error.append(String.format("\nPacket Header: %s", packet.toString()));
            error.append(String.format(Locale.getDefault(), "\nPacket Payload (%d): %s", packet.getLength(), JdwpLoggingUtils.formatBytesToString(packet.getPayload().array(), Math.min(packet.getLength(), 128))));
        }
        Log.e("JdwpProxy", error.toString());
    }

    private static String formatBytesToString(byte[] buffer, int length) {
        StringBuilder builder = new StringBuilder(length);
        for (int i15 = 0; i15 < length; ++i15) {
            if (Character.isLetterOrDigit((char)buffer[i15])) {
                builder.append((char)buffer[i15]);
                continue;
            }
            builder.append(Integer.toHexString(buffer[i15]));
        }
        return builder.toString();
    }
}

