/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.apksig.internal.apk.v3;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import shadow.bundletool.com.android.apksig.apk.ApkFormatException;
import shadow.bundletool.com.android.apksig.internal.apk.ApkSigningBlockUtils;
import shadow.bundletool.com.android.apksig.internal.apk.SignatureAlgorithm;
import shadow.bundletool.com.android.apksig.internal.util.GuaranteedEncodedFormX509Certificate;
import shadow.bundletool.com.android.apksig.internal.util.X509CertificateUtils;

public class V3SigningCertificateLineage {
    private static final int FIRST_VERSION = 1;
    private static final int CURRENT_VERSION = 1;

    public static List<SigningCertificateNode> readSigningCertificateLineage(ByteBuffer inputBytes) throws IOException {
        ArrayList<SigningCertificateNode> result = new ArrayList<SigningCertificateNode>();
        int nodeCount = 0;
        if (inputBytes == null || !inputBytes.hasRemaining()) {
            return null;
        }
        ApkSigningBlockUtils.checkByteOrderLittleEndian(inputBytes);
        Certificate lastCert = null;
        int lastSigAlgorithmId = 0;
        try {
            int version = inputBytes.getInt();
            if (version != 1) {
                throw new IllegalArgumentException("Encoded SigningCertificateLineage has a version different than any of which we are aware");
            }
            HashSet<Certificate> certHistorySet = new HashSet<Certificate>();
            while (inputBytes.hasRemaining()) {
                ++nodeCount;
                ByteBuffer nodeBytes = ApkSigningBlockUtils.getLengthPrefixedSlice(inputBytes);
                ByteBuffer signedData = ApkSigningBlockUtils.getLengthPrefixedSlice(nodeBytes);
                int flags = nodeBytes.getInt();
                int sigAlgorithmId = nodeBytes.getInt();
                SignatureAlgorithm sigAlgorithm = SignatureAlgorithm.findById(lastSigAlgorithmId);
                byte[] signature = ApkSigningBlockUtils.readLengthPrefixedByteArray(nodeBytes);
                if (lastCert != null) {
                    String jcaSignatureAlgorithm = sigAlgorithm.getJcaSignatureAlgorithmAndParams().getFirst();
                    AlgorithmParameterSpec jcaSignatureAlgorithmParams = sigAlgorithm.getJcaSignatureAlgorithmAndParams().getSecond();
                    PublicKey publicKey = lastCert.getPublicKey();
                    Signature sig = Signature.getInstance(jcaSignatureAlgorithm);
                    sig.initVerify(publicKey);
                    if (jcaSignatureAlgorithmParams != null) {
                        sig.setParameter(jcaSignatureAlgorithmParams);
                    }
                    sig.update(signedData);
                    if (!sig.verify(signature)) {
                        throw new SecurityException("Unable to verify signature of certificate #" + nodeCount + " using " + jcaSignatureAlgorithm + " when verifying V3SigningCertificateLineage object");
                    }
                }
                signedData.rewind();
                byte[] encodedCert = ApkSigningBlockUtils.readLengthPrefixedByteArray(signedData);
                int signedSigAlgorithm = signedData.getInt();
                if (lastCert != null && lastSigAlgorithmId != signedSigAlgorithm) {
                    throw new SecurityException("Signing algorithm ID mismatch for certificate #" + nodeBytes + " when verifying V3SigningCertificateLineage object");
                }
                lastCert = X509CertificateUtils.generateCertificate(encodedCert);
                if (certHistorySet.contains(lastCert = new GuaranteedEncodedFormX509Certificate((X509Certificate)lastCert, encodedCert))) {
                    throw new SecurityException("Encountered duplicate entries in SigningCertificateLineage at certificate #" + nodeCount + ".  All signing certificates should be unique");
                }
                certHistorySet.add(lastCert);
                lastSigAlgorithmId = sigAlgorithmId;
                result.add(new SigningCertificateNode((X509Certificate)lastCert, SignatureAlgorithm.findById(signedSigAlgorithm), SignatureAlgorithm.findById(sigAlgorithmId), signature, flags));
            }
        }
        catch (BufferUnderflowException | ApkFormatException e15) {
            throw new IOException("Failed to parse V3SigningCertificateLineage object", e15);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e16) {
            throw new SecurityException("Failed to verify signature over signed data for certificate #" + nodeCount + " when parsing V3SigningCertificateLineage object", e16);
        }
        catch (CertificateException e17) {
            throw new SecurityException("Failed to decode certificate #" + nodeCount + " when parsing V3SigningCertificateLineage object", e17);
        }
        return result;
    }

    public static byte[] encodeSigningCertificateLineage(List<SigningCertificateNode> signingCertificateLineage) {
        ArrayList<byte[]> nodes = new ArrayList<byte[]>();
        for (SigningCertificateNode node : signingCertificateLineage) {
            nodes.add(V3SigningCertificateLineage.encodeSigningCertificateNode(node));
        }
        byte[] encodedSigningCertificateLineage = ApkSigningBlockUtils.encodeAsSequenceOfLengthPrefixedElements(nodes);
        int payloadSize = 4 + encodedSigningCertificateLineage.length;
        ByteBuffer encodedWithVersion = ByteBuffer.allocate(payloadSize);
        encodedWithVersion.order(ByteOrder.LITTLE_ENDIAN);
        encodedWithVersion.putInt(1);
        encodedWithVersion.put(encodedSigningCertificateLineage);
        return encodedWithVersion.array();
    }

    public static byte[] encodeSigningCertificateNode(SigningCertificateNode node) {
        int parentSigAlgorithmId = 0;
        if (node.parentSigAlgorithm != null) {
            parentSigAlgorithmId = node.parentSigAlgorithm.getId();
        }
        int sigAlgorithmId = 0;
        if (node.sigAlgorithm != null) {
            sigAlgorithmId = node.sigAlgorithm.getId();
        }
        byte[] prefixedSignedData = V3SigningCertificateLineage.encodeSignedData(node.signingCert, parentSigAlgorithmId);
        byte[] prefixedSignature = ApkSigningBlockUtils.encodeAsLengthPrefixedElement(node.signature);
        int payloadSize = prefixedSignedData.length + 4 + 4 + prefixedSignature.length;
        ByteBuffer result = ByteBuffer.allocate(payloadSize);
        result.order(ByteOrder.LITTLE_ENDIAN);
        result.put(prefixedSignedData);
        result.putInt(node.flags);
        result.putInt(sigAlgorithmId);
        result.put(prefixedSignature);
        return result.array();
    }

    public static byte[] encodeSignedData(X509Certificate certificate, int flags) {
        try {
            byte[] prefixedCertificate = ApkSigningBlockUtils.encodeAsLengthPrefixedElement(certificate.getEncoded());
            int payloadSize = 4 + prefixedCertificate.length;
            ByteBuffer result = ByteBuffer.allocate(payloadSize);
            result.order(ByteOrder.LITTLE_ENDIAN);
            result.put(prefixedCertificate);
            result.putInt(flags);
            return ApkSigningBlockUtils.encodeAsLengthPrefixedElement(result.array());
        }
        catch (CertificateEncodingException e15) {
            throw new RuntimeException("Failed to encode V3SigningCertificateLineage certificate", e15);
        }
    }

    public static class SigningCertificateNode {
        public final X509Certificate signingCert;
        public final SignatureAlgorithm parentSigAlgorithm;
        public SignatureAlgorithm sigAlgorithm;
        public final byte[] signature;
        public int flags;

        public SigningCertificateNode(X509Certificate signingCert, SignatureAlgorithm parentSigAlgorithm, SignatureAlgorithm sigAlgorithm, byte[] signature, int flags) {
            this.signingCert = signingCert;
            this.parentSigAlgorithm = parentSigAlgorithm;
            this.sigAlgorithm = sigAlgorithm;
            this.signature = signature;
            this.flags = flags;
        }

        public boolean equals(Object o15) {
            if (this == o15) {
                return true;
            }
            if (!(o15 instanceof SigningCertificateNode)) {
                return false;
            }
            SigningCertificateNode that = (SigningCertificateNode)o15;
            if (!this.signingCert.equals(that.signingCert)) {
                return false;
            }
            if (this.parentSigAlgorithm != that.parentSigAlgorithm) {
                return false;
            }
            if (this.sigAlgorithm != that.sigAlgorithm) {
                return false;
            }
            if (!Arrays.equals(this.signature, that.signature)) {
                return false;
            }
            return this.flags == that.flags;
        }
    }
}

