/*
 * Decompiled with CFR 0.152.
 */
package org.stringtemplate.v4;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.stringtemplate.v4.STWriter;

public class AutoIndentWriter
implements STWriter {
    public List<String> indents = new ArrayList<String>();
    public int[] anchors = new int[10];
    public int anchors_sp = -1;
    public String newline;
    public Writer out = null;
    public boolean atStartOfLine = true;
    public int charPosition = 0;
    public int charIndex = 0;
    public int lineWidth = -1;

    public AutoIndentWriter(Writer out, String newline) {
        this.out = out;
        this.indents.add(null);
        this.newline = newline;
    }

    public AutoIndentWriter(Writer out) {
        this(out, System.getProperty("line.separator"));
    }

    public void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
    }

    public void pushIndentation(String indent) {
        this.indents.add(indent);
    }

    public String popIndentation() {
        return this.indents.remove(this.indents.size() - 1);
    }

    public void pushAnchorPoint() {
        if (this.anchors_sp + 1 >= this.anchors.length) {
            int[] a15 = new int[this.anchors.length * 2];
            System.arraycopy(this.anchors, 0, a15, 0, this.anchors.length - 1);
            this.anchors = a15;
        }
        ++this.anchors_sp;
        this.anchors[this.anchors_sp] = this.charPosition;
    }

    public void popAnchorPoint() {
        --this.anchors_sp;
    }

    public int index() {
        return this.charIndex;
    }

    public int write(String str) throws IOException {
        int n15 = 0;
        int nll = this.newline.length();
        int sl4 = str.length();
        for (int i15 = 0; i15 < sl4; ++i15) {
            char c15 = str.charAt(i15);
            if (c15 == '\r') continue;
            if (c15 == '\n') {
                this.atStartOfLine = true;
                this.charPosition = -nll;
                this.out.write(this.newline);
                this.charIndex += nll;
                this.charPosition += (n15 += nll);
                continue;
            }
            if (this.atStartOfLine) {
                n15 += this.indent();
                this.atStartOfLine = false;
            }
            ++n15;
            this.out.write(c15);
            ++this.charPosition;
            ++this.charIndex;
        }
        return n15;
    }

    public int writeSeparator(String str) throws IOException {
        return this.write(str);
    }

    public int write(String str, String wrap) throws IOException {
        int n15 = this.writeWrap(wrap);
        return n15 + this.write(str);
    }

    public int writeWrap(String wrap) throws IOException {
        int n15 = 0;
        if (this.lineWidth != -1 && wrap != null && !this.atStartOfLine && this.charPosition >= this.lineWidth) {
            for (int i15 = 0; i15 < wrap.length(); ++i15) {
                char c15 = wrap.charAt(i15);
                if (c15 == '\r') continue;
                if (c15 == '\n') {
                    this.out.write(this.newline);
                    n15 += this.newline.length();
                    this.charPosition = 0;
                    this.charIndex += this.newline.length();
                    n15 += this.indent();
                    continue;
                }
                ++n15;
                this.out.write(c15);
                ++this.charPosition;
                ++this.charIndex;
            }
        }
        return n15;
    }

    public int indent() throws IOException {
        int n15 = 0;
        for (String ind : this.indents) {
            if (ind == null) continue;
            n15 += ind.length();
            this.out.write(ind);
        }
        int indentWidth = n15;
        if (this.anchors_sp >= 0 && this.anchors[this.anchors_sp] > indentWidth) {
            int remainder = this.anchors[this.anchors_sp] - indentWidth;
            for (int i15 = 1; i15 <= remainder; ++i15) {
                this.out.write(32);
            }
            n15 += remainder;
        }
        this.charPosition += n15;
        this.charIndex += n15;
        return n15;
    }
}

