/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import org.fife.ui.autocomplete.BasicCompletion;
import org.fife.ui.autocomplete.CompletionProvider;

public class VariableCompletion
extends BasicCompletion {
    private String type;
    private String definedIn;

    public VariableCompletion(CompletionProvider provider, String name, String type) {
        super(provider, name);
        this.type = type;
    }

    protected void addDefinitionString(StringBuilder sb5) {
        sb5.append("<html><b>").append(this.getDefinitionString()).append("</b>");
    }

    public String getDefinitionString() {
        StringBuilder sb5 = new StringBuilder();
        if (this.type != null) {
            sb5.append(this.type).append(' ');
        }
        sb5.append(this.getName());
        return sb5.toString();
    }

    public String getDefinedIn() {
        return this.definedIn;
    }

    public String getName() {
        return this.getReplacementText();
    }

    @Override
    public String getSummary() {
        StringBuilder sb5 = new StringBuilder();
        this.addDefinitionString(sb5);
        this.possiblyAddDescription(sb5);
        this.possiblyAddDefinedIn(sb5);
        return sb5.toString();
    }

    @Override
    public String getToolTipText() {
        return this.getDefinitionString();
    }

    public String getType() {
        return this.type;
    }

    protected void possiblyAddDefinedIn(StringBuilder sb5) {
        if (this.definedIn != null) {
            sb5.append("<hr>Defined in:");
            sb5.append(" <em>").append(this.definedIn).append("</em>");
        }
    }

    protected boolean possiblyAddDescription(StringBuilder sb5) {
        if (this.getShortDescription() != null) {
            sb5.append("<hr><br>");
            sb5.append(this.getShortDescription());
            sb5.append("<br><br><br>");
            return true;
        }
        return false;
    }

    public void setDefinedIn(String definedIn) {
        this.definedIn = definedIn;
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

