/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.swing.section.caret;

import java.awt.Graphics;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.bined.CodeAreaUtils;
import org.exbin.bined.section.caret.CodeAreaCaretShape;
import org.exbin.bined.section.caret.CodeAreaCaretType;
import org.exbin.bined.section.caret.DefaultCodeAreaCaretShape;
import org.exbin.bined.swing.section.caret.SectionCodeAreaCaretsProfile;

@ParametersAreNonnullByDefault
public class DefaultExtendedCodeAreaCaretsProfile
implements SectionCodeAreaCaretsProfile {
    @Override
    @Nonnull
    public CodeAreaCaretShape identifyCaretShape(CodeAreaCaretType caretType) {
        switch (caretType) {
            case INSERT: {
                return DefaultCodeAreaCaretShape.LINE;
            }
            case OVERWRITE: {
                return DefaultCodeAreaCaretShape.FULL_BOX;
            }
            case SHADOW: {
                return DefaultCodeAreaCaretShape.DOTTED_BOX;
            }
        }
        throw CodeAreaUtils.getInvalidTypeException(caretType);
    }

    @Override
    public void paintCaret(Graphics g15, int cursorX, int cursorY, int width, int height, CodeAreaCaretShape codeAreaCaretShape) {
        g15.fillRect(cursorX, cursorY, width, height);
        if (codeAreaCaretShape instanceof DefaultCodeAreaCaretShape) {
            switch ((DefaultCodeAreaCaretShape)codeAreaCaretShape) {
                case FULL_BOX: {
                    break;
                }
                case LINE: {
                    break;
                }
            }
        }
    }
}

