/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.text.similarity.SimilarityInput;
import org.apache.commons.text.similarity.SimilarityScore;

public class JaroWinklerSimilarity
implements SimilarityScore<Double> {
    static final JaroWinklerSimilarity INSTANCE = new JaroWinklerSimilarity();

    protected static int[] matches(CharSequence first, CharSequence second) {
        return JaroWinklerSimilarity.matches(SimilarityInput.input(first), SimilarityInput.input(second));
    }

    protected static <E> int[] matches(SimilarityInput<E> first, SimilarityInput<E> second) {
        int i15;
        SimilarityInput<E> min;
        SimilarityInput<E> max;
        if (first.length() > second.length()) {
            max = first;
            min = second;
        } else {
            max = second;
            min = first;
        }
        int range = Math.max(max.length() / 2 - 1, 0);
        int[] matchIndexes = new int[min.length()];
        Arrays.fill(matchIndexes, -1);
        boolean[] matchFlags = new boolean[max.length()];
        int matches = 0;
        block0: for (int mi4 = 0; mi4 < min.length(); ++mi4) {
            E c15 = min.at(mi4);
            int xn4 = Math.min(mi4 + range + 1, max.length());
            for (int xi4 = Math.max(mi4 - range, 0); xi4 < xn4; ++xi4) {
                if (matchFlags[xi4] || !c15.equals(max.at(xi4))) continue;
                matchIndexes[mi4] = xi4;
                matchFlags[xi4] = true;
                ++matches;
                continue block0;
            }
        }
        Object[] ms12 = new Object[matches];
        Object[] ms22 = new Object[matches];
        int si4 = 0;
        for (i15 = 0; i15 < min.length(); ++i15) {
            if (matchIndexes[i15] == -1) continue;
            ms12[si4] = min.at(i15);
            ++si4;
        }
        si4 = 0;
        for (i15 = 0; i15 < max.length(); ++i15) {
            if (!matchFlags[i15]) continue;
            ms22[si4] = max.at(i15);
            ++si4;
        }
        int halfTranspositions = 0;
        for (int mi5 = 0; mi5 < ms12.length; ++mi5) {
            if (ms12[mi5].equals(ms22[mi5])) continue;
            ++halfTranspositions;
        }
        int prefix = 0;
        for (int mi6 = 0; mi6 < Math.min(4, min.length()) && first.at(mi6).equals(second.at(mi6)); ++mi6) {
            ++prefix;
        }
        return new int[]{matches, halfTranspositions, prefix};
    }

    @Override
    public Double apply(CharSequence left, CharSequence right) {
        return this.apply(SimilarityInput.input(left), SimilarityInput.input(right));
    }

    @Override
    public <E> Double apply(SimilarityInput<E> left, SimilarityInput<E> right) {
        double defaultScalingFactor = 0.1;
        if (left == null || right == null) {
            throw new IllegalArgumentException("CharSequences must not be null");
        }
        if (Objects.equals(left, right)) {
            return 1.0;
        }
        int[] mtp = JaroWinklerSimilarity.matches(left, right);
        double m15 = mtp[0];
        if (m15 == 0.0) {
            return 0.0;
        }
        double j15 = (m15 / (double)left.length() + m15 / (double)right.length() + (m15 - (double)mtp[1] / 2.0) / m15) / 3.0;
        return j15 < 0.7 ? j15 : j15 + 0.1 * (double)mtp[2] * (1.0 - j15);
    }
}

