/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import org.apache.commons.text.similarity.EditDistance;
import org.apache.commons.text.similarity.SimilarityInput;

public class HammingDistance
implements EditDistance<Integer> {
    @Override
    public Integer apply(CharSequence left, CharSequence right) {
        return this.apply(SimilarityInput.input(left), SimilarityInput.input(right));
    }

    @Override
    public <E> Integer apply(SimilarityInput<E> left, SimilarityInput<E> right) {
        if (left == null || right == null) {
            throw new IllegalArgumentException("SimilarityInput must not be null");
        }
        if (left.length() != right.length()) {
            throw new IllegalArgumentException("SimilarityInput must have the same length");
        }
        int distance = 0;
        for (int i15 = 0; i15 < left.length(); ++i15) {
            if (left.at(i15).equals(right.at(i15))) continue;
            ++distance;
        }
        return distance;
    }
}

