/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class CharUtils {
    private static final String[] CHAR_STRING_ARRAY = ArrayUtils.setAll(new String[128], i15 -> String.valueOf((char)i15));
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final char LF = '\n';
    public static final char CR = '\r';
    public static final char NUL = '\u0000';

    public static int compare(char x15, char y15) {
        return x15 - y15;
    }

    public static boolean isAscii(char ch4) {
        return ch4 < '\u0080';
    }

    public static boolean isAsciiAlpha(char ch4) {
        return CharUtils.isAsciiAlphaUpper(ch4) || CharUtils.isAsciiAlphaLower(ch4);
    }

    public static boolean isAsciiAlphaLower(char ch4) {
        return ch4 >= 'a' && ch4 <= 'z';
    }

    public static boolean isAsciiAlphanumeric(char ch4) {
        return CharUtils.isAsciiAlpha(ch4) || CharUtils.isAsciiNumeric(ch4);
    }

    public static boolean isAsciiAlphaUpper(char ch4) {
        return ch4 >= 'A' && ch4 <= 'Z';
    }

    public static boolean isAsciiControl(char ch4) {
        return ch4 < ' ' || ch4 == '\u007f';
    }

    public static boolean isAsciiNumeric(char ch4) {
        return ch4 >= '0' && ch4 <= '9';
    }

    public static boolean isAsciiPrintable(char ch4) {
        return ch4 >= ' ' && ch4 < '\u007f';
    }

    public static boolean isHex(char ch4) {
        return CharUtils.isAsciiNumeric(ch4) || ch4 >= 'a' && ch4 <= 'f' || ch4 >= 'A' && ch4 <= 'F';
    }

    public static boolean isOctal(char ch4) {
        return ch4 >= '0' && ch4 <= '7';
    }

    public static char toChar(Character ch4) {
        return Objects.requireNonNull(ch4, "ch").charValue();
    }

    public static char toChar(Character ch4, char defaultValue) {
        return ch4 != null ? ch4.charValue() : defaultValue;
    }

    public static char toChar(String str) {
        Validate.notEmpty(str, "The String must not be empty", new Object[0]);
        return str.charAt(0);
    }

    public static char toChar(String str, char defaultValue) {
        return StringUtils.isEmpty(str) ? defaultValue : str.charAt(0);
    }

    @Deprecated
    public static Character toCharacterObject(char c15) {
        return Character.valueOf(c15);
    }

    public static Character toCharacterObject(String str) {
        return StringUtils.isEmpty(str) ? null : Character.valueOf(str.charAt(0));
    }

    public static int toIntValue(char ch4) {
        if (!CharUtils.isAsciiNumeric(ch4)) {
            throw new IllegalArgumentException("The character " + ch4 + " is not in the range '0' - '9'");
        }
        return ch4 - 48;
    }

    public static int toIntValue(char ch4, int defaultValue) {
        return CharUtils.isAsciiNumeric(ch4) ? ch4 - 48 : defaultValue;
    }

    public static int toIntValue(Character ch4) {
        return CharUtils.toIntValue(CharUtils.toChar(ch4));
    }

    public static int toIntValue(Character ch4, int defaultValue) {
        return ch4 != null ? CharUtils.toIntValue(ch4.charValue(), defaultValue) : defaultValue;
    }

    public static String toString(char ch4) {
        if (ch4 < CHAR_STRING_ARRAY.length) {
            return CHAR_STRING_ARRAY[ch4];
        }
        return String.valueOf(ch4);
    }

    public static String toString(Character ch4) {
        return ch4 != null ? CharUtils.toString(ch4.charValue()) : null;
    }

    public static String unicodeEscaped(char ch4) {
        return "\\u" + HEX_DIGITS[ch4 >> 12 & 0xF] + HEX_DIGITS[ch4 >> 8 & 0xF] + HEX_DIGITS[ch4 >> 4 & 0xF] + HEX_DIGITS[ch4 & 0xF];
    }

    public static String unicodeEscaped(Character ch4) {
        return ch4 != null ? CharUtils.unicodeEscaped(ch4.charValue()) : null;
    }

    @Deprecated
    public CharUtils() {
    }
}

