/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.mappingio.format.tiny;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.mappingio.MappedElementKind;
import net.fabricmc.mappingio.MappingFlag;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.format.ColumnFileReader;

public final class Tiny2FileReader {
    private Tiny2FileReader() {
    }

    public static List<String> getNamespaces(Reader reader) throws IOException {
        return Tiny2FileReader.getNamespaces(new ColumnFileReader(reader, '\t', '\t'));
    }

    private static List<String> getNamespaces(ColumnFileReader reader) throws IOException {
        String ns4;
        if (!reader.nextCol("tiny") || reader.nextIntCol() != 2 || reader.nextIntCol() < 0) {
            throw new IOException("invalid/unsupported tiny file: no tiny 2 header");
        }
        ArrayList<String> ret = new ArrayList<String>();
        while ((ns4 = reader.nextCol()) != null) {
            ret.add(ns4);
        }
        return ret;
    }

    public static void read(Reader reader, MappingVisitor visitor2) throws IOException {
        Tiny2FileReader.read(new ColumnFileReader(reader, '\t', '\t'), visitor2);
    }

    private static void read(ColumnFileReader reader, MappingVisitor visitor2) throws IOException {
        block16: {
            int markIdx;
            if (!reader.nextCol("tiny") || reader.nextIntCol() != 2 || reader.nextIntCol() < 0) {
                throw new IOException("invalid/unsupported tiny file: no tiny 2 header");
            }
            String srcNamespace = reader.nextCol();
            if (srcNamespace == null || srcNamespace.isEmpty()) {
                throw new IOException("no source namespace in Tiny v2 header");
            }
            ArrayList<String> dstNamespaces = new ArrayList<String>();
            while (!reader.isAtEol()) {
                String dstNamespace = reader.nextCol();
                if (dstNamespace == null || dstNamespace.isEmpty()) {
                    throw new IOException("empty destination namespace in Tiny v2 header");
                }
                dstNamespaces.add(dstNamespace);
            }
            int dstNsCount = dstNamespaces.size();
            boolean readerMarked = false;
            if (visitor2.getFlags().contains((Object)MappingFlag.NEEDS_MULTIPLE_PASSES)) {
                reader.mark();
                readerMarked = true;
            }
            boolean firstIteration = true;
            boolean escapeNames = false;
            while (true) {
                boolean visitHeader;
                if (visitHeader = visitor2.visitHeader()) {
                    visitor2.visitNamespaces(srcNamespace, dstNamespaces);
                }
                if (visitHeader || firstIteration) {
                    while (reader.nextLine(1)) {
                        if (!visitHeader) {
                            if (escapeNames || !reader.nextCol("escaped-names")) continue;
                            escapeNames = true;
                            continue;
                        }
                        String key = reader.nextCol();
                        if (key == null) {
                            throw new IOException("missing property key in line " + reader.getLineNumber());
                        }
                        String value = reader.nextCol(true);
                        if (key.equals("escaped-names")) {
                            escapeNames = true;
                        }
                        visitor2.visitMetadata(key, value);
                    }
                }
                if (visitor2.visitContent()) {
                    while (reader.nextLine(0)) {
                        if (!reader.nextCol("c")) continue;
                        String srcName = reader.nextCol(escapeNames);
                        if (srcName == null || srcName.isEmpty()) {
                            throw new IOException("missing class-name-a in line " + reader.getLineNumber());
                        }
                        if (!visitor2.visitClass(srcName)) continue;
                        Tiny2FileReader.readClass(reader, dstNsCount, escapeNames, visitor2);
                    }
                }
                if (visitor2.visitEnd()) break block16;
                if (!readerMarked) {
                    throw new IllegalStateException("repeated visitation requested without NEEDS_MULTIPLE_PASSES");
                }
                firstIteration = false;
                markIdx = reader.reset();
                assert (markIdx == 1);
            }
        }
    }

    private static void readClass(ColumnFileReader reader, int dstNsCount, boolean escapeNames, MappingVisitor visitor2) throws IOException {
        Tiny2FileReader.readDstNames(reader, MappedElementKind.CLASS, dstNsCount, escapeNames, visitor2);
        if (!visitor2.visitElementContent(MappedElementKind.CLASS)) {
            return;
        }
        while (reader.nextLine(1)) {
            String srcName;
            String srcDesc;
            if (reader.nextCol("f")) {
                srcDesc = reader.nextCol(escapeNames);
                if (srcDesc == null || srcDesc.isEmpty()) {
                    throw new IOException("missing field-desc-a in line " + reader.getLineNumber());
                }
                srcName = reader.nextCol(escapeNames);
                if (srcName == null || srcName.isEmpty()) {
                    throw new IOException("missing field-name-a in line " + reader.getLineNumber());
                }
                if (!visitor2.visitField(srcName, srcDesc)) continue;
                Tiny2FileReader.readElement(reader, MappedElementKind.FIELD, dstNsCount, escapeNames, visitor2);
                continue;
            }
            if (reader.nextCol("m")) {
                srcDesc = reader.nextCol(escapeNames);
                if (srcDesc == null || srcDesc.isEmpty()) {
                    throw new IOException("missing method-desc-a in line " + reader.getLineNumber());
                }
                srcName = reader.nextCol(escapeNames);
                if (srcName == null || srcName.isEmpty()) {
                    throw new IOException("missing method-name-a in line " + reader.getLineNumber());
                }
                if (!visitor2.visitMethod(srcName, srcDesc)) continue;
                Tiny2FileReader.readMethod(reader, dstNsCount, escapeNames, visitor2);
                continue;
            }
            if (!reader.nextCol("c")) continue;
            Tiny2FileReader.readComment(reader, MappedElementKind.CLASS, visitor2);
        }
    }

    private static void readMethod(ColumnFileReader reader, int dstNsCount, boolean escapeNames, MappingVisitor visitor2) throws IOException {
        Tiny2FileReader.readDstNames(reader, MappedElementKind.METHOD, dstNsCount, escapeNames, visitor2);
        if (!visitor2.visitElementContent(MappedElementKind.METHOD)) {
            return;
        }
        while (reader.nextLine(2)) {
            int lvIndex;
            if (reader.nextCol("p")) {
                lvIndex = reader.nextIntCol();
                if (lvIndex < 0) {
                    throw new IOException("missing/invalid parameter-lv-index in line " + reader.getLineNumber());
                }
                String srcName = reader.nextCol(escapeNames);
                if (srcName == null) {
                    throw new IOException("missing parameter-name-a column in line " + reader.getLineNumber());
                }
                if (srcName.isEmpty()) {
                    srcName = null;
                }
                if (!visitor2.visitMethodArg(-1, lvIndex, srcName)) continue;
                Tiny2FileReader.readElement(reader, MappedElementKind.METHOD_ARG, dstNsCount, escapeNames, visitor2);
                continue;
            }
            if (reader.nextCol("v")) {
                lvIndex = reader.nextIntCol();
                if (lvIndex < 0) {
                    throw new IOException("missing/invalid variable-lv-index in line " + reader.getLineNumber());
                }
                int startOpIdx = reader.nextIntCol();
                if (startOpIdx < 0) {
                    throw new IOException("missing/invalid variable-lv-start-offset in line " + reader.getLineNumber());
                }
                int lvtRowIndex = reader.nextIntCol();
                String srcName = reader.nextCol(escapeNames);
                if (srcName == null) {
                    throw new IOException("missing variable-name-a column in line " + reader.getLineNumber());
                }
                if (srcName.isEmpty()) {
                    srcName = null;
                }
                if (!visitor2.visitMethodVar(lvtRowIndex, lvIndex, startOpIdx, -1, srcName)) continue;
                Tiny2FileReader.readElement(reader, MappedElementKind.METHOD_VAR, dstNsCount, escapeNames, visitor2);
                continue;
            }
            if (!reader.nextCol("c")) continue;
            Tiny2FileReader.readComment(reader, MappedElementKind.METHOD, visitor2);
        }
    }

    private static void readElement(ColumnFileReader reader, MappedElementKind kind2, int dstNsCount, boolean escapeNames, MappingVisitor visitor2) throws IOException {
        Tiny2FileReader.readDstNames(reader, kind2, dstNsCount, escapeNames, visitor2);
        if (!visitor2.visitElementContent(kind2)) {
            return;
        }
        while (reader.nextLine(kind2.level + 1)) {
            if (!reader.nextCol("c")) continue;
            Tiny2FileReader.readComment(reader, kind2, visitor2);
        }
    }

    private static void readComment(ColumnFileReader reader, MappedElementKind subjectKind, MappingVisitor visitor2) throws IOException {
        String comment = reader.nextCol(true);
        if (comment == null) {
            throw new IOException("missing comment in line " + reader.getLineNumber());
        }
        visitor2.visitComment(subjectKind, comment);
    }

    private static void readDstNames(ColumnFileReader reader, MappedElementKind subjectKind, int dstNsCount, boolean escapeNames, MappingVisitor visitor2) throws IOException {
        for (int dstNs = 0; dstNs < dstNsCount; ++dstNs) {
            String name = reader.nextCol(escapeNames);
            if (name == null) {
                throw new IOException("missing name columns in line " + reader.getLineNumber());
            }
            if (name.isEmpty()) continue;
            visitor2.visitDstName(subjectKind, dstNs, name);
        }
    }
}

