/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.treemodel;

import jadx.api.ResourceFile;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.gui.JadxWrapper;
import jadx.gui.settings.JadxProject;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JInputs;
import jadx.gui.treemodel.JNode;
import jadx.gui.treemodel.JResource;
import jadx.gui.treemodel.JSources;
import jadx.gui.ui.MainWindow;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.Nullable;

public class JRoot
extends JNode {
    private static final long serialVersionUID = 8888495789773527342L;
    private static final ImageIcon ROOT_ICON = UiUtils.openSvgIcon("nodes/rootPackageFolder");
    private final transient JadxWrapper wrapper;
    private final transient MainWindow mainWindow;
    private transient boolean flatPackages = false;
    private final transient List<JNode> customNodes = new ArrayList<JNode>();

    public JRoot(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        this.wrapper = mainWindow.getWrapper();
    }

    public final void update() {
        this.removeAllChildren();
        this.add(new JInputs(this.mainWindow));
        this.add(new JSources(this, this.wrapper));
        List<ResourceFile> resources = this.wrapper.getResources();
        if (!resources.isEmpty()) {
            this.add(this.getHierarchyResources(resources));
        }
        for (JNode customNode : this.customNodes) {
            this.add(customNode);
        }
    }

    private JResource getHierarchyResources(List<ResourceFile> resources) {
        JResource root = new JResource(null, NLS.str("tree.resources_title"), JResource.JResType.ROOT);
        String splitPathStr = Pattern.quote(File.separator);
        for (ResourceFile rf5 : resources) {
            String rfName = rf5.getZipEntry() != null ? rf5.getDeobfName() : new File(rf5.getDeobfName()).getName();
            String[] parts = new File(rfName).getPath().split(splitPathStr);
            JResource curRf = root;
            int count = parts.length;
            for (int i15 = 0; i15 < count - 1; ++i15) {
                String name = parts[i15];
                JResource subRF = JRoot.getSubNodeByName(curRf, name);
                if (subRF == null) {
                    subRF = new JResource(null, name, JResource.JResType.DIR);
                    curRf.addSubNode(subRF);
                }
                curRf = subRF;
            }
            JResource leaf = new JResource(rf5, rf5.getDeobfName(), parts[count - 1], JResource.JResType.FILE);
            curRf.addSubNode(leaf);
        }
        root.sortSubNodes();
        root.update();
        return root;
    }

    public static JResource getSubNodeByName(JResource rf5, String name) {
        for (JResource sub : rf5.getSubNodes()) {
            if (!sub.getName().equals(name)) continue;
            return sub;
        }
        return null;
    }

    @Nullable
    public JResource searchResourceByName(String name) {
        Enumeration<TreeNode> en4 = this.breadthFirstEnumeration();
        while (en4.hasMoreElements()) {
            JResource res;
            TreeNode obj = en4.nextElement();
            if (!(obj instanceof JResource) || !(res = (JResource)obj).getName().equals(name)) continue;
            return res;
        }
        return null;
    }

    @Nullable
    public JNode searchNode(JNode node) {
        Enumeration<TreeNode> en4 = this.breadthFirstEnumeration();
        while (en4.hasMoreElements()) {
            TreeNode obj = en4.nextElement();
            if (!node.equals(obj)) continue;
            return (JNode)obj;
        }
        return null;
    }

    public JNode followStaticPath(String ... path) {
        List<String> list2 = Arrays.asList(path);
        JNode node = JRoot.getNodeByClsPath(this, 0, list2);
        if (node == null) {
            throw new JadxRuntimeException("Incorrect static path in tree: " + String.valueOf(list2));
        }
        return node;
    }

    @Nullable
    private static JNode getNodeByClsPath(JNode start, int pos, List<String> path) {
        if (pos >= path.size()) {
            return start;
        }
        String clsName = path.get(pos);
        Enumeration<TreeNode> en4 = start.children();
        while (en4.hasMoreElements()) {
            JNode node = (JNode)en4.nextElement();
            if (!node.getClass().getSimpleName().equals(clsName)) continue;
            return JRoot.getNodeByClsPath(node, pos + 1, path);
        }
        return null;
    }

    public boolean isFlatPackages() {
        return this.flatPackages;
    }

    public void setFlatPackages(boolean flatPackages) {
        if (this.flatPackages != flatPackages) {
            this.flatPackages = flatPackages;
            this.update();
        }
    }

    public void replaceCustomNode(@Nullable JNode node) {
        if (node == null) {
            return;
        }
        Class<?> nodeCls = node.getClass();
        this.customNodes.removeIf(n15 -> n15.getClass().equals(nodeCls));
        this.customNodes.add(node);
    }

    public List<JNode> getCustomNodes() {
        return this.customNodes;
    }

    @Override
    public Icon getIcon() {
        return ROOT_ICON;
    }

    @Override
    public JClass getJParent() {
        return null;
    }

    @Override
    public String getID() {
        return "JRoot";
    }

    @Override
    public String makeString() {
        JadxProject project = this.wrapper.getProject();
        if (project.getProjectPath() != null) {
            return project.getName();
        }
        List<Path> paths = project.getFilePaths();
        int count = paths.size();
        if (count == 0) {
            return "File not open";
        }
        if (count == 1) {
            Path fileNamePath = paths.get(0).getFileName();
            if (fileNamePath != null) {
                return fileNamePath.toString();
            }
            return paths.get(0).toString();
        }
        return count + " files";
    }

    @Override
    public String getTooltip() {
        List<Path> paths = this.wrapper.getProject().getFilePaths();
        int count = paths.size();
        if (count < 2) {
            return null;
        }
        StringBuilder sb5 = new StringBuilder("<html>");
        for (Path p15 : paths) {
            sb5.append(UiUtils.escapeHtml(p15.toString()));
            sb5.append("<br>");
        }
        sb5.append("</html>");
        return sb5.toString();
    }
}

