/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.settings.font;

import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.fonts.inter.FlatInterFont;
import com.formdev.flatlaf.fonts.jetbrains_mono.FlatJetBrainsMonoFont;
import com.formdev.flatlaf.util.FontUtils;
import jadx.gui.settings.JadxSettingsData;
import jadx.gui.settings.font.FontAdapter;
import jadx.gui.utils.UiUtils;
import java.awt.Font;
import javax.swing.UIManager;

public class FontSettings {
    private final FontAdapter uiFontAdapter;
    private final FontAdapter codeFontAdapter;
    private final FontAdapter smaliFontAdapter;
    private float uiZoom;
    private boolean applyUiZoomToFonts;

    public FontSettings() {
        int defFontSize = 13;
        Font defUiFont = FontUtils.getCompositeFont("Inter", 0, defFontSize);
        Font defCodeFont = FontUtils.getCompositeFont("JetBrains Mono", 0, defFontSize);
        this.uiFontAdapter = new FontAdapter(defUiFont);
        this.codeFontAdapter = new FontAdapter(defCodeFont);
        this.smaliFontAdapter = new FontAdapter(defCodeFont);
    }

    public void bindData(JadxSettingsData data) {
        this.uiFontAdapter.bindData(data.getUiFontStr(), data::setUiFontStr);
        this.codeFontAdapter.bindData(data.getCodeFontStr(), data::setCodeFontStr);
        this.smaliFontAdapter.bindData(data.getSmaliFontStr(), data::setSmaliFontStr);
        this.applyUiZoom(data.getUiZoom(), data.isApplyUiZoomToFonts());
    }

    public void updateDefaultFont() {
        Font defaultFont = UIManager.getFont("defaultFont");
        if (defaultFont != null) {
            this.uiFontAdapter.setDefaultFont(defaultFont);
        }
    }

    public synchronized void applyUiZoom(float newUiZoom, boolean newApplyUiZoomToFonts) {
        if (UiUtils.nearlyEqual(this.uiZoom, newUiZoom) && this.applyUiZoomToFonts == newApplyUiZoomToFonts) {
            return;
        }
        this.uiZoom = newUiZoom;
        this.applyUiZoomToFonts = newApplyUiZoomToFonts;
        float effectiveFontZoom = newApplyUiZoomToFonts ? newUiZoom : 1.0f;
        this.uiFontAdapter.setUiZoom(effectiveFontZoom);
        this.codeFontAdapter.setUiZoom(effectiveFontZoom);
        this.smaliFontAdapter.setUiZoom(effectiveFontZoom);
    }

    public FontAdapter getUiFontAdapter() {
        return this.uiFontAdapter;
    }

    public FontAdapter getCodeFontAdapter() {
        return this.codeFontAdapter;
    }

    public FontAdapter getSmaliFontAdapter() {
        return this.smaliFontAdapter;
    }

    static {
        FlatInterFont.install();
        FlatJetBrainsMonoFont.install();
        FlatLaf.setPreferredMonospacedFontFamily("JetBrains Mono");
    }
}

