/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.xmlgen;

import jadx.api.ICodeInfo;
import jadx.api.ICodeWriter;
import jadx.core.xmlgen.ParserConstants;
import jadx.core.xmlgen.ResourceStorage;
import jadx.core.xmlgen.entry.ResourceEntry;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Locale;

public class XmlGenUtils {
    private XmlGenUtils() {
    }

    public static byte[] readData(InputStream i15) throws IOException {
        int read;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((read = i15.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, read);
        }
        return buffer.toByteArray();
    }

    public static ICodeInfo makeXmlDump(ICodeWriter writer, ResourceStorage resStorage) {
        writer.add("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        writer.startLine("<resources>");
        writer.incIndent();
        HashSet<CallSite> addedValues = new HashSet<CallSite>();
        for (ResourceEntry ri4 : resStorage.getResources()) {
            if (!addedValues.add((CallSite)((Object)(ri4.getTypeName() + "." + ri4.getKeyName())))) continue;
            String format = String.format("<public type=\"%s\" name=\"%s\" id=\"0x%08x\" />", ri4.getTypeName(), ri4.getKeyName(), ri4.getId());
            writer.startLine(format);
        }
        writer.decIndent();
        writer.startLine("</resources>");
        return writer.finish();
    }

    public static String decodeComplex(int data, boolean isFraction) {
        Object unit;
        double value = (double)(data & 0xFFFFFF00) * ParserConstants.RADIX_MULTS[data >> 4 & 3];
        int unitType = data & 0xF;
        if (isFraction) {
            value *= 100.0;
            switch (unitType) {
                case 0: {
                    unit = "%";
                    break;
                }
                case 1: {
                    unit = "%p";
                    break;
                }
                default: {
                    unit = "?f" + Integer.toHexString(unitType);
                    break;
                }
            }
        } else {
            switch (unitType) {
                case 0: {
                    unit = "px";
                    break;
                }
                case 1: {
                    unit = "dp";
                    break;
                }
                case 2: {
                    unit = "sp";
                    break;
                }
                case 3: {
                    unit = "pt";
                    break;
                }
                case 4: {
                    unit = "in";
                    break;
                }
                case 5: {
                    unit = "mm";
                    break;
                }
                default: {
                    unit = "?d" + Integer.toHexString(unitType);
                }
            }
        }
        return XmlGenUtils.doubleToString(value) + (String)unit;
    }

    public static String doubleToString(double value) {
        if (Double.compare(value, Math.floor(value)) == 0 && !Double.isInfinite(value)) {
            return Integer.toString((int)value);
        }
        NumberFormat f15 = NumberFormat.getInstance(Locale.ROOT);
        f15.setMaximumFractionDigits(4);
        f15.setMinimumIntegerDigits(1);
        return f15.format(value);
    }

    public static String floatToString(float value) {
        return XmlGenUtils.doubleToString(value);
    }

    public static String getAttrTypeAsString(int type) {
        Object s15 = "";
        if ((type & 1) != 0) {
            s15 = (String)s15 + "|reference";
        }
        if ((type & 2) != 0) {
            s15 = (String)s15 + "|string";
        }
        if ((type & 4) != 0) {
            s15 = (String)s15 + "|integer";
        }
        if ((type & 8) != 0) {
            s15 = (String)s15 + "|boolean";
        }
        if ((type & 0x10) != 0) {
            s15 = (String)s15 + "|color";
        }
        if ((type & 0x20) != 0) {
            s15 = (String)s15 + "|float";
        }
        if ((type & 0x40) != 0) {
            s15 = (String)s15 + "|dimension";
        }
        if ((type & 0x80) != 0) {
            s15 = (String)s15 + "|fraction";
        }
        if (((String)s15).isEmpty()) {
            return null;
        }
        return ((String)s15).substring(1);
    }
}

