/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils;

import jadx.core.dex.attributes.AType;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.utils.DebugChecks;
import jadx.core.utils.exceptions.JadxException;

public class DebugChecksPass
extends AbstractVisitor {
    private final String visitorName;

    public DebugChecksPass(String visitorName) {
        this.visitorName = visitorName;
    }

    @Override
    public String getName() {
        return "Checks-for-" + this.visitorName;
    }

    @Override
    public void visit(MethodNode mth) throws JadxException {
        if (!mth.contains(AType.JADX_ERROR)) {
            try {
                DebugChecks.runChecksAfterVisitor(mth, this.visitorName);
            }
            catch (Exception e15) {
                mth.addError("Check error", e15);
            }
        }
    }
}

