/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.regions.maker;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.EdgeInsnAttr;
import jadx.core.dex.attributes.nodes.LoopInfo;
import jadx.core.dex.instructions.IfNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.IRegion;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.regions.Region;
import jadx.core.dex.regions.conditions.IfCondition;
import jadx.core.dex.regions.conditions.IfInfo;
import jadx.core.dex.regions.conditions.IfRegion;
import jadx.core.dex.regions.loops.LoopRegion;
import jadx.core.dex.trycatch.ExcHandlerAttr;
import jadx.core.dex.visitors.regions.maker.RegionMaker;
import jadx.core.dex.visitors.regions.maker.RegionStack;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.blocks.BlockSet;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class IfRegionMaker {
    private static final Logger LOG = LoggerFactory.getLogger(IfRegionMaker.class);
    private final MethodNode mth;
    private final RegionMaker regionMaker;

    IfRegionMaker(MethodNode mth, RegionMaker regionMaker) {
        this.mth = mth;
        this.regionMaker = regionMaker;
    }

    BlockNode process(IRegion currentRegion, BlockNode block, IfNode ifnode, RegionStack stack) {
        List edgeInsnAttrs;
        if (block.contains(AFlag.ADDED_TO_REGION)) {
            return ifnode.getThenBlock();
        }
        IfInfo currentIf = IfRegionMaker.makeIfInfo(this.mth, block);
        if (currentIf == null) {
            return null;
        }
        IfInfo mergedIf = IfRegionMaker.mergeNestedIfNodes(currentIf);
        IfInfo modifiedIf = IfRegionMaker.restructureIf(this.mth, block, currentIf = mergedIf != null ? mergedIf : IfInfo.invert(currentIf));
        if (modifiedIf != null) {
            currentIf = modifiedIf;
        } else {
            if (currentIf.getMergedBlocks().size() <= 1) {
                return null;
            }
            currentIf = IfRegionMaker.makeIfInfo(this.mth, block);
            if ((currentIf = IfRegionMaker.restructureIf(this.mth, block, currentIf)) == null) {
                return null;
            }
        }
        IfRegionMaker.confirmMerge(currentIf);
        IfRegion ifRegion = new IfRegion(currentRegion);
        ifRegion.updateCondition(currentIf);
        currentRegion.getSubBlocks().add(ifRegion);
        BlockNode outBlock = currentIf.getOutBlock();
        stack.push(ifRegion);
        stack.addExit(outBlock);
        BlockNode thenBlock = currentIf.getThenBlock();
        if (thenBlock == null) {
            ifRegion.setThenRegion(new Region(ifRegion));
        } else {
            ifRegion.setThenRegion(this.regionMaker.makeRegion(thenBlock));
        }
        BlockNode elseBlock = currentIf.getElseBlock();
        if (elseBlock == null || stack.containsExit(elseBlock)) {
            ifRegion.setElseRegion(null);
        } else {
            ifRegion.setElseRegion(this.regionMaker.makeRegion(elseBlock));
        }
        if (ifRegion.getElseRegion() == null && outBlock != null && !(edgeInsnAttrs = outBlock.getAll(AType.EDGE_INSN)).isEmpty()) {
            Region elseRegion = new Region(ifRegion);
            for (EdgeInsnAttr edgeInsnAttr : edgeInsnAttrs) {
                if (!edgeInsnAttr.getEnd().equals(outBlock)) continue;
                this.addEdgeInsn(currentIf, elseRegion, edgeInsnAttr);
            }
            ifRegion.setElseRegion(elseRegion);
        }
        stack.pop();
        return outBlock;
    }

    @NotNull
    IfInfo buildIfInfo(LoopRegion loopRegion) {
        IfInfo condInfo = IfRegionMaker.makeIfInfo(this.mth, loopRegion.getHeader());
        condInfo = IfRegionMaker.searchNestedIf(condInfo);
        IfRegionMaker.confirmMerge(condInfo);
        return condInfo;
    }

    private void addEdgeInsn(IfInfo ifInfo, Region region, EdgeInsnAttr edgeInsnAttr) {
        BlockNode start = edgeInsnAttr.getStart();
        boolean fromThisIf = false;
        for (BlockNode ifBlock : ifInfo.getMergedBlocks()) {
            if (!ifBlock.getSuccessors().contains(start)) continue;
            fromThisIf = true;
            break;
        }
        if (!fromThisIf) {
            return;
        }
        region.add(start);
    }

    @Nullable
    static IfInfo makeIfInfo(MethodNode mth, BlockNode ifBlock) {
        InsnNode lastInsn = BlockUtils.getLastInsn(ifBlock);
        if (lastInsn == null || lastInsn.getType() != InsnType.IF) {
            return null;
        }
        IfNode ifNode = (IfNode)lastInsn;
        IfCondition condition2 = IfCondition.fromIfNode(ifNode);
        IfInfo info = new IfInfo(mth, condition2, ifNode.getThenBlock(), ifNode.getElseBlock());
        info.getMergedBlocks().add(ifBlock);
        return info;
    }

    static IfInfo searchNestedIf(IfInfo info) {
        IfInfo next = IfRegionMaker.mergeNestedIfNodes(info);
        if (next != null) {
            return next;
        }
        return info;
    }

    static IfInfo restructureIf(MethodNode mth, BlockNode block, IfInfo info) {
        BlockNode elseBlock;
        BlockNode thenBlock = info.getThenBlock();
        if (Objects.equals(thenBlock, elseBlock = info.getElseBlock())) {
            IfInfo ifInfo = new IfInfo(info, null, null);
            ifInfo.setOutBlock(thenBlock);
            return ifInfo;
        }
        if (thenBlock.contains(AFlag.RETURN) && elseBlock.contains(AFlag.RETURN)) {
            info.setOutBlock(null);
            return info;
        }
        info.setOutBlock(BlockUtils.getPathCross(mth, thenBlock, elseBlock));
        boolean badThen = IfRegionMaker.isBadBranchBlock(info, thenBlock);
        boolean badElse = IfRegionMaker.isBadBranchBlock(info, elseBlock);
        if (badThen && badElse) {
            return null;
        }
        if (badElse) {
            info = new IfInfo(info, thenBlock, null);
            info.setOutBlock(elseBlock);
        } else if (badThen) {
            info = IfInfo.invert(info);
            info = new IfInfo(info, elseBlock, null);
            info.setOutBlock(thenBlock);
        }
        if (info.getOutBlock() == null) {
            BlockNode scopeOutBlockThen = IfRegionMaker.findScopeOutBlock(mth, info.getThenBlock());
            BlockNode scopeOutBlockElse = IfRegionMaker.findScopeOutBlock(mth, info.getElseBlock());
            if (scopeOutBlockThen == null && scopeOutBlockElse != null) {
                info.setOutBlock(scopeOutBlockElse);
            } else if (scopeOutBlockThen != null && scopeOutBlockElse == null) {
                info.setOutBlock(scopeOutBlockThen);
            } else if (scopeOutBlockThen != null && scopeOutBlockThen == scopeOutBlockElse) {
                info.setOutBlock(scopeOutBlockThen);
            }
        }
        if (BlockUtils.isBackEdge(block, info.getOutBlock())) {
            info.setOutBlock(null);
        }
        return info;
    }

    private static boolean isBadBranchBlock(IfInfo info, BlockNode block) {
        BlockNode pred;
        if (block.contains(AFlag.LOOP_START) && block.getPredecessors().size() == 1 && (pred = block.getPredecessors().get(0)).contains(AFlag.LOOP_END)) {
            List startLoops = block.getAll(AType.LOOP);
            List endLoops = pred.getAll(AType.LOOP);
            for (LoopInfo startLoop : startLoops) {
                for (LoopInfo endLoop : endLoops) {
                    if (startLoop != endLoop) continue;
                    return true;
                }
            }
        }
        if (info.getOutBlock() != null) {
            return block == info.getOutBlock();
        }
        return !IfRegionMaker.allPathsFromIf(block, info);
    }

    private static boolean allPathsFromIf(BlockNode block, IfInfo info) {
        List<BlockNode> preds = block.getPredecessors();
        BlockSet ifBlocks = info.getMergedBlocks();
        for (BlockNode pred : preds) {
            BlockNode top;
            if (pred.contains(AFlag.LOOP_END) || ifBlocks.contains(top = BlockUtils.skipSyntheticPredecessor(pred))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static BlockNode findScopeOutBlock(MethodNode mth, BlockNode startBlock) {
        if (startBlock == null) {
            return null;
        }
        List<BlockNode> domFrontiers = BlockUtils.bitSetToBlocks(mth, startBlock.getDomFrontier());
        BlockNode scopeOutBlock = null;
        for (BlockNode domFrontier : domFrontiers) {
            BlockNode topSplitter;
            ExcHandlerAttr handler = domFrontier.get(AType.EXC_HANDLER);
            if (handler == null || !startBlock.isDominator(topSplitter = handler.getTryBlock().getTopSplitter())) continue;
            scopeOutBlock = BlockUtils.getTryAndHandlerCrossBlock(mth, handler.getHandler());
            break;
        }
        return scopeOutBlock;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static IfInfo mergeNestedIfNodes(IfInfo currentIf) {
        boolean assignInlineNeeded;
        boolean followThenBranch;
        BlockNode curElse;
        BlockNode curThen = currentIf.getThenBlock();
        if (curThen == (curElse = currentIf.getElseBlock())) {
            return null;
        }
        if (BlockUtils.isFollowBackEdge(curThen) || BlockUtils.isFollowBackEdge(curElse)) {
            return null;
        }
        IfInfo nextIf = IfRegionMaker.getNextIf(currentIf, curThen);
        if (nextIf != null) {
            followThenBranch = true;
        } else {
            nextIf = IfRegionMaker.getNextIf(currentIf, curElse);
            if (nextIf == null) return null;
            followThenBranch = false;
        }
        boolean bl4 = assignInlineNeeded = !nextIf.getForceInlineInsns().isEmpty();
        if (assignInlineNeeded) {
            for (BlockNode mergedBlock : currentIf.getMergedBlocks()) {
                if (!mergedBlock.contains(AFlag.LOOP_START)) continue;
                return currentIf;
            }
        }
        if (IfRegionMaker.isInversionNeeded(currentIf, nextIf)) {
            nextIf = IfInfo.invert(nextIf);
        }
        boolean thenPathSame = BlockUtils.isEqualPaths(curThen, nextIf.getThenBlock());
        boolean elsePathSame = BlockUtils.isEqualPaths(curElse, nextIf.getElseBlock());
        if (!thenPathSame && !elsePathSame) {
            if (IfRegionMaker.checkConditionBranches(curThen, curElse) || IfRegionMaker.checkConditionBranches(curElse, curThen)) {
                return null;
            }
            BlockNode otherBranchBlock = followThenBranch ? curElse : curThen;
            otherBranchBlock = BlockUtils.followEmptyPath(otherBranchBlock);
            if (!BlockUtils.isPathExists(nextIf.getFirstIfBlock(), otherBranchBlock)) {
                return IfRegionMaker.checkForTernaryInCondition(currentIf);
            }
            IfInfo tmpIf = IfRegionMaker.mergeNestedIfNodes(nextIf);
            if (tmpIf == null) return currentIf;
            nextIf = tmpIf;
            if (IfRegionMaker.isInversionNeeded(currentIf, nextIf)) {
                nextIf = IfInfo.invert(nextIf);
            }
            if (!IfRegionMaker.canMerge(currentIf, nextIf, followThenBranch)) {
                return currentIf;
            }
        } else if (assignInlineNeeded) {
            boolean sameOuts;
            boolean bl5 = sameOuts = thenPathSame && !followThenBranch || elsePathSame && followThenBranch;
            if (!sameOuts) {
                currentIf.resetForceInlineInsns();
                return currentIf;
            }
        }
        IfInfo result = IfRegionMaker.mergeIfInfo(currentIf, nextIf, followThenBranch);
        return IfRegionMaker.searchNestedIf(result);
    }

    private static IfInfo checkForTernaryInCondition(IfInfo currentIf) {
        IfInfo nextThen = IfRegionMaker.getNextIf(currentIf, currentIf.getThenBlock());
        IfInfo nextElse = IfRegionMaker.getNextIf(currentIf, currentIf.getElseBlock());
        if (nextThen == null || nextElse == null) {
            return null;
        }
        if (!nextThen.getFirstIfBlock().getDomFrontier().equals(nextElse.getFirstIfBlock().getDomFrontier())) {
            return null;
        }
        nextThen = IfRegionMaker.searchNestedIf(nextThen);
        nextElse = IfRegionMaker.searchNestedIf(nextElse);
        if (nextThen.getThenBlock() == nextElse.getThenBlock() && nextThen.getElseBlock() == nextElse.getElseBlock()) {
            return IfRegionMaker.mergeTernaryConditions(currentIf, nextThen, nextElse);
        }
        if (nextThen.getThenBlock() == nextElse.getElseBlock() && nextThen.getElseBlock() == nextElse.getThenBlock()) {
            nextElse = IfInfo.invert(nextElse);
            return IfRegionMaker.mergeTernaryConditions(currentIf, nextThen, nextElse);
        }
        return null;
    }

    private static IfInfo mergeTernaryConditions(IfInfo currentIf, IfInfo nextThen, IfInfo nextElse) {
        IfCondition newCondition = IfCondition.ternary(currentIf.getCondition(), nextThen.getCondition(), nextElse.getCondition());
        IfInfo result = new IfInfo(currentIf.getMth(), newCondition, nextThen.getThenBlock(), nextThen.getElseBlock());
        result.merge(currentIf, nextThen, nextElse);
        IfRegionMaker.confirmMerge(result);
        return result;
    }

    private static boolean isInversionNeeded(IfInfo currentIf, IfInfo nextIf) {
        return BlockUtils.isEqualPaths(currentIf.getElseBlock(), nextIf.getThenBlock()) || BlockUtils.isEqualPaths(currentIf.getThenBlock(), nextIf.getElseBlock());
    }

    private static boolean canMerge(IfInfo a15, IfInfo b15, boolean followThenBranch) {
        if (followThenBranch) {
            return BlockUtils.isEqualPaths(a15.getElseBlock(), b15.getElseBlock());
        }
        return BlockUtils.isEqualPaths(a15.getThenBlock(), b15.getThenBlock());
    }

    private static boolean checkConditionBranches(BlockNode from, BlockNode to4) {
        return from.getCleanSuccessors().size() == 1 && from.getCleanSuccessors().contains(to4);
    }

    static IfInfo mergeIfInfo(IfInfo first, IfInfo second, boolean followThenBranch) {
        BlockNode elseBlock;
        BlockNode thenBlock;
        MethodNode mth = first.getMth();
        Set<BlockNode> skipBlocks = first.getSkipBlocks();
        if (followThenBranch) {
            thenBlock = second.getThenBlock();
            elseBlock = IfRegionMaker.getBranchBlock(first.getElseBlock(), second.getElseBlock(), skipBlocks, mth);
        } else {
            thenBlock = IfRegionMaker.getBranchBlock(first.getThenBlock(), second.getThenBlock(), skipBlocks, mth);
            elseBlock = second.getElseBlock();
        }
        IfCondition.Mode mergeOperation = followThenBranch ? IfCondition.Mode.AND : IfCondition.Mode.OR;
        IfCondition condition2 = IfCondition.merge(mergeOperation, first.getCondition(), second.getCondition());
        IfInfo result = new IfInfo(mth, condition2, thenBlock, elseBlock);
        result.merge(first, second);
        return result;
    }

    private static BlockNode getBranchBlock(BlockNode first, BlockNode second, Set<BlockNode> skipBlocks, MethodNode mth) {
        BlockNode secondSkip;
        if (first == second) {
            return second;
        }
        if (BlockUtils.isEqualReturnBlocks(first, second)) {
            skipBlocks.add(first);
            return second;
        }
        if (BlockUtils.isDuplicateBlockPath(first, second)) {
            first.add(AFlag.REMOVE);
            skipBlocks.add(first);
            return second;
        }
        BlockNode cross = BlockUtils.getPathCross(mth, first, second);
        if (cross != null) {
            BlockUtils.visitBlocksOnPath(mth, first, cross, skipBlocks::add);
            BlockUtils.visitBlocksOnPath(mth, second, cross, skipBlocks::add);
            skipBlocks.remove(cross);
            return cross;
        }
        BlockNode firstSkip = BlockUtils.followEmptyPath(first);
        if (firstSkip.equals(secondSkip = BlockUtils.followEmptyPath(second)) || BlockUtils.isEqualReturnBlocks(firstSkip, secondSkip)) {
            skipBlocks.add(first);
            skipBlocks.add(second);
            BlockUtils.visitBlocksOnEmptyPath(first, skipBlocks::add);
            BlockUtils.visitBlocksOnEmptyPath(second, skipBlocks::add);
            return secondSkip;
        }
        throw new JadxRuntimeException("Unexpected merge pattern");
    }

    static void confirmMerge(IfInfo info) {
        if (info.getMergedBlocks().size() > 1) {
            for (BlockNode block : info.getMergedBlocks()) {
                if (block == info.getFirstIfBlock()) continue;
                block.add(AFlag.ADDED_TO_REGION);
            }
        }
        if (!info.getSkipBlocks().isEmpty()) {
            for (BlockNode block : info.getSkipBlocks()) {
                block.add(AFlag.ADDED_TO_REGION);
            }
            info.getSkipBlocks().clear();
        }
        for (InsnNode forceInlineInsn : info.getForceInlineInsns()) {
            forceInlineInsn.add(AFlag.FORCE_ASSIGN_INLINE);
        }
    }

    private static IfInfo getNextIf(IfInfo info, BlockNode block) {
        if (!IfRegionMaker.canSelectNext(info, block)) {
            return null;
        }
        return IfRegionMaker.getNextIfNodeInfo(info, block);
    }

    private static boolean canSelectNext(IfInfo info, BlockNode block) {
        if (block.getPredecessors().size() == 1) {
            return true;
        }
        return info.getMergedBlocks().containsAll(block.getPredecessors());
    }

    private static IfInfo getNextIfNodeInfo(IfInfo info, BlockNode block) {
        if (block == null || block.contains(AType.LOOP) || block.contains(AFlag.ADDED_TO_REGION)) {
            return null;
        }
        InsnNode lastInsn = BlockUtils.getLastInsn(block);
        if (lastInsn != null && lastInsn.getType() == InsnType.IF) {
            return IfRegionMaker.makeIfInfo(info.getMth(), block);
        }
        List<BlockNode> successors = block.getSuccessors();
        if (successors.size() != 1) {
            return null;
        }
        BlockNode next = successors.get(0);
        if (next.getPredecessors().size() != 1 || next.contains(AFlag.ADDED_TO_REGION)) {
            return null;
        }
        ArrayList<InsnNode> forceInlineInsns = new ArrayList<InsnNode>();
        if (!IfRegionMaker.checkInsnsInline(block, next, forceInlineInsns)) {
            return null;
        }
        IfInfo nextInfo = IfRegionMaker.makeIfInfo(info.getMth(), next);
        if (nextInfo == null) {
            return IfRegionMaker.getNextIfNodeInfo(info, next);
        }
        nextInfo.addInsnsForForcedInline(forceInlineInsns);
        return nextInfo;
    }

    private static boolean checkInsnsInline(BlockNode block, BlockNode next, List<InsnNode> forceInlineInsns) {
        List<InsnNode> insns = block.getInstructions();
        if (insns.isEmpty()) {
            return true;
        }
        boolean pass = true;
        for (InsnNode insn : insns) {
            RegisterArg res = insn.getResult();
            if (res == null) {
                return false;
            }
            List<RegisterArg> useList = res.getSVar().getUseList();
            int useCount = useList.size();
            if (useCount == 0) {
                return false;
            }
            InsnArg arg = useList.get(0);
            InsnNode usePlace = arg.getParentInsn();
            if (!BlockUtils.blockContains(block, usePlace) && !BlockUtils.blockContains(next, usePlace)) {
                return false;
            }
            if (useCount > 1) {
                forceInlineInsns.add(insn);
                continue;
            }
            pass = false;
        }
        return pass;
    }
}

