/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.blocks;

import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.SpecialEdgeAttr;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.visitors.blocks.BlockSplitter;
import jadx.core.utils.ListUtils;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class FixMultiEntryLoops {
    public static boolean process(MethodNode mth) {
        try {
            FixMultiEntryLoops.detectSpecialEdges(mth);
        }
        catch (Exception e16) {
            mth.addWarnComment("Failed to detect multi-entry loops", e16);
            return false;
        }
        List specialEdges = mth.getAll(AType.SPECIAL_EDGE);
        List multiEntryLoops = specialEdges.stream().filter(e15 -> e15.getType() == SpecialEdgeAttr.SpecialEdgeType.BACK_EDGE && !FixMultiEntryLoops.isSingleEntryLoop(e15)).collect(Collectors.toList());
        if (multiEntryLoops.isEmpty()) {
            return false;
        }
        try {
            List<SpecialEdgeAttr> crossEdges = ListUtils.filter(specialEdges, e15 -> e15.getType() == SpecialEdgeAttr.SpecialEdgeType.CROSS_EDGE);
            boolean changed = false;
            for (SpecialEdgeAttr backEdge : multiEntryLoops) {
                changed |= FixMultiEntryLoops.fixLoop(mth, backEdge, crossEdges);
            }
            return changed;
        }
        catch (Exception e17) {
            mth.addWarnComment("Failed to fix multi-entry loops", e17);
            return false;
        }
    }

    private static boolean fixLoop(MethodNode mth, SpecialEdgeAttr backEdge, List<SpecialEdgeAttr> crossEdges) {
        if (FixMultiEntryLoops.isHeaderSuccessorEntry(mth, backEdge, crossEdges)) {
            return true;
        }
        if (FixMultiEntryLoops.isEndBlockEntry(mth, backEdge, crossEdges)) {
            return true;
        }
        mth.addWarnComment("Unsupported multi-entry loop pattern (" + String.valueOf(backEdge) + "). Please report as a decompilation issue!!!");
        return false;
    }

    private static boolean isHeaderSuccessorEntry(MethodNode mth, SpecialEdgeAttr backEdge, List<SpecialEdgeAttr> crossEdges) {
        BlockNode header = backEdge.getEnd();
        BlockNode headerIDom = header.getIDom();
        SpecialEdgeAttr subEntry = ListUtils.filterOnlyOne(crossEdges, e15 -> e15.getStart() == headerIDom);
        if (subEntry == null || !ListUtils.isSingleElement(header.getSuccessors(), subEntry.getEnd())) {
            return false;
        }
        BlockNode loopEnd = backEdge.getStart();
        BlockNode subEntryBlock = subEntry.getEnd();
        BlockNode copyHeader = BlockSplitter.insertBlockBetween(mth, loopEnd, header);
        BlockSplitter.copyBlockData(header, copyHeader);
        BlockSplitter.replaceConnection(copyHeader, header, subEntryBlock);
        mth.addDebugComment("Duplicate block (" + String.valueOf(header) + ") to fix multi-entry loop: " + String.valueOf(backEdge));
        return true;
    }

    private static boolean isEndBlockEntry(MethodNode mth, SpecialEdgeAttr backEdge, List<SpecialEdgeAttr> crossEdges) {
        BlockNode loopEnd = backEdge.getStart();
        SpecialEdgeAttr subEntry = ListUtils.filterOnlyOne(crossEdges, e15 -> e15.getEnd() == loopEnd);
        if (subEntry == null) {
            return false;
        }
        FixMultiEntryLoops.dupPath(mth, subEntry.getStart(), loopEnd, backEdge.getEnd());
        mth.addDebugComment("Duplicate block (" + String.valueOf(loopEnd) + ") to fix multi-entry loop: " + String.valueOf(backEdge));
        return true;
    }

    private static void dupPath(MethodNode mth, BlockNode start, BlockNode center, BlockNode end) {
        BlockNode copyCenter = BlockSplitter.insertBlockBetween(mth, start, end);
        BlockSplitter.copyBlockData(center, copyCenter);
        BlockSplitter.removeConnection(start, center);
    }

    private static boolean isSingleEntryLoop(SpecialEdgeAttr e15) {
        BlockNode loopEnd;
        BlockNode header = e15.getEnd();
        return header == (loopEnd = e15.getStart()) || loopEnd.getDoms().get(header.getId());
    }

    private static void detectSpecialEdges(MethodNode mth) {
        BlockColor[] colors = new BlockColor[mth.getBasicBlocks().size()];
        Arrays.fill((Object[])colors, (Object)BlockColor.WHITE);
        FixMultiEntryLoops.colorDFS(mth, colors, mth.getEnterBlock());
    }

    private static void colorDFS(MethodNode mth, BlockColor[] colors, BlockNode block) {
        colors[block.getId()] = BlockColor.GRAY;
        for (BlockNode v15 : block.getSuccessors()) {
            switch (colors[v15.getId()].ordinal()) {
                case 0: {
                    FixMultiEntryLoops.colorDFS(mth, colors, v15);
                    break;
                }
                case 1: {
                    mth.addAttr(AType.SPECIAL_EDGE, new SpecialEdgeAttr(SpecialEdgeAttr.SpecialEdgeType.BACK_EDGE, block, v15));
                    break;
                }
                case 2: {
                    mth.addAttr(AType.SPECIAL_EDGE, new SpecialEdgeAttr(SpecialEdgeAttr.SpecialEdgeType.CROSS_EDGE, block, v15));
                }
            }
        }
        colors[block.getId()] = BlockColor.BLACK;
    }

    private static enum BlockColor {
        WHITE,
        GRAY,
        BLACK;

    }
}

