/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.codegen.json;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import jadx.api.ICodeInfo;
import jadx.api.ICodeWriter;
import jadx.api.JadxArgs;
import jadx.api.impl.AnnotatedCodeWriter;
import jadx.api.impl.SimpleCodeWriter;
import jadx.api.metadata.ICodeAnnotation;
import jadx.api.metadata.ICodeMetadata;
import jadx.api.metadata.annotations.InsnCodeOffset;
import jadx.core.codegen.ClassGen;
import jadx.core.codegen.MethodGen;
import jadx.core.codegen.json.cls.JsonClass;
import jadx.core.codegen.json.cls.JsonCodeLine;
import jadx.core.codegen.json.cls.JsonField;
import jadx.core.codegen.json.cls.JsonMethod;
import jadx.core.codegen.utils.CodeGenUtils;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.GsonUtils;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class JsonCodeGen {
    private static final Gson GSON = GsonUtils.defaultGsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_DASHES).disableHtmlEscaping().create();
    private final ClassNode cls;
    private final JadxArgs args;
    private final RootNode root;

    public JsonCodeGen(ClassNode cls) {
        this.cls = cls;
        this.root = cls.root();
        this.args = this.root.getArgs();
    }

    public String process() {
        JsonClass jsonCls = this.processCls(this.cls, null);
        return GSON.toJson(jsonCls);
    }

    private JsonClass processCls(ClassNode cls, @Nullable ClassGen parentCodeGen) {
        ClassGen classGen = parentCodeGen == null ? new ClassGen(cls, this.args) : new ClassGen(cls, parentCodeGen);
        ClassInfo classInfo = cls.getClassInfo();
        JsonClass jsonCls = new JsonClass();
        jsonCls.setPkg(classInfo.getAliasPkg());
        jsonCls.setDex(cls.getInputFileName());
        jsonCls.setName(classInfo.getFullName());
        if (classInfo.hasAlias()) {
            jsonCls.setAlias(classInfo.getAliasFullName());
        }
        jsonCls.setType(this.getClassTypeStr(cls));
        jsonCls.setAccessFlags(cls.getAccessFlags().rawValue());
        ArgType superClass = cls.getSuperClass();
        if (superClass != null && !superClass.equals(ArgType.OBJECT) && !cls.contains(AFlag.REMOVE_SUPER_CLASS)) {
            jsonCls.setSuperClass(this.getTypeAlias(classGen, superClass));
        }
        if (!cls.getInterfaces().isEmpty()) {
            jsonCls.setInterfaces(Utils.collectionMap(cls.getInterfaces(), clsType -> this.getTypeAlias(classGen, (ArgType)clsType)));
        }
        SimpleCodeWriter cw4 = new SimpleCodeWriter(this.args);
        CodeGenUtils.addErrorsAndComments(cw4, cls);
        classGen.addClassDeclaration(cw4);
        jsonCls.setDeclaration(cw4.getCodeStr());
        this.addFields(cls, jsonCls, classGen);
        this.addMethods(cls, jsonCls, classGen);
        this.addInnerClasses(cls, jsonCls, classGen);
        if (!cls.getClassInfo().isInner()) {
            List<String> imports = Utils.collectionMap(classGen.getImports(), ClassInfo::getAliasFullName);
            Collections.sort(imports);
            jsonCls.setImports(imports);
        }
        return jsonCls;
    }

    private void addInnerClasses(ClassNode cls, JsonClass jsonCls, ClassGen classGen) {
        List<ClassNode> innerClasses = cls.getInnerClasses();
        if (innerClasses.isEmpty()) {
            return;
        }
        jsonCls.setInnerClasses(new ArrayList<JsonClass>(innerClasses.size()));
        for (ClassNode innerCls : innerClasses) {
            if (innerCls.contains(AFlag.DONT_GENERATE)) continue;
            JsonClass innerJsonCls = this.processCls(innerCls, classGen);
            jsonCls.getInnerClasses().add(innerJsonCls);
        }
    }

    private void addFields(ClassNode cls, JsonClass jsonCls, ClassGen classGen) {
        jsonCls.setFields(new ArrayList<JsonField>());
        for (FieldNode field : cls.getFields()) {
            if (field.contains(AFlag.DONT_GENERATE)) continue;
            JsonField jsonField = new JsonField();
            jsonField.setName(field.getName());
            if (field.getFieldInfo().hasAlias()) {
                jsonField.setAlias(field.getAlias());
            }
            SimpleCodeWriter cw4 = new SimpleCodeWriter(this.args);
            classGen.addField(cw4, field);
            jsonField.setDeclaration(cw4.getCodeStr());
            jsonField.setAccessFlags(field.getAccessFlags().rawValue());
            jsonCls.getFields().add(jsonField);
        }
    }

    private void addMethods(ClassNode cls, JsonClass jsonCls, ClassGen classGen) {
        jsonCls.setMethods(new ArrayList<JsonMethod>());
        for (MethodNode mth : cls.getMethods()) {
            if (mth.contains(AFlag.DONT_GENERATE)) continue;
            JsonMethod jsonMth = new JsonMethod();
            jsonMth.setName(mth.getName());
            if (mth.getMethodInfo().hasAlias()) {
                jsonMth.setAlias(mth.getAlias());
            }
            jsonMth.setSignature(mth.getMethodInfo().getShortId());
            jsonMth.setReturnType(this.getTypeAlias(classGen, mth.getReturnType()));
            jsonMth.setArguments(Utils.collectionMap(mth.getMethodInfo().getArgumentsTypes(), clsType -> this.getTypeAlias(classGen, (ArgType)clsType)));
            MethodGen mthGen = new MethodGen(classGen, mth);
            AnnotatedCodeWriter cw4 = new AnnotatedCodeWriter(this.args);
            mthGen.addDefinition(cw4);
            jsonMth.setDeclaration(cw4.getCodeStr());
            jsonMth.setAccessFlags(mth.getAccessFlags().rawValue());
            jsonMth.setLines(this.fillMthCode(mth, mthGen));
            jsonMth.setOffset("0x" + Long.toHexString(mth.getMethodCodeOffset()));
            jsonCls.getMethods().add(jsonMth);
        }
    }

    private List<JsonCodeLine> fillMthCode(MethodNode mth, MethodGen mthGen) {
        if (mth.isNoCode()) {
            return Collections.emptyList();
        }
        ICodeWriter cw4 = mth.root().makeCodeWriter();
        try {
            mthGen.addInstructions(cw4);
        }
        catch (Exception e15) {
            throw new JadxRuntimeException("Method generation error", e15);
        }
        ICodeInfo code = cw4.finish();
        String codeStr = code.getCodeStr();
        if (codeStr.isEmpty()) {
            return Collections.emptyList();
        }
        String[] lines = codeStr.split(this.args.getCodeNewLineStr());
        Map<Integer, Integer> lineMapping = code.getCodeMetadata().getLineMapping();
        ICodeMetadata metadata = code.getCodeMetadata();
        long mthCodeOffset = mth.getMethodCodeOffset() + 16L;
        int linesCount = lines.length;
        ArrayList<JsonCodeLine> codeLines = new ArrayList<JsonCodeLine>(linesCount);
        int lineStartPos = 0;
        int newLineLen = this.args.getCodeNewLineStr().length();
        for (int i15 = 0; i15 < linesCount; ++i15) {
            String codeLine = lines[i15];
            int line = i15 + 2;
            JsonCodeLine jsonCodeLine = new JsonCodeLine();
            jsonCodeLine.setCode(codeLine);
            jsonCodeLine.setSourceLine(lineMapping.get(line));
            ICodeAnnotation obj = metadata.getAt(lineStartPos);
            if (obj instanceof InsnCodeOffset) {
                long offset = ((InsnCodeOffset)obj).getOffset();
                jsonCodeLine.setOffset("0x" + Long.toHexString(mthCodeOffset + offset * 2L));
            }
            codeLines.add(jsonCodeLine);
            lineStartPos += codeLine.length() + newLineLen;
        }
        return codeLines;
    }

    private String getTypeAlias(ClassGen classGen, ArgType clsType) {
        SimpleCodeWriter code = new SimpleCodeWriter(this.args);
        classGen.useType(code, clsType);
        return code.getCodeStr();
    }

    private String getClassTypeStr(ClassNode cls) {
        if (cls.isEnum()) {
            return "enum";
        }
        if (cls.getAccessFlags().isInterface()) {
            return "interface";
        }
        return "class";
    }
}

