/*
 * Decompiled with CFR 0.152.
 */
package jadx.core;

import jadx.api.DecompilationMode;
import jadx.api.ICodeInfo;
import jadx.api.JadxArgs;
import jadx.api.impl.SimpleCodeInfo;
import jadx.core.Jadx;
import jadx.core.codegen.CodeGen;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.DecompileModeOverrideAttr;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.LoadStage;
import jadx.core.dex.nodes.ProcessState;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.visitors.DepthTraversal;
import jadx.core.dex.visitors.IDexTreeVisitor;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessClass {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessClass.class);
    private static final ICodeInfo NOT_GENERATED = new SimpleCodeInfo("");
    private final List<IDexTreeVisitor> passes;
    private final Map<DecompilationMode, ProcessClass> modesMap = new EnumMap<DecompilationMode, ProcessClass>(DecompilationMode.class);

    public ProcessClass(List<IDexTreeVisitor> passesList) {
        this.passes = passesList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ICodeInfo process(ClassNode cls, boolean codegen) {
        if (!codegen && cls.getState() == ProcessState.PROCESS_COMPLETE) {
            return null;
        }
        Utils.checkThreadInterrupt();
        ClassInfo classInfo = cls.getClassInfo();
        synchronized (classInfo) {
            try {
                if (cls.contains(AFlag.CLASS_DEEP_RELOAD)) {
                    cls.remove(AFlag.CLASS_DEEP_RELOAD);
                    cls.deepUnload();
                    cls.add(AFlag.CLASS_UNLOADED);
                }
                if (cls.contains(AFlag.CLASS_UNLOADED)) {
                    cls.root().runPreDecompileStageForClass(cls);
                    cls.remove(AFlag.CLASS_UNLOADED);
                }
                if (cls.getState() == ProcessState.GENERATED_AND_UNLOADED) {
                    cls.setState(ProcessState.NOT_LOADED);
                }
                if (codegen) {
                    cls.setLoadStage(LoadStage.CODEGEN_STAGE);
                    if (cls.contains(AFlag.RELOAD_AT_CODEGEN_STAGE)) {
                        cls.remove(AFlag.RELOAD_AT_CODEGEN_STAGE);
                        cls.unload();
                    }
                } else {
                    cls.setLoadStage(LoadStage.PROCESS_STAGE);
                }
                if (cls.getState() == ProcessState.NOT_LOADED) {
                    cls.load();
                }
                if (cls.getState() == ProcessState.LOADED) {
                    cls.setState(ProcessState.PROCESS_STARTED);
                    for (IDexTreeVisitor visitor2 : this.passes) {
                        DepthTraversal.visit(visitor2, cls);
                    }
                    cls.setState(ProcessState.PROCESS_COMPLETE);
                }
                if (codegen) {
                    Utils.checkThreadInterrupt();
                    ICodeInfo code = CodeGen.generate(cls);
                    if (!cls.contains(AFlag.DONT_UNLOAD_CLASS)) {
                        cls.unload();
                        cls.setState(ProcessState.GENERATED_AND_UNLOADED);
                    }
                    return code;
                }
                return null;
            }
            catch (Exception | StackOverflowError e15) {
                if (codegen) {
                    throw e15;
                }
                cls.addError("Class process error: " + e15.getClass().getSimpleName(), e15);
                return null;
            }
        }
    }

    @NotNull
    public ICodeInfo generateCode(ClassNode cls) {
        ClassNode topParentClass = cls.getTopParentClass();
        if (topParentClass != cls) {
            return this.generateCode(topParentClass);
        }
        try {
            ICodeInfo code;
            if (cls.contains(AFlag.DONT_GENERATE)) {
                this.process(cls, false);
                return NOT_GENERATED;
            }
            for (ClassNode depCls : cls.getDependencies()) {
                this.process(depCls, false);
            }
            if (!cls.getCodegenDeps().isEmpty()) {
                this.process(cls, false);
                for (ClassNode codegenDep : cls.getCodegenDeps()) {
                    this.process(codegenDep, false);
                }
            }
            if ((code = this.process(cls, true)) == null) {
                throw new JadxRuntimeException("Codegen failed");
            }
            return code;
        }
        catch (Exception | StackOverflowError e15) {
            throw new JadxRuntimeException("Failed to generate code for class: " + cls.getFullName(), e15);
        }
    }

    public void forceProcess(ClassNode cls) {
        ClassNode topParentClass = cls.getTopParentClass();
        if (topParentClass != cls) {
            this.forceProcess(topParentClass);
            return;
        }
        try {
            this.process(cls, false);
        }
        catch (Exception | StackOverflowError e15) {
            throw new JadxRuntimeException("Failed to process class: " + cls.getFullName(), e15);
        }
    }

    @Nullable
    public ICodeInfo forceGenerateCode(ClassNode cls) {
        try {
            return this.process(cls, true);
        }
        catch (Exception | StackOverflowError e15) {
            throw new JadxRuntimeException("Failed to generate code for class: " + cls.getFullName(), e15);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ICodeInfo forceGenerateCodeForMode(ClassNode cls, DecompilationMode mode) {
        Map<DecompilationMode, ProcessClass> map = this.modesMap;
        synchronized (map) {
            ICodeInfo iCodeInfo;
            ProcessClass prCls = this.modesMap.computeIfAbsent(mode, m15 -> {
                RootNode root = cls.root();
                ProcessClass newPrCls = new ProcessClass(ProcessClass.getPassesForMode(root.getArgs(), m15));
                newPrCls.initPasses(root);
                return newPrCls;
            });
            try {
                cls.addAttr(new DecompileModeOverrideAttr(mode));
                iCodeInfo = prCls.forceGenerateCode(cls);
            }
            catch (Throwable throwable) {
                cls.remove(AType.DECOMPILE_MODE_OVERRIDE);
                throw throwable;
            }
            cls.remove(AType.DECOMPILE_MODE_OVERRIDE);
            return iCodeInfo;
        }
    }

    private static List<IDexTreeVisitor> getPassesForMode(JadxArgs baseArgs, DecompilationMode mode) {
        switch (mode) {
            case FALLBACK: {
                return Jadx.getFallbackPassesList();
            }
            case SIMPLE: {
                JadxArgs args = new JadxArgs();
                args.setDebugInfo(baseArgs.isDebugInfo());
                args.setCommentsLevel(baseArgs.getCommentsLevel());
                return Jadx.getSimpleModePasses(args);
            }
        }
        throw new JadxRuntimeException("Unexpected decompilation mode: " + String.valueOf((Object)mode));
    }

    public void initPasses(RootNode root) {
        for (IDexTreeVisitor pass : this.passes) {
            try {
                pass.init(root);
            }
            catch (Exception e15) {
                LOG.error("Visitor init failed: {}", (Object)pass.getClass().getSimpleName(), (Object)e15);
            }
        }
    }

    public List<IDexTreeVisitor> getPasses() {
        return this.passes;
    }
}

