/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.parallel;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.parallel.ParallelFlowable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class ParallelReduceFull<T>
extends Flowable<T> {
    final ParallelFlowable<? extends T> source;
    final BiFunction<T, T, T> reducer;

    public ParallelReduceFull(ParallelFlowable<? extends T> source, BiFunction<T, T, T> reducer) {
        this.source = source;
        this.reducer = reducer;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s15) {
        ParallelReduceFullMainSubscriber<? super T> parent = new ParallelReduceFullMainSubscriber<T>(s15, this.source.parallelism(), this.reducer);
        s15.onSubscribe(parent);
        this.source.subscribe(parent.subscribers);
    }

    static final class SlotPair<T>
    extends AtomicInteger {
        private static final long serialVersionUID = 473971317683868662L;
        T first;
        T second;
        final AtomicInteger releaseIndex = new AtomicInteger();

        SlotPair() {
        }

        int tryAcquireSlot() {
            int acquired;
            do {
                if ((acquired = this.get()) < 2) continue;
                return -1;
            } while (!this.compareAndSet(acquired, acquired + 1));
            return acquired;
        }

        boolean releaseSlot() {
            return this.releaseIndex.incrementAndGet() == 2;
        }
    }

    static final class ParallelReduceFullInnerSubscriber<T>
    extends AtomicReference<Subscription>
    implements FlowableSubscriber<T> {
        private static final long serialVersionUID = -7954444275102466525L;
        final ParallelReduceFullMainSubscriber<T> parent;
        final BiFunction<T, T, T> reducer;
        T value;
        boolean done;

        ParallelReduceFullInnerSubscriber(ParallelReduceFullMainSubscriber<T> parent, BiFunction<T, T, T> reducer) {
            this.parent = parent;
            this.reducer = reducer;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            SubscriptionHelper.setOnce(this, s15, Long.MAX_VALUE);
        }

        @Override
        public void onNext(T t15) {
            if (!this.done) {
                T v15 = this.value;
                if (v15 == null) {
                    this.value = t15;
                } else {
                    try {
                        v15 = Objects.requireNonNull(this.reducer.apply(v15, t15), "The reducer returned a null value");
                    }
                    catch (Throwable ex4) {
                        Exceptions.throwIfFatal(ex4);
                        ((Subscription)this.get()).cancel();
                        this.onError(ex4);
                        return;
                    }
                    this.value = v15;
                }
            }
        }

        @Override
        public void onError(Throwable t15) {
            if (this.done) {
                RxJavaPlugins.onError(t15);
                return;
            }
            this.done = true;
            this.parent.innerError(t15);
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.parent.innerComplete(this.value);
            }
        }

        void cancel() {
            SubscriptionHelper.cancel(this);
        }
    }

    static final class ParallelReduceFullMainSubscriber<T>
    extends DeferredScalarSubscription<T> {
        private static final long serialVersionUID = -5370107872170712765L;
        final ParallelReduceFullInnerSubscriber<T>[] subscribers;
        final BiFunction<T, T, T> reducer;
        final AtomicReference<SlotPair<T>> current = new AtomicReference();
        final AtomicInteger remaining = new AtomicInteger();
        final AtomicThrowable error = new AtomicThrowable();

        ParallelReduceFullMainSubscriber(Subscriber<? super T> subscriber, int n15, BiFunction<T, T, T> reducer) {
            super(subscriber);
            ParallelReduceFullInnerSubscriber[] a15 = new ParallelReduceFullInnerSubscriber[n15];
            for (int i15 = 0; i15 < n15; ++i15) {
                a15[i15] = new ParallelReduceFullInnerSubscriber<T>(this, reducer);
            }
            this.subscribers = a15;
            this.reducer = reducer;
            this.remaining.lazySet(n15);
        }

        SlotPair<T> addValue(T value) {
            int c15;
            SlotPair<T> curr;
            while (true) {
                if ((curr = this.current.get()) == null && !this.current.compareAndSet(null, curr = new SlotPair())) {
                    continue;
                }
                c15 = curr.tryAcquireSlot();
                if (c15 >= 0) break;
                this.current.compareAndSet(curr, null);
            }
            if (c15 == 0) {
                curr.first = value;
            } else {
                curr.second = value;
            }
            if (curr.releaseSlot()) {
                this.current.compareAndSet(curr, null);
                return curr;
            }
            return null;
        }

        @Override
        public void cancel() {
            for (ParallelReduceFullInnerSubscriber<T> inner : this.subscribers) {
                inner.cancel();
            }
        }

        void innerError(Throwable ex4) {
            if (this.error.compareAndSet(null, ex4)) {
                this.cancel();
                this.downstream.onError(ex4);
            } else if (ex4 != this.error.get()) {
                RxJavaPlugins.onError(ex4);
            }
        }

        void innerComplete(T value) {
            SlotPair<T> sp4;
            if (value != null) {
                while ((sp4 = this.addValue(value)) != null) {
                    try {
                        value = Objects.requireNonNull(this.reducer.apply(sp4.first, sp4.second), "The reducer returned a null value");
                    }
                    catch (Throwable ex4) {
                        Exceptions.throwIfFatal(ex4);
                        this.innerError(ex4);
                        return;
                    }
                }
            }
            if (this.remaining.decrementAndGet() == 0) {
                sp4 = this.current.get();
                this.current.lazySet(null);
                if (sp4 != null) {
                    this.complete(sp4.first);
                } else {
                    this.downstream.onComplete();
                }
            }
        }
    }
}

