/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ObservableOperator;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;

public final class ObservableLift<R, T>
extends AbstractObservableWithUpstream<T, R> {
    final ObservableOperator<? extends R, ? super T> operator;

    public ObservableLift(ObservableSource<T> source, ObservableOperator<? extends R, ? super T> operator) {
        super(source);
        this.operator = operator;
    }

    @Override
    public void subscribeActual(Observer<? super R> observer) {
        Observer<? super T> liftedObserver;
        try {
            liftedObserver = Objects.requireNonNull(this.operator.apply(observer), "Operator " + this.operator + " returned a null Observer");
        }
        catch (NullPointerException e15) {
            throw e15;
        }
        catch (Throwable e16) {
            Exceptions.throwIfFatal(e16);
            RxJavaPlugins.onError(e16);
            NullPointerException npe = new NullPointerException("Actually not, but can't throw other exceptions due to RS");
            npe.initCause(e16);
            throw npe;
        }
        this.source.subscribe(liftedObserver);
    }
}

