/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Iterator;
import java.util.Objects;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableZipIterable<T, U, V>
extends AbstractFlowableWithUpstream<T, V> {
    final Iterable<U> other;
    final BiFunction<? super T, ? super U, ? extends V> zipper;

    public FlowableZipIterable(Flowable<T> source, Iterable<U> other, BiFunction<? super T, ? super U, ? extends V> zipper) {
        super(source);
        this.other = other;
        this.zipper = zipper;
    }

    @Override
    public void subscribeActual(Subscriber<? super V> t15) {
        boolean b15;
        Iterator<U> it;
        try {
            it = Objects.requireNonNull(this.other.iterator(), "The iterator returned by other is null");
        }
        catch (Throwable e15) {
            Exceptions.throwIfFatal(e15);
            EmptySubscription.error(e15, t15);
            return;
        }
        try {
            b15 = it.hasNext();
        }
        catch (Throwable e16) {
            Exceptions.throwIfFatal(e16);
            EmptySubscription.error(e16, t15);
            return;
        }
        if (!b15) {
            EmptySubscription.complete(t15);
            return;
        }
        this.source.subscribe(new ZipIterableSubscriber<T, U, V>(t15, it, this.zipper));
    }

    static final class ZipIterableSubscriber<T, U, V>
    implements FlowableSubscriber<T>,
    Subscription {
        final Subscriber<? super V> downstream;
        final Iterator<U> iterator;
        final BiFunction<? super T, ? super U, ? extends V> zipper;
        Subscription upstream;
        boolean done;

        ZipIterableSubscriber(Subscriber<? super V> actual, Iterator<U> iterator2, BiFunction<? super T, ? super U, ? extends V> zipper) {
            this.downstream = actual;
            this.iterator = iterator2;
            this.zipper = zipper;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t15) {
            boolean b15;
            V v15;
            U u15;
            if (this.done) {
                return;
            }
            try {
                u15 = Objects.requireNonNull(this.iterator.next(), "The iterator returned a null value");
            }
            catch (Throwable e15) {
                this.fail(e15);
                return;
            }
            try {
                v15 = Objects.requireNonNull(this.zipper.apply(t15, u15), "The zipper function returned a null value");
            }
            catch (Throwable e16) {
                this.fail(e16);
                return;
            }
            this.downstream.onNext(v15);
            try {
                b15 = this.iterator.hasNext();
            }
            catch (Throwable e17) {
                this.fail(e17);
                return;
            }
            if (!b15) {
                this.done = true;
                this.upstream.cancel();
                this.downstream.onComplete();
            }
        }

        void fail(Throwable e15) {
            Exceptions.throwIfFatal(e15);
            this.done = true;
            this.upstream.cancel();
            this.downstream.onError(e15);
        }

        @Override
        public void onError(Throwable t15) {
            if (this.done) {
                RxJavaPlugins.onError(t15);
                return;
            }
            this.done = true;
            this.downstream.onError(t15);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.downstream.onComplete();
        }

        @Override
        public void request(long n15) {
            this.upstream.request(n15);
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
        }
    }
}

