/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableWindowSubscribeIntercept;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.operators.SpscLinkedArrayQueue;
import io.reactivex.rxjava3.processors.UnicastProcessor;
import java.util.ArrayDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableWindow<T>
extends AbstractFlowableWithUpstream<T, Flowable<T>> {
    final long size;
    final long skip;
    final int bufferSize;

    public FlowableWindow(Flowable<T> source, long size, long skip, int bufferSize) {
        super(source);
        this.size = size;
        this.skip = skip;
        this.bufferSize = bufferSize;
    }

    @Override
    public void subscribeActual(Subscriber<? super Flowable<T>> s15) {
        if (this.skip == this.size) {
            this.source.subscribe(new WindowExactSubscriber(s15, this.size, this.bufferSize));
        } else if (this.skip > this.size) {
            this.source.subscribe(new WindowSkipSubscriber(s15, this.size, this.skip, this.bufferSize));
        } else {
            this.source.subscribe(new WindowOverlapSubscriber(s15, this.size, this.skip, this.bufferSize));
        }
    }

    static final class WindowOverlapSubscriber<T>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription,
    Runnable {
        private static final long serialVersionUID = 2428527070996323976L;
        final Subscriber<? super Flowable<T>> downstream;
        final SpscLinkedArrayQueue<UnicastProcessor<T>> queue;
        final long size;
        final long skip;
        final ArrayDeque<UnicastProcessor<T>> windows;
        final AtomicBoolean once;
        final AtomicBoolean firstRequest;
        final AtomicLong requested;
        final AtomicInteger wip;
        final int bufferSize;
        long index;
        long produced;
        Subscription upstream;
        volatile boolean done;
        Throwable error;
        volatile boolean cancelled;

        WindowOverlapSubscriber(Subscriber<? super Flowable<T>> actual, long size, long skip, int bufferSize) {
            super(1);
            this.downstream = actual;
            this.size = size;
            this.skip = skip;
            this.queue = new SpscLinkedArrayQueue(bufferSize);
            this.windows = new ArrayDeque();
            this.once = new AtomicBoolean();
            this.firstRequest = new AtomicBoolean();
            this.requested = new AtomicLong();
            this.wip = new AtomicInteger();
            this.bufferSize = bufferSize;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t15) {
            long p15;
            long i15 = this.index;
            UnicastProcessor newWindow = null;
            if (i15 == 0L && !this.cancelled) {
                this.getAndIncrement();
                newWindow = UnicastProcessor.create(this.bufferSize, this);
                this.windows.offer(newWindow);
            }
            ++i15;
            for (Processor processor : this.windows) {
                processor.onNext(t15);
            }
            if (newWindow != null) {
                this.queue.offer(newWindow);
                this.drain();
            }
            if ((p15 = this.produced + 1L) == this.size) {
                this.produced = p15 - this.skip;
                Processor w16 = this.windows.poll();
                if (w16 != null) {
                    w16.onComplete();
                }
            } else {
                this.produced = p15;
            }
            this.index = i15 == this.skip ? 0L : i15;
        }

        @Override
        public void onError(Throwable t15) {
            for (Processor processor : this.windows) {
                processor.onError(t15);
            }
            this.windows.clear();
            this.error = t15;
            this.done = true;
            this.drain();
        }

        @Override
        public void onComplete() {
            for (Processor processor : this.windows) {
                processor.onComplete();
            }
            this.windows.clear();
            this.done = true;
            this.drain();
        }

        void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            Subscriber<Flowable<FlowableWindowSubscribeIntercept<T>>> a15 = this.downstream;
            SpscLinkedArrayQueue<UnicastProcessor<T>> q15 = this.queue;
            int missed = 1;
            block0: while (true) {
                if (this.cancelled) {
                    UnicastProcessor<T> up4 = null;
                    while ((up4 = q15.poll()) != null) {
                        up4.onComplete();
                    }
                } else {
                    long e15;
                    long r15 = this.requested.get();
                    for (e15 = 0L; e15 != r15; ++e15) {
                        boolean empty;
                        boolean d15 = this.done;
                        UnicastProcessor<T> t15 = q15.poll();
                        boolean bl4 = empty = t15 == null;
                        if (this.cancelled) continue block0;
                        if (this.checkTerminated(d15, empty, a15, q15)) {
                            return;
                        }
                        if (empty) break;
                        FlowableWindowSubscribeIntercept<T> intercept = new FlowableWindowSubscribeIntercept<T>(t15);
                        a15.onNext(intercept);
                        if (!intercept.tryAbandon()) continue;
                        t15.onComplete();
                    }
                    if (e15 == r15) {
                        if (this.cancelled) continue;
                        if (this.checkTerminated(this.done, q15.isEmpty(), a15, q15)) {
                            return;
                        }
                    }
                    if (e15 != 0L && r15 != Long.MAX_VALUE) {
                        this.requested.addAndGet(-e15);
                    }
                }
                if ((missed = this.wip.addAndGet(-missed)) == 0) break;
            }
        }

        boolean checkTerminated(boolean d15, boolean empty, Subscriber<?> a15, SpscLinkedArrayQueue<?> q15) {
            if (d15) {
                Throwable e15 = this.error;
                if (e15 != null) {
                    q15.clear();
                    a15.onError(e15);
                    return true;
                }
                if (empty) {
                    a15.onComplete();
                    return true;
                }
            }
            return false;
        }

        @Override
        public void request(long n15) {
            if (SubscriptionHelper.validate(n15)) {
                BackpressureHelper.add(this.requested, n15);
                if (!this.firstRequest.get() && this.firstRequest.compareAndSet(false, true)) {
                    long u15 = BackpressureHelper.multiplyCap(this.skip, n15 - 1L);
                    long v15 = BackpressureHelper.addCap(this.size, u15);
                    this.upstream.request(v15);
                } else {
                    long u16 = BackpressureHelper.multiplyCap(this.skip, n15);
                    this.upstream.request(u16);
                }
                this.drain();
            }
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            if (this.once.compareAndSet(false, true)) {
                this.run();
            }
            this.drain();
        }

        @Override
        public void run() {
            if (this.decrementAndGet() == 0) {
                this.upstream.cancel();
            }
        }
    }

    static final class WindowSkipSubscriber<T>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription,
    Runnable {
        private static final long serialVersionUID = -8792836352386833856L;
        final Subscriber<? super Flowable<T>> downstream;
        final long size;
        final long skip;
        final AtomicBoolean once;
        final AtomicBoolean firstRequest;
        final int bufferSize;
        long index;
        Subscription upstream;
        UnicastProcessor<T> window;

        WindowSkipSubscriber(Subscriber<? super Flowable<T>> actual, long size, long skip, int bufferSize) {
            super(1);
            this.downstream = actual;
            this.size = size;
            this.skip = skip;
            this.once = new AtomicBoolean();
            this.firstRequest = new AtomicBoolean();
            this.bufferSize = bufferSize;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t15) {
            long i15 = this.index;
            FlowableWindowSubscribeIntercept<T> intercept = null;
            UnicastProcessor<T> w15 = this.window;
            if (i15 == 0L) {
                this.getAndIncrement();
                w15 = UnicastProcessor.create(this.bufferSize, this);
                this.window = w15;
                intercept = new FlowableWindowSubscribeIntercept<T>(w15);
                this.downstream.onNext(intercept);
            }
            ++i15;
            if (w15 != null) {
                w15.onNext(t15);
            }
            if (i15 == this.size) {
                this.window = null;
                w15.onComplete();
            }
            this.index = i15 == this.skip ? 0L : i15;
            if (intercept != null && intercept.tryAbandon()) {
                intercept.window.onComplete();
            }
        }

        @Override
        public void onError(Throwable t15) {
            UnicastProcessor<T> w15 = this.window;
            if (w15 != null) {
                this.window = null;
                w15.onError(t15);
            }
            this.downstream.onError(t15);
        }

        @Override
        public void onComplete() {
            UnicastProcessor<T> w15 = this.window;
            if (w15 != null) {
                this.window = null;
                w15.onComplete();
            }
            this.downstream.onComplete();
        }

        @Override
        public void request(long n15) {
            if (SubscriptionHelper.validate(n15)) {
                if (!this.firstRequest.get() && this.firstRequest.compareAndSet(false, true)) {
                    long u15 = BackpressureHelper.multiplyCap(this.size, n15);
                    long v15 = BackpressureHelper.multiplyCap(this.skip - this.size, n15 - 1L);
                    long w15 = BackpressureHelper.addCap(u15, v15);
                    this.upstream.request(w15);
                } else {
                    long u16 = BackpressureHelper.multiplyCap(this.skip, n15);
                    this.upstream.request(u16);
                }
            }
        }

        @Override
        public void cancel() {
            if (this.once.compareAndSet(false, true)) {
                this.run();
            }
        }

        @Override
        public void run() {
            if (this.decrementAndGet() == 0) {
                this.upstream.cancel();
            }
        }
    }

    static final class WindowExactSubscriber<T>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription,
    Runnable {
        private static final long serialVersionUID = -2365647875069161133L;
        final Subscriber<? super Flowable<T>> downstream;
        final long size;
        final AtomicBoolean once;
        final int bufferSize;
        long index;
        Subscription upstream;
        UnicastProcessor<T> window;

        WindowExactSubscriber(Subscriber<? super Flowable<T>> actual, long size, int bufferSize) {
            super(1);
            this.downstream = actual;
            this.size = size;
            this.once = new AtomicBoolean();
            this.bufferSize = bufferSize;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t15) {
            long i15 = this.index;
            UnicastProcessor<T> w15 = this.window;
            FlowableWindowSubscribeIntercept<T> intercept = null;
            if (i15 == 0L) {
                this.getAndIncrement();
                w15 = UnicastProcessor.create(this.bufferSize, this);
                this.window = w15;
                intercept = new FlowableWindowSubscribeIntercept<T>(w15);
                this.downstream.onNext(intercept);
            }
            w15.onNext(t15);
            if (++i15 == this.size) {
                this.index = 0L;
                this.window = null;
                w15.onComplete();
            } else {
                this.index = i15;
            }
            if (intercept != null && intercept.tryAbandon()) {
                intercept.window.onComplete();
            }
        }

        @Override
        public void onError(Throwable t15) {
            UnicastProcessor<T> w15 = this.window;
            if (w15 != null) {
                this.window = null;
                w15.onError(t15);
            }
            this.downstream.onError(t15);
        }

        @Override
        public void onComplete() {
            UnicastProcessor<T> w15 = this.window;
            if (w15 != null) {
                this.window = null;
                w15.onComplete();
            }
            this.downstream.onComplete();
        }

        @Override
        public void request(long n15) {
            if (SubscriptionHelper.validate(n15)) {
                long u15 = BackpressureHelper.multiplyCap(this.size, n15);
                this.upstream.request(u15);
            }
        }

        @Override
        public void cancel() {
            if (this.once.compareAndSet(false, true)) {
                this.run();
            }
        }

        @Override
        public void run() {
            if (this.decrementAndGet() == 0) {
                this.upstream.cancel();
            }
        }
    }
}

