/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.subscribers.SerializedSubscriber;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableSamplePublisher<T>
extends Flowable<T> {
    final Publisher<T> source;
    final Publisher<?> other;
    final boolean emitLast;

    public FlowableSamplePublisher(Publisher<T> source, Publisher<?> other, boolean emitLast) {
        this.source = source;
        this.other = other;
        this.emitLast = emitLast;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s15) {
        SerializedSubscriber<? super T> serial = new SerializedSubscriber<T>(s15);
        if (this.emitLast) {
            this.source.subscribe(new SampleMainEmitLast<T>(serial, this.other));
        } else {
            this.source.subscribe(new SampleMainNoLast<T>(serial, this.other));
        }
    }

    static final class SampleMainEmitLast<T>
    extends SamplePublisherSubscriber<T> {
        private static final long serialVersionUID = -3029755663834015785L;
        final AtomicInteger wip = new AtomicInteger();
        volatile boolean done;

        SampleMainEmitLast(Subscriber<? super T> actual, Publisher<?> other) {
            super(actual, other);
        }

        @Override
        void completion() {
            this.done = true;
            if (this.wip.getAndIncrement() == 0) {
                this.emit();
                this.downstream.onComplete();
            }
        }

        @Override
        void run() {
            if (this.wip.getAndIncrement() == 0) {
                do {
                    boolean d15 = this.done;
                    this.emit();
                    if (!d15) continue;
                    this.downstream.onComplete();
                    return;
                } while (this.wip.decrementAndGet() != 0);
            }
        }
    }

    static final class SampleMainNoLast<T>
    extends SamplePublisherSubscriber<T> {
        private static final long serialVersionUID = -3029755663834015785L;

        SampleMainNoLast(Subscriber<? super T> actual, Publisher<?> other) {
            super(actual, other);
        }

        @Override
        void completion() {
            this.downstream.onComplete();
        }

        @Override
        void run() {
            this.emit();
        }
    }

    static final class SamplerSubscriber<T>
    implements FlowableSubscriber<Object> {
        final SamplePublisherSubscriber<T> parent;

        SamplerSubscriber(SamplePublisherSubscriber<T> parent) {
            this.parent = parent;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            this.parent.setOther(s15);
        }

        @Override
        public void onNext(Object t15) {
            this.parent.run();
        }

        @Override
        public void onError(Throwable t15) {
            this.parent.error(t15);
        }

        @Override
        public void onComplete() {
            this.parent.complete();
        }
    }

    static abstract class SamplePublisherSubscriber<T>
    extends AtomicReference<T>
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = -3517602651313910099L;
        final Subscriber<? super T> downstream;
        final Publisher<?> sampler;
        final AtomicLong requested = new AtomicLong();
        final AtomicReference<Subscription> other = new AtomicReference();
        Subscription upstream;

        SamplePublisherSubscriber(Subscriber<? super T> actual, Publisher<?> other) {
            this.downstream = actual;
            this.sampler = other;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                this.downstream.onSubscribe(this);
                if (this.other.get() == null) {
                    this.sampler.subscribe(new SamplerSubscriber(this));
                    s15.request(Long.MAX_VALUE);
                }
            }
        }

        @Override
        public void onNext(T t15) {
            this.lazySet(t15);
        }

        @Override
        public void onError(Throwable t15) {
            SubscriptionHelper.cancel(this.other);
            this.downstream.onError(t15);
        }

        @Override
        public void onComplete() {
            SubscriptionHelper.cancel(this.other);
            this.completion();
        }

        void setOther(Subscription o15) {
            SubscriptionHelper.setOnce(this.other, o15, Long.MAX_VALUE);
        }

        @Override
        public void request(long n15) {
            if (SubscriptionHelper.validate(n15)) {
                BackpressureHelper.add(this.requested, n15);
            }
        }

        @Override
        public void cancel() {
            SubscriptionHelper.cancel(this.other);
            this.upstream.cancel();
        }

        public void error(Throwable e15) {
            this.upstream.cancel();
            this.downstream.onError(e15);
        }

        public void complete() {
            this.upstream.cancel();
            this.completion();
        }

        void emit() {
            Object value = this.getAndSet(null);
            if (value != null) {
                long r15 = this.requested.get();
                if (r15 != 0L) {
                    this.downstream.onNext(value);
                    BackpressureHelper.produced(this.requested, 1L);
                } else {
                    this.cancel();
                    this.downstream.onError(MissingBackpressureException.createDefault());
                }
            }
        }

        abstract void completion();

        abstract void run();
    }
}

