/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.internal.fuseable.FuseToFlowable;
import io.reactivex.rxjava3.internal.fuseable.HasUpstreamPublisher;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableReduce;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;

public final class FlowableReduceMaybe<T>
extends Maybe<T>
implements HasUpstreamPublisher<T>,
FuseToFlowable<T> {
    final Flowable<T> source;
    final BiFunction<T, T, T> reducer;

    public FlowableReduceMaybe(Flowable<T> source, BiFunction<T, T, T> reducer) {
        this.source = source;
        this.reducer = reducer;
    }

    @Override
    public Publisher<T> source() {
        return this.source;
    }

    @Override
    public Flowable<T> fuseToFlowable() {
        return RxJavaPlugins.onAssembly(new FlowableReduce<T>(this.source, this.reducer));
    }

    @Override
    protected void subscribeActual(MaybeObserver<? super T> observer) {
        this.source.subscribe((FlowableSubscriber<? super T>)new ReduceSubscriber<T>(observer, this.reducer));
    }

    static final class ReduceSubscriber<T>
    implements FlowableSubscriber<T>,
    Disposable {
        final MaybeObserver<? super T> downstream;
        final BiFunction<T, T, T> reducer;
        T value;
        Subscription upstream;
        boolean done;

        ReduceSubscriber(MaybeObserver<? super T> actual, BiFunction<T, T, T> reducer) {
            this.downstream = actual;
            this.reducer = reducer;
        }

        @Override
        public void dispose() {
            this.upstream.cancel();
            this.done = true;
        }

        @Override
        public boolean isDisposed() {
            return this.done;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                this.downstream.onSubscribe(this);
                s15.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t15) {
            if (this.done) {
                return;
            }
            T v15 = this.value;
            if (v15 == null) {
                this.value = t15;
            } else {
                try {
                    this.value = Objects.requireNonNull(this.reducer.apply(v15, t15), "The reducer returned a null value");
                }
                catch (Throwable ex4) {
                    Exceptions.throwIfFatal(ex4);
                    this.upstream.cancel();
                    this.onError(ex4);
                }
            }
        }

        @Override
        public void onError(Throwable t15) {
            if (this.done) {
                RxJavaPlugins.onError(t15);
                return;
            }
            this.done = true;
            this.downstream.onError(t15);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            T v15 = this.value;
            if (v15 != null) {
                this.downstream.onSuccess(v15);
            } else {
                this.downstream.onComplete();
            }
        }
    }
}

