/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.internal.subscriptions.BasicQueueSubscription;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.operators.ConditionalSubscriber;
import java.util.Iterator;
import java.util.Objects;
import org.reactivestreams.Subscriber;

public final class FlowableFromIterable<T>
extends Flowable<T> {
    final Iterable<? extends T> source;

    public FlowableFromIterable(Iterable<? extends T> source) {
        this.source = source;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> s15) {
        Iterator<? extends T> it;
        try {
            it = this.source.iterator();
        }
        catch (Throwable e15) {
            Exceptions.throwIfFatal(e15);
            EmptySubscription.error(e15, s15);
            return;
        }
        FlowableFromIterable.subscribe(s15, it);
    }

    public static <T> void subscribe(Subscriber<? super T> s15, Iterator<? extends T> it) {
        boolean hasNext;
        try {
            hasNext = it.hasNext();
        }
        catch (Throwable e15) {
            Exceptions.throwIfFatal(e15);
            EmptySubscription.error(e15, s15);
            return;
        }
        if (!hasNext) {
            EmptySubscription.complete(s15);
            return;
        }
        if (s15 instanceof ConditionalSubscriber) {
            s15.onSubscribe(new IteratorConditionalSubscription<T>((ConditionalSubscriber)s15, it));
        } else {
            s15.onSubscribe(new IteratorSubscription<T>(s15, it));
        }
    }

    static final class IteratorConditionalSubscription<T>
    extends BaseRangeSubscription<T> {
        private static final long serialVersionUID = -6022804456014692607L;
        final ConditionalSubscriber<? super T> downstream;

        IteratorConditionalSubscription(ConditionalSubscriber<? super T> actual, Iterator<? extends T> it) {
            super(it);
            this.downstream = actual;
        }

        @Override
        void fastPath() {
            boolean b15;
            Iterator it = this.iterator;
            ConditionalSubscriber a15 = this.downstream;
            do {
                Object t15;
                if (this.cancelled) {
                    return;
                }
                try {
                    t15 = it.next();
                }
                catch (Throwable ex4) {
                    Exceptions.throwIfFatal(ex4);
                    a15.onError(ex4);
                    return;
                }
                if (this.cancelled) {
                    return;
                }
                if (t15 == null) {
                    a15.onError(new NullPointerException("Iterator.next() returned a null value"));
                    return;
                }
                a15.tryOnNext(t15);
                if (this.cancelled) {
                    return;
                }
                try {
                    b15 = it.hasNext();
                }
                catch (Throwable ex5) {
                    Exceptions.throwIfFatal(ex5);
                    a15.onError(ex5);
                    return;
                }
            } while (b15);
            if (!this.cancelled) {
                a15.onComplete();
            }
        }

        @Override
        void slowPath(long r15) {
            long e15 = 0L;
            Iterator it = this.iterator;
            ConditionalSubscriber a15 = this.downstream;
            while (true) {
                if (e15 != r15) {
                    boolean hasNext;
                    Object t15;
                    if (this.cancelled) {
                        return;
                    }
                    try {
                        t15 = it.next();
                    }
                    catch (Throwable ex4) {
                        Exceptions.throwIfFatal(ex4);
                        a15.onError(ex4);
                        return;
                    }
                    if (this.cancelled) {
                        return;
                    }
                    if (t15 == null) {
                        a15.onError(new NullPointerException("Iterator.next() returned a null value"));
                        return;
                    }
                    boolean b15 = a15.tryOnNext(t15);
                    if (this.cancelled) {
                        return;
                    }
                    try {
                        hasNext = it.hasNext();
                    }
                    catch (Throwable ex5) {
                        Exceptions.throwIfFatal(ex5);
                        a15.onError(ex5);
                        return;
                    }
                    if (!hasNext) {
                        if (!this.cancelled) {
                            a15.onComplete();
                        }
                        return;
                    }
                    if (!b15) continue;
                    ++e15;
                    continue;
                }
                r15 = this.get();
                if (e15 != r15) continue;
                r15 = this.addAndGet(-e15);
                if (r15 == 0L) {
                    return;
                }
                e15 = 0L;
            }
        }
    }

    static final class IteratorSubscription<T>
    extends BaseRangeSubscription<T> {
        private static final long serialVersionUID = -6022804456014692607L;
        final Subscriber<? super T> downstream;

        IteratorSubscription(Subscriber<? super T> actual, Iterator<? extends T> it) {
            super(it);
            this.downstream = actual;
        }

        @Override
        void fastPath() {
            boolean b15;
            Iterator it = this.iterator;
            Subscriber a15 = this.downstream;
            do {
                Object t15;
                if (this.cancelled) {
                    return;
                }
                try {
                    t15 = it.next();
                }
                catch (Throwable ex4) {
                    Exceptions.throwIfFatal(ex4);
                    a15.onError(ex4);
                    return;
                }
                if (this.cancelled) {
                    return;
                }
                if (t15 == null) {
                    a15.onError(new NullPointerException("Iterator.next() returned a null value"));
                    return;
                }
                a15.onNext(t15);
                if (this.cancelled) {
                    return;
                }
                try {
                    b15 = it.hasNext();
                }
                catch (Throwable ex5) {
                    Exceptions.throwIfFatal(ex5);
                    a15.onError(ex5);
                    return;
                }
            } while (b15);
            if (!this.cancelled) {
                a15.onComplete();
            }
        }

        @Override
        void slowPath(long r15) {
            long e15 = 0L;
            Iterator it = this.iterator;
            Subscriber a15 = this.downstream;
            while (true) {
                if (e15 != r15) {
                    boolean b15;
                    Object t15;
                    if (this.cancelled) {
                        return;
                    }
                    try {
                        t15 = it.next();
                    }
                    catch (Throwable ex4) {
                        Exceptions.throwIfFatal(ex4);
                        a15.onError(ex4);
                        return;
                    }
                    if (this.cancelled) {
                        return;
                    }
                    if (t15 == null) {
                        a15.onError(new NullPointerException("Iterator.next() returned a null value"));
                        return;
                    }
                    a15.onNext(t15);
                    if (this.cancelled) {
                        return;
                    }
                    try {
                        b15 = it.hasNext();
                    }
                    catch (Throwable ex5) {
                        Exceptions.throwIfFatal(ex5);
                        a15.onError(ex5);
                        return;
                    }
                    if (!b15) {
                        if (!this.cancelled) {
                            a15.onComplete();
                        }
                        return;
                    }
                    ++e15;
                    continue;
                }
                r15 = this.get();
                if (e15 != r15) continue;
                r15 = this.addAndGet(-e15);
                if (r15 == 0L) {
                    return;
                }
                e15 = 0L;
            }
        }
    }

    static abstract class BaseRangeSubscription<T>
    extends BasicQueueSubscription<T> {
        private static final long serialVersionUID = -2252972430506210021L;
        Iterator<? extends T> iterator;
        volatile boolean cancelled;
        boolean once;

        BaseRangeSubscription(Iterator<? extends T> it) {
            this.iterator = it;
        }

        @Override
        public final int requestFusion(int mode) {
            return mode & 1;
        }

        @Override
        @Nullable
        public final T poll() {
            if (this.iterator == null) {
                return null;
            }
            if (!this.once) {
                this.once = true;
            } else if (!this.iterator.hasNext()) {
                return null;
            }
            return Objects.requireNonNull(this.iterator.next(), "Iterator.next() returned a null value");
        }

        @Override
        public final boolean isEmpty() {
            Iterator<T> it = this.iterator;
            if (it != null) {
                if (!this.once || it.hasNext()) {
                    return false;
                }
                this.clear();
            }
            return true;
        }

        @Override
        public final void clear() {
            this.iterator = null;
        }

        @Override
        public final void request(long n15) {
            if (SubscriptionHelper.validate(n15) && BackpressureHelper.add(this, n15) == 0L) {
                if (n15 == Long.MAX_VALUE) {
                    this.fastPath();
                } else {
                    this.slowPath(n15);
                }
            }
        }

        @Override
        public final void cancel() {
            this.cancelled = true;
        }

        abstract void fastPath();

        abstract void slowPath(long var1);
    }
}

