/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.exceptions.QueueOverflowException;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableFromIterable;
import io.reactivex.rxjava3.internal.subscriptions.BasicIntQueueSubscription;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.operators.QueueSubscription;
import io.reactivex.rxjava3.operators.SimpleQueue;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableFlattenIterable<T, R>
extends AbstractFlowableWithUpstream<T, R> {
    final Function<? super T, ? extends Iterable<? extends R>> mapper;
    final int prefetch;

    public FlowableFlattenIterable(Flowable<T> source, Function<? super T, ? extends Iterable<? extends R>> mapper, int prefetch) {
        super(source);
        this.mapper = mapper;
        this.prefetch = prefetch;
    }

    @Override
    public void subscribeActual(Subscriber<? super R> s15) {
        if (this.source instanceof Supplier) {
            Iterator<? extends R> it;
            Object v15;
            try {
                v15 = ((Supplier)((Object)this.source)).get();
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                EmptySubscription.error(ex4, s15);
                return;
            }
            if (v15 == null) {
                EmptySubscription.complete(s15);
                return;
            }
            try {
                Iterable<R> iterable = this.mapper.apply(v15);
                it = iterable.iterator();
            }
            catch (Throwable ex5) {
                Exceptions.throwIfFatal(ex5);
                EmptySubscription.error(ex5, s15);
                return;
            }
            FlowableFromIterable.subscribe(s15, it);
            return;
        }
        this.source.subscribe(new FlattenIterableSubscriber<T, R>(s15, this.mapper, this.prefetch));
    }

    public static <T, R> Subscriber<T> subscribe(Subscriber<? super R> downstream, Function<? super T, ? extends Iterable<? extends R>> mapper, int prefetch) {
        return new FlattenIterableSubscriber<T, R>(downstream, mapper, prefetch);
    }

    static final class FlattenIterableSubscriber<T, R>
    extends BasicIntQueueSubscription<R>
    implements FlowableSubscriber<T> {
        private static final long serialVersionUID = -3096000382929934955L;
        final Subscriber<? super R> downstream;
        final Function<? super T, ? extends Iterable<? extends R>> mapper;
        final int prefetch;
        final int limit;
        final AtomicLong requested;
        Subscription upstream;
        SimpleQueue<T> queue;
        volatile boolean done;
        volatile boolean cancelled;
        final AtomicReference<Throwable> error;
        Iterator<? extends R> current;
        int consumed;
        int fusionMode;

        FlattenIterableSubscriber(Subscriber<? super R> actual, Function<? super T, ? extends Iterable<? extends R>> mapper, int prefetch) {
            this.downstream = actual;
            this.mapper = mapper;
            this.prefetch = prefetch;
            this.limit = prefetch - (prefetch >> 2);
            this.error = new AtomicReference();
            this.requested = new AtomicLong();
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                if (s15 instanceof QueueSubscription) {
                    QueueSubscription qs4 = (QueueSubscription)s15;
                    int m15 = qs4.requestFusion(3);
                    if (m15 == 1) {
                        this.fusionMode = m15;
                        this.queue = qs4;
                        this.done = true;
                        this.downstream.onSubscribe(this);
                        return;
                    }
                    if (m15 == 2) {
                        this.fusionMode = m15;
                        this.queue = qs4;
                        this.downstream.onSubscribe(this);
                        s15.request(this.prefetch);
                        return;
                    }
                }
                this.queue = new SpscArrayQueue<T>(this.prefetch);
                this.downstream.onSubscribe(this);
                s15.request(this.prefetch);
            }
        }

        @Override
        public void onNext(T t15) {
            if (this.done) {
                return;
            }
            if (this.fusionMode == 0 && !this.queue.offer(t15)) {
                this.onError(new QueueOverflowException());
                return;
            }
            this.drain();
        }

        @Override
        public void onError(Throwable t15) {
            if (!this.done && ExceptionHelper.addThrowable(this.error, t15)) {
                this.done = true;
                this.drain();
            } else {
                RxJavaPlugins.onError(t15);
            }
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.drain();
        }

        @Override
        public void request(long n15) {
            if (SubscriptionHelper.validate(n15)) {
                BackpressureHelper.add(this.requested, n15);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.upstream.cancel();
                if (this.getAndIncrement() == 0) {
                    this.queue.clear();
                }
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            Subscriber<R> a15 = this.downstream;
            SimpleQueue<T> q15 = this.queue;
            boolean replenish = this.fusionMode != 1;
            int missed = 1;
            Iterator<R> it = this.current;
            while (true) {
                if (it == null) {
                    boolean empty;
                    T t15;
                    boolean d15 = this.done;
                    try {
                        t15 = q15.poll();
                    }
                    catch (Throwable ex4) {
                        Exceptions.throwIfFatal(ex4);
                        this.upstream.cancel();
                        ExceptionHelper.addThrowable(this.error, ex4);
                        ex4 = ExceptionHelper.terminate(this.error);
                        this.current = null;
                        q15.clear();
                        a15.onError(ex4);
                        return;
                    }
                    boolean bl4 = empty = t15 == null;
                    if (this.checkTerminated(d15, empty, a15, q15)) {
                        return;
                    }
                    if (t15 != null) {
                        boolean b15;
                        try {
                            Iterable<R> iterable = this.mapper.apply(t15);
                            it = iterable.iterator();
                            b15 = it.hasNext();
                        }
                        catch (Throwable ex5) {
                            Exceptions.throwIfFatal(ex5);
                            this.upstream.cancel();
                            ExceptionHelper.addThrowable(this.error, ex5);
                            ex5 = ExceptionHelper.terminate(this.error);
                            a15.onError(ex5);
                            return;
                        }
                        if (!b15) {
                            it = null;
                            this.consumedOne(replenish);
                            continue;
                        }
                        this.current = it;
                    }
                }
                if (it != null) {
                    long e15;
                    long r15 = this.requested.get();
                    for (e15 = 0L; e15 != r15; ++e15) {
                        R v15;
                        if (this.checkTerminated(this.done, false, a15, q15)) {
                            return;
                        }
                        try {
                            v15 = Objects.requireNonNull(it.next(), "The iterator returned a null value");
                        }
                        catch (Throwable ex6) {
                            Exceptions.throwIfFatal(ex6);
                            this.current = null;
                            this.upstream.cancel();
                            ExceptionHelper.addThrowable(this.error, ex6);
                            ex6 = ExceptionHelper.terminate(this.error);
                            a15.onError(ex6);
                            return;
                        }
                        a15.onNext(v15);
                        if (this.checkTerminated(this.done, false, a15, q15)) {
                            return;
                        }
                        try {
                            boolean b16 = it.hasNext();
                            continue;
                        }
                        catch (Throwable ex7) {
                            Exceptions.throwIfFatal(ex7);
                            this.current = null;
                            this.upstream.cancel();
                            ExceptionHelper.addThrowable(this.error, ex7);
                            ex7 = ExceptionHelper.terminate(this.error);
                            a15.onError(ex7);
                            return;
                        }
                    }
                    if (e15 == r15) {
                        boolean empty;
                        boolean d16 = this.done;
                        boolean bl5 = empty = q15.isEmpty() && it == null;
                        if (this.checkTerminated(d16, empty, a15, q15)) {
                            return;
                        }
                    }
                    if (e15 != 0L && r15 != Long.MAX_VALUE) {
                        this.requested.addAndGet(-e15);
                    }
                    if (it == null) continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        void consumedOne(boolean enabled) {
            if (enabled) {
                int c15 = this.consumed + 1;
                if (c15 == this.limit) {
                    this.consumed = 0;
                    this.upstream.request(c15);
                } else {
                    this.consumed = c15;
                }
            }
        }

        boolean checkTerminated(boolean d15, boolean empty, Subscriber<?> a15, SimpleQueue<?> q15) {
            if (this.cancelled) {
                this.current = null;
                q15.clear();
                return true;
            }
            if (d15) {
                Throwable ex4 = this.error.get();
                if (ex4 != null) {
                    ex4 = ExceptionHelper.terminate(this.error);
                    this.current = null;
                    q15.clear();
                    a15.onError(ex4);
                    return true;
                }
                if (empty) {
                    a15.onComplete();
                    return true;
                }
            }
            return false;
        }

        @Override
        public void clear() {
            this.current = null;
            this.queue.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.current == null && this.queue.isEmpty();
        }

        @Override
        @Nullable
        public R poll() throws Throwable {
            Iterator<R> it = this.current;
            while (it == null) {
                T v15 = this.queue.poll();
                if (v15 == null) {
                    return null;
                }
                it = this.mapper.apply(v15).iterator();
                if (!it.hasNext()) {
                    it = null;
                    continue;
                }
                this.current = it;
                break;
            }
            R r15 = Objects.requireNonNull(it.next(), "The iterator returned a null value");
            if (!it.hasNext()) {
                this.current = null;
            }
            return r15;
        }

        @Override
        public int requestFusion(int requestedMode) {
            if ((requestedMode & 1) != 0 && this.fusionMode == 1) {
                return 1;
            }
            return 0;
        }
    }
}

