/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.operators.SpscLinkedArrayQueue;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableFlatMapSingle<T, R>
extends AbstractFlowableWithUpstream<T, R> {
    final Function<? super T, ? extends SingleSource<? extends R>> mapper;
    final boolean delayErrors;
    final int maxConcurrency;

    public FlowableFlatMapSingle(Flowable<T> source, Function<? super T, ? extends SingleSource<? extends R>> mapper, boolean delayError, int maxConcurrency) {
        super(source);
        this.mapper = mapper;
        this.delayErrors = delayError;
        this.maxConcurrency = maxConcurrency;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s15) {
        this.source.subscribe(new FlatMapSingleSubscriber<T, R>(s15, this.mapper, this.delayErrors, this.maxConcurrency));
    }

    static final class FlatMapSingleSubscriber<T, R>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = 8600231336733376951L;
        final Subscriber<? super R> downstream;
        final boolean delayErrors;
        final int maxConcurrency;
        final AtomicLong requested;
        final CompositeDisposable set;
        final AtomicInteger active;
        final AtomicThrowable errors;
        final Function<? super T, ? extends SingleSource<? extends R>> mapper;
        final AtomicReference<SpscLinkedArrayQueue<R>> queue;
        Subscription upstream;
        volatile boolean cancelled;

        FlatMapSingleSubscriber(Subscriber<? super R> actual, Function<? super T, ? extends SingleSource<? extends R>> mapper, boolean delayErrors, int maxConcurrency) {
            this.downstream = actual;
            this.mapper = mapper;
            this.delayErrors = delayErrors;
            this.maxConcurrency = maxConcurrency;
            this.requested = new AtomicLong();
            this.set = new CompositeDisposable();
            this.errors = new AtomicThrowable();
            this.active = new AtomicInteger(1);
            this.queue = new AtomicReference();
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                this.downstream.onSubscribe(this);
                int m15 = this.maxConcurrency;
                if (m15 == Integer.MAX_VALUE) {
                    s15.request(Long.MAX_VALUE);
                } else {
                    s15.request(this.maxConcurrency);
                }
            }
        }

        @Override
        public void onNext(T t15) {
            SingleSource<R> ms4;
            try {
                ms4 = Objects.requireNonNull(this.mapper.apply(t15), "The mapper returned a null SingleSource");
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                this.upstream.cancel();
                this.onError(ex4);
                return;
            }
            this.active.getAndIncrement();
            InnerObserver inner = new InnerObserver();
            if (!this.cancelled && this.set.add(inner)) {
                ms4.subscribe(inner);
            }
        }

        @Override
        public void onError(Throwable t15) {
            this.active.decrementAndGet();
            if (this.errors.tryAddThrowableOrReport(t15)) {
                if (!this.delayErrors) {
                    this.set.dispose();
                }
                this.drain();
            }
        }

        @Override
        public void onComplete() {
            this.active.decrementAndGet();
            this.drain();
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.upstream.cancel();
            this.set.dispose();
            this.errors.tryTerminateAndReport();
        }

        @Override
        public void request(long n15) {
            if (SubscriptionHelper.validate(n15)) {
                BackpressureHelper.add(this.requested, n15);
                this.drain();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void innerSuccess(InnerObserver inner, R value) {
            this.set.delete(inner);
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                boolean d15;
                boolean bl4 = d15 = this.active.decrementAndGet() == 0;
                if (this.requested.get() != 0L) {
                    this.downstream.onNext(value);
                    SpscLinkedArrayQueue<R> q15 = this.queue.get();
                    if (d15 && (q15 == null || q15.isEmpty())) {
                        this.errors.tryTerminateConsumer(this.downstream);
                        return;
                    }
                    BackpressureHelper.produced(this.requested, 1L);
                    if (this.maxConcurrency != Integer.MAX_VALUE) {
                        this.upstream.request(1L);
                    }
                } else {
                    SpscLinkedArrayQueue<R> q16;
                    SpscLinkedArrayQueue<R> spscLinkedArrayQueue = q16 = this.getOrCreateQueue();
                    synchronized (spscLinkedArrayQueue) {
                        q16.offer(value);
                    }
                }
                if (this.decrementAndGet() == 0) {
                    return;
                }
            } else {
                SpscLinkedArrayQueue<R> q17;
                SpscLinkedArrayQueue<R> spscLinkedArrayQueue = q17 = this.getOrCreateQueue();
                synchronized (spscLinkedArrayQueue) {
                    q17.offer(value);
                }
                this.active.decrementAndGet();
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        SpscLinkedArrayQueue<R> getOrCreateQueue() {
            SpscLinkedArrayQueue<Object> current = this.queue.get();
            if (current != null) {
                return current;
            }
            current = new SpscLinkedArrayQueue(Flowable.bufferSize());
            if (this.queue.compareAndSet(null, current)) {
                return current;
            }
            return this.queue.get();
        }

        void innerError(InnerObserver inner, Throwable e15) {
            this.set.delete(inner);
            if (this.errors.tryAddThrowableOrReport(e15)) {
                if (!this.delayErrors) {
                    this.upstream.cancel();
                    this.set.dispose();
                } else if (this.maxConcurrency != Integer.MAX_VALUE) {
                    this.upstream.request(1L);
                }
                this.active.decrementAndGet();
                this.drain();
            }
        }

        void drain() {
            if (this.getAndIncrement() == 0) {
                this.drainLoop();
            }
        }

        void clear() {
            SpscLinkedArrayQueue<R> q15 = this.queue.get();
            if (q15 != null) {
                q15.clear();
            }
        }

        void drainLoop() {
            int missed = 1;
            Subscriber<R> a15 = this.downstream;
            AtomicInteger n15 = this.active;
            AtomicReference<SpscLinkedArrayQueue<R>> qr4 = this.queue;
            do {
                SpscLinkedArrayQueue<R> q15;
                boolean d15;
                long e15;
                long r15 = this.requested.get();
                for (e15 = 0L; e15 != r15; ++e15) {
                    boolean empty;
                    Throwable ex4;
                    if (this.cancelled) {
                        this.clear();
                        return;
                    }
                    if (!this.delayErrors && (ex4 = (Throwable)this.errors.get()) != null) {
                        this.clear();
                        this.errors.tryTerminateConsumer(this.downstream);
                        return;
                    }
                    d15 = n15.get() == 0;
                    q15 = qr4.get();
                    Object v15 = q15 != null ? (Object)q15.poll() : null;
                    boolean bl4 = empty = v15 == null;
                    if (d15 && empty) {
                        this.errors.tryTerminateConsumer(a15);
                        return;
                    }
                    if (empty) break;
                    a15.onNext(v15);
                }
                if (e15 == r15) {
                    boolean empty;
                    Throwable ex5;
                    if (this.cancelled) {
                        this.clear();
                        return;
                    }
                    if (!this.delayErrors && (ex5 = (Throwable)this.errors.get()) != null) {
                        this.clear();
                        this.errors.tryTerminateConsumer(a15);
                        return;
                    }
                    d15 = n15.get() == 0;
                    q15 = qr4.get();
                    boolean bl5 = empty = q15 == null || q15.isEmpty();
                    if (d15 && empty) {
                        this.errors.tryTerminateConsumer(a15);
                        return;
                    }
                }
                if (e15 == 0L) continue;
                BackpressureHelper.produced(this.requested, e15);
                if (this.maxConcurrency == Integer.MAX_VALUE) continue;
                this.upstream.request(e15);
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        final class InnerObserver
        extends AtomicReference<Disposable>
        implements SingleObserver<R>,
        Disposable {
            private static final long serialVersionUID = -502562646270949838L;

            InnerObserver() {
            }

            @Override
            public void onSubscribe(Disposable d15) {
                DisposableHelper.setOnce(this, d15);
            }

            @Override
            public void onSuccess(R value) {
                FlatMapSingleSubscriber.this.innerSuccess(this, value);
            }

            @Override
            public void onError(Throwable e15) {
                FlatMapSingleSubscriber.this.innerError(this, e15);
            }

            @Override
            public boolean isDisposed() {
                return DisposableHelper.isDisposed((Disposable)this.get());
            }

            @Override
            public void dispose() {
                DisposableHelper.dispose(this);
            }
        }
    }
}

