/*
 * Decompiled with CFR 0.152.
 */
package dev.dirs.impl;

import dev.dirs.impl.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public final class Linux {
    private Linux() {
        throw new Error();
    }

    static String ensureSingleSlash(String string, String string2) {
        boolean bl4 = string.endsWith("/");
        boolean bl5 = string2.startsWith("/");
        if (bl4 && bl5) {
            StringBuilder stringBuilder = new StringBuilder(string.length() + string2.length() - 1);
            stringBuilder.append(string, 0, string.length() - 1).append(string2);
            return stringBuilder.toString();
        }
        if (!bl4 && !bl5) {
            return string + '/' + string2;
        }
        return string + string2;
    }

    public static String runtimeDir(String string) {
        String string2 = System.getenv("XDG_RUNTIME_DIR");
        if (Util.isNullOrEmpty(string2)) {
            return null;
        }
        if (string == null) {
            return string2;
        }
        return string2 + '/' + string;
    }

    public static String executableDir(String string, String string2) {
        String string3 = System.getenv("XDG_BIN_HOME");
        if (Util.isNullOrEmpty(string3)) {
            return Util.defaultIfNullOrEmptyExtended(string2, "/../bin/", string, "/.local/bin/");
        }
        return string3;
    }

    public static String[] getXDGUserDirs(String ... stringArray) {
        int n15 = stringArray.length;
        StringBuilder stringBuilder = new StringBuilder(n15 * 22);
        String[] stringArray2 = new String[3];
        stringArray2[0] = "/bin/sh";
        stringArray2[1] = "-c";
        for (int i15 = 0; i15 < n15; ++i15) {
            stringBuilder.append("xdg-user-dir ");
            stringBuilder.append(stringArray[i15]);
            stringBuilder.append(';');
        }
        stringArray2[2] = stringBuilder.toString();
        try {
            return Linux.runCommands(n15, stringArray2);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] runCommands(int n15, String ... stringArray) throws IOException {
        Process process = new ProcessBuilder(stringArray).start();
        String[] stringArray2 = new String[n15];
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        try {
            for (int i15 = 0; i15 < n15; ++i15) {
                stringArray2[i15] = bufferedReader.readLine();
            }
            String[] stringArray3 = stringArray2;
            return stringArray3;
        }
        finally {
            process.destroy();
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

