/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io.enc;

import com.twelvemonkeys.io.enc.Decoder;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class DecoderStream
extends FilterInputStream {
    private final ByteBuffer buffer;
    private final Decoder decoder;

    public DecoderStream(InputStream inputStream, Decoder decoder) {
        this(inputStream, decoder, 1024);
    }

    public DecoderStream(InputStream inputStream, Decoder decoder, int n15) {
        super(inputStream);
        this.decoder = decoder;
        this.buffer = ByteBuffer.allocate(n15);
        this.buffer.flip();
    }

    @Override
    public int available() throws IOException {
        return this.buffer.remaining();
    }

    @Override
    public int read() throws IOException {
        if (!this.buffer.hasRemaining() && this.fill() < 0) {
            return -1;
        }
        return this.buffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n15, int n16) throws IOException {
        int n17;
        int n18;
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n15 < 0 || n15 > byArray.length || n16 < 0 || n15 + n16 > byArray.length || n15 + n16 < 0) {
            throw new IndexOutOfBoundsException("bytes.length=" + byArray.length + " offset=" + n15 + " length=" + n16);
        }
        if (n16 == 0) {
            return 0;
        }
        if (!this.buffer.hasRemaining() && this.fill() < 0) {
            return -1;
        }
        int n19 = n15;
        for (n17 = 0; n16 > n17 && (this.buffer.hasRemaining() || this.fill() >= 0); n17 += n18) {
            n18 = Math.min(n16 - n17, this.buffer.remaining());
            this.buffer.get(byArray, n19, n18);
            n19 += n18;
        }
        return n17;
    }

    @Override
    public long skip(long l15) throws IOException {
        long l16;
        int n15;
        if (!this.buffer.hasRemaining() && this.fill() < 0) {
            return 0L;
        }
        for (l16 = 0L; l16 < l15 && (this.buffer.hasRemaining() || this.fill() >= 0); l16 += (long)n15) {
            n15 = (int)Math.min(l15 - l16, (long)this.buffer.remaining());
            this.buffer.position(this.buffer.position() + n15);
        }
        return l16;
    }

    private int fill() throws IOException {
        this.buffer.clear();
        int n15 = this.decoder.decode(this.in, this.buffer);
        if (n15 > this.buffer.capacity()) {
            throw new AssertionError((Object)String.format("Decode beyond buffer (%d): %d (using %s decoder)", this.buffer.capacity(), n15, this.decoder.getClass().getName()));
        }
        this.buffer.flip();
        if (n15 == 0) {
            return -1;
        }
        return n15;
    }
}

