/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.webp.vp8;

import com.twelvemonkeys.imageio.plugins.webp.vp8.Globals;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;

final class BoolDecoder {
    private int bitCount;
    ImageInputStream data;
    private long offset;
    private int range;
    private int value;

    BoolDecoder(ImageInputStream imageInputStream, long l15) throws IOException {
        this.data = imageInputStream;
        this.offset = l15;
        this.initBoolDecoder();
    }

    private void initBoolDecoder() throws IOException {
        this.value = 0;
        this.data.seek(this.offset);
        this.value = this.data.readUnsignedByte() << 8;
        ++this.offset;
        this.range = 255;
        this.bitCount = 0;
    }

    public int readBit() throws IOException {
        return this.readBool(128);
    }

    public int readBool(int n15) throws IOException {
        int n16 = 0;
        int n17 = this.range;
        int n18 = this.value;
        int n19 = 1 + ((n17 - 1) * n15 >> 8);
        int n25 = n19 << 8;
        n17 = n19;
        if (n18 >= n25) {
            n17 = this.range - n19;
            n18 -= n25;
            n16 = 1;
        }
        int n26 = this.bitCount;
        int n27 = Globals.vp8dxBitreaderNorm[n17];
        n17 <<= n27;
        n18 <<= n27;
        if ((n26 -= n27) <= 0) {
            n18 |= this.data.readUnsignedByte() << -n26;
            ++this.offset;
            n26 += 8;
        }
        this.bitCount = n26;
        this.value = n18;
        this.range = n17;
        return n16;
    }

    public int readLiteral(int n15) throws IOException {
        int n16 = 0;
        while (n15-- > 0) {
            n16 = (n16 << 1) + this.readBool(128);
        }
        return n16;
    }

    int readTree(int[] nArray, int[] nArray2, int n15) throws IOException {
        int n16 = n15 * 2;
        while ((n16 = nArray[n16 + this.readBool(nArray2[n16 >> 1])]) > 0) {
        }
        return -n16;
    }

    public void seek() throws IOException {
        this.data.seek(this.offset);
    }

    public String toString() {
        return "bc: " + this.value;
    }
}

