/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.primitives.IgnoreJRERequirement;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.InlineMe;
import java.lang.reflect.Field;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import sun.misc.Unsafe;

@J2ktIncompatible
@GwtIncompatible
public final class UnsignedBytes {
    public static final byte MAX_POWER_OF_TWO = -128;
    public static final byte MAX_VALUE = -1;
    private static final int UNSIGNED_MASK = 255;

    private UnsignedBytes() {
    }

    @InlineMe(replacement="Byte.toUnsignedInt(value)")
    public static int toInt(byte value) {
        return Byte.toUnsignedInt(value);
    }

    @CanIgnoreReturnValue
    public static byte checkedCast(long value) {
        Preconditions.checkArgument(value >> 8 == 0L, "out of range: %s", value);
        return (byte)value;
    }

    public static byte saturatedCast(long value) {
        if (value > (long)Byte.toUnsignedInt((byte)-1)) {
            return -1;
        }
        if (value < 0L) {
            return 0;
        }
        return (byte)value;
    }

    public static int compare(byte a15, byte b15) {
        return Byte.toUnsignedInt(a15) - Byte.toUnsignedInt(b15);
    }

    public static byte min(byte ... array) {
        Preconditions.checkArgument(array.length > 0);
        int min = Byte.toUnsignedInt(array[0]);
        for (int i15 = 1; i15 < array.length; ++i15) {
            int next = Byte.toUnsignedInt(array[i15]);
            if (next >= min) continue;
            min = next;
        }
        return (byte)min;
    }

    public static byte max(byte ... array) {
        Preconditions.checkArgument(array.length > 0);
        int max = Byte.toUnsignedInt(array[0]);
        for (int i15 = 1; i15 < array.length; ++i15) {
            int next = Byte.toUnsignedInt(array[i15]);
            if (next <= max) continue;
            max = next;
        }
        return (byte)max;
    }

    public static String toString(byte x15) {
        return UnsignedBytes.toString(x15, 10);
    }

    public static String toString(byte x15, int radix) {
        Preconditions.checkArgument(radix >= 2 && radix <= 36, "radix (%s) must be between Character.MIN_RADIX and Character.MAX_RADIX", radix);
        return Integer.toString(Byte.toUnsignedInt(x15), radix);
    }

    @CanIgnoreReturnValue
    public static byte parseUnsignedByte(String string) {
        return UnsignedBytes.parseUnsignedByte(string, 10);
    }

    @CanIgnoreReturnValue
    public static byte parseUnsignedByte(String string, int radix) {
        int parse = Integer.parseInt(Preconditions.checkNotNull(string), radix);
        if (parse >> 8 == 0) {
            return (byte)parse;
        }
        throw new NumberFormatException("out of range: " + parse);
    }

    public static String join(String separator, byte ... array) {
        Preconditions.checkNotNull(separator);
        if (array.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array.length * (3 + separator.length()));
        builder.append(Byte.toUnsignedInt(array[0]));
        for (int i15 = 1; i15 < array.length; ++i15) {
            builder.append(separator).append(UnsignedBytes.toString(array[i15]));
        }
        return builder.toString();
    }

    public static Comparator<byte[]> lexicographicalComparator() {
        return LexicographicalComparatorHolder.BEST_COMPARATOR;
    }

    @VisibleForTesting
    static Comparator<byte[]> lexicographicalComparatorJavaImpl() {
        return LexicographicalComparatorHolder.PureJavaComparator.INSTANCE;
    }

    private static byte flip(byte b15) {
        return (byte)(b15 ^ 0x80);
    }

    public static void sort(byte[] array) {
        Preconditions.checkNotNull(array);
        UnsignedBytes.sort(array, 0, array.length);
    }

    public static void sort(byte[] array, int fromIndex, int toIndex) {
        int i15;
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        for (i15 = fromIndex; i15 < toIndex; ++i15) {
            array[i15] = UnsignedBytes.flip(array[i15]);
        }
        Arrays.sort(array, fromIndex, toIndex);
        for (i15 = fromIndex; i15 < toIndex; ++i15) {
            array[i15] = UnsignedBytes.flip(array[i15]);
        }
    }

    public static void sortDescending(byte[] array) {
        Preconditions.checkNotNull(array);
        UnsignedBytes.sortDescending(array, 0, array.length);
    }

    public static void sortDescending(byte[] array, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        int i15 = fromIndex;
        while (i15 < toIndex) {
            int n15 = i15++;
            array[n15] = (byte)(array[n15] ^ 0x7F);
        }
        Arrays.sort(array, fromIndex, toIndex);
        i15 = fromIndex;
        while (i15 < toIndex) {
            int n16 = i15++;
            array[n16] = (byte)(array[n16] ^ 0x7F);
        }
    }

    @VisibleForTesting
    static final class LexicographicalComparatorHolder {
        static final String UNSAFE_COMPARATOR_NAME = LexicographicalComparatorHolder.class.getName() + "$UnsafeComparator";
        static final Comparator<byte[]> BEST_COMPARATOR = LexicographicalComparatorHolder.getBestComparator();

        static Comparator<byte[]> getBestComparator() {
            Comparator<byte[]> arraysCompareUnsignedComparator = ArraysCompareUnsignedComparatorMaker.INSTANCE.tryMakeArraysCompareUnsignedComparator();
            if (arraysCompareUnsignedComparator != null) {
                return arraysCompareUnsignedComparator;
            }
            try {
                Class<?> theClass = Class.forName(UNSAFE_COMPARATOR_NAME);
                ?[] constants = Objects.requireNonNull(theClass.getEnumConstants());
                Comparator comparator = (Comparator)constants[0];
                return comparator;
            }
            catch (Throwable t15) {
                return UnsignedBytes.lexicographicalComparatorJavaImpl();
            }
        }

        private LexicographicalComparatorHolder() {
        }

        static enum PureJavaComparator implements Comparator<byte[]>
        {
            INSTANCE;


            @Override
            public int compare(byte[] left, byte[] right) {
                int minLength = Math.min(left.length, right.length);
                for (int i15 = 0; i15 < minLength; ++i15) {
                    int result = UnsignedBytes.compare(left[i15], right[i15]);
                    if (result == 0) continue;
                    return result;
                }
                return left.length - right.length;
            }

            public String toString() {
                return "UnsignedBytes.lexicographicalComparator() (pure Java version)";
            }
        }

        @VisibleForTesting
        static enum UnsafeComparator implements Comparator<byte[]>
        {
            INSTANCE;

            static final boolean BIG_ENDIAN;
            static final Unsafe theUnsafe;
            static final int BYTE_ARRAY_BASE_OFFSET;

            private static Unsafe getUnsafe() {
                try {
                    return Unsafe.getUnsafe();
                }
                catch (SecurityException securityException) {
                    try {
                        return AccessController.doPrivileged(() -> {
                            Class<Unsafe> k15 = Unsafe.class;
                            for (Field f15 : k15.getDeclaredFields()) {
                                f15.setAccessible(true);
                                Object x15 = f15.get(null);
                                if (!k15.isInstance(x15)) continue;
                                return (Unsafe)k15.cast(x15);
                            }
                            throw new NoSuchFieldError("the Unsafe");
                        });
                    }
                    catch (PrivilegedActionException e15) {
                        throw new RuntimeException("Could not initialize intrinsics", e15.getCause());
                    }
                }
            }

            @Override
            public int compare(byte[] left, byte[] right) {
                int i15;
                int stride = 8;
                int minLength = Math.min(left.length, right.length);
                int strideLimit = minLength & ~(stride - 1);
                for (i15 = 0; i15 < strideLimit; i15 += stride) {
                    long rw4;
                    long lw4 = theUnsafe.getLong(left, (long)BYTE_ARRAY_BASE_OFFSET + (long)i15);
                    if (lw4 == (rw4 = theUnsafe.getLong(right, (long)BYTE_ARRAY_BASE_OFFSET + (long)i15))) continue;
                    if (BIG_ENDIAN) {
                        return Long.compareUnsigned(lw4, rw4);
                    }
                    int n15 = Long.numberOfTrailingZeros(lw4 ^ rw4) & 0xFFFFFFF8;
                    return (int)(lw4 >>> n15 & 0xFFL) - (int)(rw4 >>> n15 & 0xFFL);
                }
                while (i15 < minLength) {
                    int result = UnsignedBytes.compare(left[i15], right[i15]);
                    if (result != 0) {
                        return result;
                    }
                    ++i15;
                }
                return left.length - right.length;
            }

            public String toString() {
                return "UnsignedBytes.lexicographicalComparator() (sun.misc.Unsafe version)";
            }

            static {
                BIG_ENDIAN = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN);
                theUnsafe = UnsafeComparator.getUnsafe();
                BYTE_ARRAY_BASE_OFFSET = theUnsafe.arrayBaseOffset(byte[].class);
                if (!Objects.equals(System.getProperty("sun.arch.data.model"), "64") || BYTE_ARRAY_BASE_OFFSET % 8 != 0 || theUnsafe.arrayIndexScale(byte[].class) != 1) {
                    throw new Error();
                }
            }
        }
    }

    static enum ArraysCompareUnsignedComparator implements Comparator<byte[]>
    {
        INSTANCE;


        @Override
        @IgnoreJRERequirement
        public int compare(byte[] left, byte[] right) {
            return Arrays.compareUnsigned(left, right);
        }
    }

    private static enum ArraysCompareUnsignedComparatorMaker {
        INSTANCE{

            @Override
            @IgnoreJRERequirement
            @Nullable Comparator<byte[]> tryMakeArraysCompareUnsignedComparator() {
                try {
                    Arrays.class.getMethod("compareUnsigned", byte[].class, byte[].class);
                }
                catch (NoSuchMethodException beforeJava9) {
                    return null;
                }
                return ArraysCompareUnsignedComparator.INSTANCE;
            }
        };


        @Nullable Comparator<byte[]> tryMakeArraysCompareUnsignedComparator() {
            return null;
        }
    }
}

