/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.paint.impl;

import com.github.weisj.jsvg.attributes.value.ColorValue;
import com.github.weisj.jsvg.renderer.MeasureContext;
import com.github.weisj.jsvg.util.ColorUtil;
import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class RGBColor
implements Paint,
ColorValue {
    public static final RGBColor INHERITED = new RGBColor(0, 0, 0, 0);
    public static final RGBColor DEFAULT = new RGBColor(0, 0, 0, 255);
    private final int r;
    private final int g;
    private final int b;
    private final int a;
    private Color color;

    public RGBColor(int r15, int g15, int b15, int a15) {
        this.r = r15;
        this.g = g15;
        this.b = b15;
        this.a = a15;
    }

    public RGBColor(@NotNull Color color) {
        this(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        this.color = color;
    }

    @NotNull
    public static RGBColor interpolate(float t15, @NotNull RGBColor a15, @NotNull RGBColor b15) {
        return new RGBColor(Math.round((float)a15.r + (float)(b15.r - a15.r) * t15), Math.round((float)a15.g + (float)(b15.g - a15.g) * t15), Math.round((float)a15.b + (float)(b15.b - a15.b) * t15), Math.round((float)a15.a + (float)(b15.a - a15.a) * t15));
    }

    @NotNull
    public static RGBColor saxpy(float t15, @NotNull RGBColor a15, @NotNull RGBColor b15) {
        return new RGBColor(Math.round((float)a15.r + t15 * (float)b15.r), Math.round((float)a15.g + t15 * (float)b15.g), Math.round((float)a15.b + t15 * (float)b15.b), Math.round((float)a15.a + t15 * (float)b15.a));
    }

    @NotNull
    public static RGBColor add(@NotNull RGBColor a15, @NotNull RGBColor b15) {
        return new RGBColor(a15.r + b15.r, a15.g + b15.g, a15.b + b15.b, a15.a + b15.a);
    }

    @NotNull
    public Color toColor() {
        if (this.color == null) {
            this.color = new Color(ColorUtil.clampColor(this.r), ColorUtil.clampColor(this.g), ColorUtil.clampColor(this.b), ColorUtil.clampColor(this.a));
        }
        return this.color;
    }

    public boolean isVisible() {
        return this.a > 0;
    }

    public static boolean isVisible(@NotNull Color c15) {
        return c15.getAlpha() > 0;
    }

    @Contract(pure=true)
    @NotNull
    public String toString() {
        return "ColorValue{r=" + this.r + ", g=" + this.g + ", b=" + this.b + ", a=" + this.a + '}';
    }

    public boolean equals(Object o15) {
        if (this == o15) {
            return true;
        }
        if (o15 == null || this.getClass() != o15.getClass()) {
            return false;
        }
        RGBColor that = (RGBColor)o15;
        return this.r == that.r && this.g == that.g && this.b == that.b && this.a == that.a;
    }

    public int hashCode() {
        return Objects.hash(this.r, this.g, this.b, this.a);
    }

    @Override
    public PaintContext createContext(ColorModel cm4, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        return this.toColor().createContext(cm4, deviceBounds, userBounds, xform, hints);
    }

    @Override
    public int getTransparency() {
        return this.toColor().getTransparency();
    }

    @Override
    @NotNull
    public Color get(@NotNull MeasureContext context) {
        return this.toColor();
    }
}

