/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.geometry.path;

import com.github.weisj.jsvg.geometry.path.BuildHistory;
import com.github.weisj.jsvg.geometry.path.PathCommand;
import com.github.weisj.jsvg.util.ShapeUtil;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import org.jetbrains.annotations.NotNull;

final class Arc
extends PathCommand {
    private final float rx;
    private final float ry;
    private final float xAxisRot;
    private final boolean largeArc;
    private final boolean sweep;
    private final float x;
    private final float y;

    public Arc(boolean isRelative, float rx4, float ry4, float xAxisRot, boolean largeArc, boolean sweep, float x15, float y15) {
        super(isRelative, 6);
        this.rx = rx4;
        this.ry = ry4;
        this.xAxisRot = xAxisRot;
        this.largeArc = largeArc;
        this.sweep = sweep;
        this.x = x15;
        this.y = y15;
    }

    @Override
    public void appendPath(@NotNull Path2D path, @NotNull BuildHistory hist) {
        Point2D.Float offset = this.offset(hist);
        this.arcTo(path, this.rx, this.ry, this.xAxisRot, this.largeArc, this.sweep, this.x + offset.x, this.y + offset.y, hist.lastPoint.x, hist.lastPoint.y);
        hist.setLast(path.getCurrentPoint());
    }

    private void arcTo(@NotNull Path2D path, float rx4, float ry4, float angle, boolean largeArcFlag, boolean sweepFlag, float x15, float y15, float x05, float y05) {
        if (rx4 == 0.0f || ry4 == 0.0f) {
            path.lineTo(x15, y15);
            return;
        }
        if (x05 == x15 && y05 == y15) {
            return;
        }
        Arc2D arc = Arc.computeRawArc(x05, y05, rx4, ry4, angle, largeArcFlag, sweepFlag, x15, y15);
        AffineTransform t15 = AffineTransform.getRotateInstance(Math.toRadians(angle), arc.getCenterX(), arc.getCenterY());
        Shape s15 = ShapeUtil.transformShape(arc, t15);
        path.append(s15, true);
    }

    @NotNull
    private static Arc2D computeRawArc(double x05, double y05, double rx4, double ry4, double angle, boolean largeArcFlag, boolean sweepFlag, double x15, double y15) {
        double pRy;
        double pY1;
        double dx22 = (x05 - x15) / 2.0;
        double dy22 = (y05 - y15) / 2.0;
        angle = Math.toRadians(angle % 360.0);
        double cosAngle = Math.cos(angle);
        double sinAngle = Math.sin(angle);
        double x16 = cosAngle * dx22 + sinAngle * dy22;
        double y16 = -sinAngle * dx22 + cosAngle * dy22;
        double pX1 = x16 * x16;
        double pRx = (rx4 = Math.abs(rx4)) * rx4;
        double radiiCheck = pX1 / pRx + (pY1 = y16 * y16) / (pRy = (ry4 = Math.abs(ry4)) * ry4);
        if (radiiCheck > 1.0) {
            rx4 = Math.sqrt(radiiCheck) * rx4;
            ry4 = Math.sqrt(radiiCheck) * ry4;
            pRx = rx4 * rx4;
            pRy = ry4 * ry4;
        }
        double sign = largeArcFlag == sweepFlag ? -1.0 : 1.0;
        double sq4 = (pRx * pRy - pRx * pY1 - pRy * pX1) / (pRx * pY1 + pRy * pX1);
        sq4 = sq4 < 0.0 ? 0.0 : sq4;
        double coefficient = sign * Math.sqrt(sq4);
        double cx12 = coefficient * (rx4 * y16 / ry4);
        double cy12 = coefficient * -(ry4 * x16 / rx4);
        double sx22 = (x05 + x15) / 2.0;
        double sy22 = (y05 + y15) / 2.0;
        double cx4 = sx22 + (cosAngle * cx12 - sinAngle * cy12);
        double cy4 = sy22 + (sinAngle * cx12 + cosAngle * cy12);
        double ux4 = (x16 - cx12) / rx4;
        double uy4 = (y16 - cy12) / ry4;
        double vx4 = (-x16 - cx12) / rx4;
        double vy4 = (-y16 - cy12) / ry4;
        double n15 = Math.sqrt(ux4 * ux4 + uy4 * uy4);
        double p15 = ux4;
        sign = uy4 < 0.0 ? -1.0 : 1.0;
        double angleStart = Math.toDegrees(sign * Math.acos(p15 / n15));
        n15 = Math.sqrt((ux4 * ux4 + uy4 * uy4) * (vx4 * vx4 + vy4 * vy4));
        p15 = ux4 * vx4 + uy4 * vy4;
        sign = ux4 * vy4 - uy4 * vx4 < 0.0 ? -1.0 : 1.0;
        double angleExtent = Math.toDegrees(sign * Math.acos(p15 / n15));
        if (!sweepFlag && angleExtent > 0.0) {
            angleExtent -= 360.0;
        } else if (sweepFlag && angleExtent < 0.0) {
            angleExtent += 360.0;
        }
        angleExtent %= 360.0;
        angleStart %= 360.0;
        Arc2D.Double arc = new Arc2D.Double();
        arc.x = cx4 - rx4;
        arc.y = cy4 - ry4;
        arc.width = rx4 * 2.0;
        arc.height = ry4 * 2.0;
        arc.start = -angleStart;
        arc.extent = -angleExtent;
        return arc;
    }

    public String toString() {
        return "A " + this.rx + " " + this.ry + " " + this.xAxisRot + " " + this.largeArc + " " + this.sweep + " " + this.x + " " + this.y;
    }
}

