/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.geometry.noise;

import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.Nullable;

public final class PerlinTurbulence {
    private static final int RAND_m = Integer.MAX_VALUE;
    private static final int RAND_a = 16807;
    private static final int RAND_q = 127773;
    private static final int RAND_r = 2836;
    private static final int BSize = 256;
    private static final int BM = 255;
    private static final double PerlinN = 4096.0;
    private final int[] uLatticeSelector = new int[257];
    private final double[] fGradient = new double[2056];
    private final int numOctaves;
    private final double xFrequency;
    private final double yFrequency;

    public PerlinTurbulence(int seed, int numOctaves, double xFrequency, double yFrequency) {
        this.numOctaves = numOctaves;
        this.xFrequency = xFrequency;
        this.yFrequency = yFrequency;
        this.init(seed);
    }

    private static int setupSeed(int seed) {
        if (seed <= 0) {
            seed = -(seed % 0x7FFFFFFE) + 1;
        }
        if (seed > 0x7FFFFFFE) {
            seed = 0x7FFFFFFE;
        }
        return seed;
    }

    private static int random(int seed) {
        int result = 16807 * (seed % 127773) - 2836 * (seed / 127773);
        if (result <= 0) {
            result += Integer.MAX_VALUE;
        }
        return result;
    }

    private void init(int seed) {
        int j15;
        int i15;
        int k15;
        int lSeed = PerlinTurbulence.setupSeed(seed);
        for (k15 = 0; k15 < 4; ++k15) {
            for (i15 = 0; i15 < 256; ++i15) {
                double v15;
                double u15;
                do {
                    lSeed = PerlinTurbulence.random(lSeed);
                    u15 = (double)(lSeed % 512) - 256.0;
                    lSeed = PerlinTurbulence.random(lSeed);
                    v15 = (double)(lSeed % 512) - 256.0;
                } while (u15 == 0.0 && v15 == 0.0);
                double s15 = Math.sqrt(u15 * u15 + v15 * v15);
                double si4 = 1.0 / s15;
                this.fGradient[i15 * 8 + k15 * 2] = u15 * si4;
                this.fGradient[i15 * 8 + k15 * 2 + 1] = v15 * si4;
            }
        }
        for (i15 = 0; i15 < 256; ++i15) {
            this.uLatticeSelector[i15] = i15;
        }
        while (--i15 > 0) {
            k15 = this.uLatticeSelector[i15];
            lSeed = PerlinTurbulence.random(lSeed);
            j15 = lSeed % 256;
            this.uLatticeSelector[i15] = this.uLatticeSelector[j15];
            this.uLatticeSelector[j15] = k15;
            int s15 = i15 << 3;
            int s25 = j15 << 3;
            for (j15 = 0; j15 < 8; ++j15) {
                double s16 = this.fGradient[s15 + j15];
                this.fGradient[s15 + j15] = this.fGradient[s25 + j15];
                this.fGradient[s25 + j15] = s16;
            }
        }
        this.uLatticeSelector[256] = this.uLatticeSelector[0];
        for (j15 = 0; j15 < 8; ++j15) {
            this.fGradient[2048 + j15] = this.fGradient[j15];
        }
    }

    private static double curve(double t15) {
        return t15 * t15 * (3.0 - 2.0 * t15);
    }

    private static double lerp(double t15, double a15, double b15) {
        return a15 + t15 * (b15 - a15);
    }

    private void noise2(double[] noiseChannels, double vec0, double vec1, @Nullable StitchInfo stitchInfo) {
        double t15 = vec0 + 4096.0;
        int bx02 = (int)t15;
        int bx12 = bx02 + 1;
        double rx02 = t15 - (double)bx02;
        double rx12 = rx02 - 1.0;
        double sx4 = PerlinTurbulence.curve(rx02);
        t15 = vec1 + 4096.0;
        int by02 = (int)t15;
        int by12 = by02 + 1;
        double ry02 = t15 - (double)((int)t15);
        double ry12 = ry02 - 1.0;
        double sy4 = PerlinTurbulence.curve(ry02);
        if (stitchInfo != null) {
            if (bx02 >= stitchInfo.wrapX) {
                bx02 -= stitchInfo.width;
            }
            if (bx12 >= stitchInfo.wrapX) {
                bx12 -= stitchInfo.width;
            }
            if (by02 >= stitchInfo.wrapY) {
                by02 -= stitchInfo.height;
            }
            if (by12 >= stitchInfo.wrapY) {
                by12 -= stitchInfo.height;
            }
        }
        int i15 = this.uLatticeSelector[bx02 &= 0xFF];
        int j15 = this.uLatticeSelector[bx12 &= 0xFF];
        int b002 = (i15 + (by02 &= 0xFF) & 0xFF) << 3;
        int b102 = (j15 + by02 & 0xFF) << 3;
        int b012 = (i15 + (by12 &= 0xFF) & 0xFF) << 3;
        int b112 = (j15 + by12 & 0xFF) << 3;
        for (int channelIndex = 0; channelIndex < noiseChannels.length; ++channelIndex) {
            int offset = 2 * channelIndex;
            noiseChannels[channelIndex] = PerlinTurbulence.lerp(sy4, PerlinTurbulence.lerp(sx4, rx02 * this.fGradient[b002 + offset] + ry02 * this.fGradient[b002 + offset + 1], rx12 * this.fGradient[b102 + offset] + ry02 * this.fGradient[b102 + offset + 1]), PerlinTurbulence.lerp(sx4, rx02 * this.fGradient[b012 + offset] + ry12 * this.fGradient[b012 + offset + 1], rx12 * this.fGradient[b112 + offset] + ry12 * this.fGradient[b112 + offset + 1]));
        }
    }

    public void turbulence(double[] turbulenceChannels, double pointX, double pointY, boolean fractalSum, @Nullable StitchInfo stitchInfo, @Nullable Rectangle2D.Double tile) {
        double[] dArray;
        double baseFrequencyX = this.xFrequency;
        double baseFrequencyY = this.yFrequency;
        if (stitchInfo != null) {
            assert (tile != null);
            if (baseFrequencyX != 0.0) {
                baseFrequencyX = this.adjustFrequency(baseFrequencyX, tile.width);
            }
            if (baseFrequencyY != 0.0) {
                baseFrequencyY = this.adjustFrequency(baseFrequencyY, tile.height);
            }
            stitchInfo.width = (int)(tile.width * baseFrequencyX + 0.5);
            stitchInfo.wrapX = (int)(tile.x * baseFrequencyX + 4096.0 + (double)stitchInfo.width);
            stitchInfo.height = (int)(tile.height * baseFrequencyY + 0.5);
            stitchInfo.wrapY = (int)(tile.y * baseFrequencyY + 4096.0 + (double)stitchInfo.height);
        }
        if (fractalSum) {
            double[] dArray2 = new double[4];
            dArray2[0] = 127.5;
            dArray2[1] = 127.5;
            dArray2[2] = 127.5;
            dArray = dArray2;
            dArray2[3] = 127.5;
        } else {
            double[] dArray3 = new double[4];
            dArray3[0] = 0.0;
            dArray3[1] = 0.0;
            dArray3[2] = 0.0;
            dArray = dArray3;
            dArray3[3] = 0.0;
        }
        double[] fSum = dArray;
        double vec0 = pointX * baseFrequencyX;
        double vec1 = pointY * baseFrequencyY;
        double ratio = fractalSum ? 127.5 : 255.0;
        for (int nOctave = 0; nOctave < this.numOctaves; ++nOctave) {
            int i15;
            this.noise2(turbulenceChannels, vec0, vec1, stitchInfo);
            if (fractalSum) {
                for (i15 = 0; i15 < turbulenceChannels.length; ++i15) {
                    int n15 = i15;
                    fSum[n15] = fSum[n15] + turbulenceChannels[i15] * ratio;
                }
            } else {
                for (i15 = 0; i15 < turbulenceChannels.length; ++i15) {
                    int n16 = i15;
                    fSum[n16] = fSum[n16] + Math.abs(turbulenceChannels[i15]) * ratio;
                }
            }
            vec0 *= 2.0;
            vec1 *= 2.0;
            ratio *= 0.5;
            if (stitchInfo == null) continue;
            stitchInfo.width *= 2;
            stitchInfo.wrapX *= 2;
            stitchInfo.wrapX += 4096;
            stitchInfo.height *= 2;
            stitchInfo.wrapY *= 2;
            stitchInfo.wrapY += 4096;
        }
        System.arraycopy(fSum, 0, turbulenceChannels, 0, fSum.length);
    }

    private double adjustFrequency(double frequency, double tileSize) {
        double fHiFreq;
        double fLoFreq = Math.floor(tileSize * frequency) / tileSize;
        if (frequency / fLoFreq < (fHiFreq = Math.ceil(tileSize * frequency) / tileSize) / frequency) {
            return fLoFreq;
        }
        return fHiFreq;
    }

    public static final class StitchInfo {
        private int width;
        private int height;
        private int wrapX;
        private int wrapY;
    }
}

