/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.geometry.mesh;

import com.github.weisj.jsvg.geometry.mesh.LineBezier;
import com.github.weisj.jsvg.geometry.mesh.MeshUtil;
import com.github.weisj.jsvg.geometry.mesh.Split;
import com.github.weisj.jsvg.geometry.util.GeometryUtil;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import org.jetbrains.annotations.NotNull;

public class Bezier {
    @NotNull
    public final Point2D.Float a;
    @NotNull
    public final Point2D.Float b;
    @NotNull
    public final Point2D.Float c;
    @NotNull
    public final Point2D.Float d;

    public Bezier(@NotNull Point2D.Float a15, @NotNull Point2D.Float b15, @NotNull Point2D.Float c15, @NotNull Point2D.Float d15) {
        this.a = a15;
        this.b = b15;
        this.c = c15;
        this.d = d15;
    }

    public void appendTo(@NotNull Path2D p15) {
        p15.curveTo(this.b.x, this.b.y, this.c.x, this.c.y, this.d.x, this.d.y);
    }

    @NotNull
    public Bezier inverse() {
        return new Bezier(this.d, this.c, this.b, this.a);
    }

    @NotNull
    public Split<Bezier> split() {
        Point2D.Float ab5 = GeometryUtil.midPoint(this.a, this.b);
        Point2D.Float bc5 = GeometryUtil.midPoint(this.b, this.c);
        Point2D.Float cd5 = GeometryUtil.midPoint(this.c, this.d);
        Point2D.Float abbc = GeometryUtil.midPoint(ab5, bc5);
        Point2D.Float bccd = GeometryUtil.midPoint(bc5, cd5);
        Point2D.Float abbcbccd = GeometryUtil.midPoint(abbc, bccd);
        return new Split<Bezier>(new Bezier(this.a, ab5, abbc, abbcbccd), new Bezier(abbcbccd, bccd, cd5, this.d));
    }

    @NotNull
    public static Bezier straightLine(Point2D.Float a15, Point2D.Float b15) {
        return new LineBezier(a15, b15);
    }

    @NotNull
    public static Bezier combine(@NotNull Bezier b15, @NotNull Bezier b25, @NotNull Bezier b35) {
        return new Bezier(MeshUtil.p(b15.a.x + b25.a.x - b35.a.x, b15.a.y + b25.a.y - b35.a.y), MeshUtil.p(b15.b.x + b25.b.x - b35.b.x, b15.b.y + b25.b.y - b35.b.y), MeshUtil.p(b15.c.x + b25.c.x - b35.c.x, b15.c.y + b25.c.y - b35.c.y), MeshUtil.p(b15.d.x + b25.d.x - b35.d.x, b15.d.y + b25.d.y - b35.d.y));
    }

    public int estimateStepCount(float scaleX, float scaleY) {
        double steps = Math.max(Math.max(GeometryUtil.distanceSquared(this.a, this.b, scaleX, scaleY), GeometryUtil.distanceSquared(this.c, this.d, scaleX, scaleY)), Math.max(GeometryUtil.distanceSquared(this.a, this.c, scaleX, scaleY) / 4.0, GeometryUtil.distanceSquared(this.b, this.d, scaleX, scaleY) / 4.0));
        steps *= 18.0;
        steps = Math.max(1.0, steps);
        return (Math.getExponent(steps) + 1) / 2;
    }

    public String toString() {
        return "Bezier{a=" + this.a + ", b=" + this.b + ", c=" + this.c + ", d=" + this.d + '}';
    }
}

