/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.icons;

import com.formdev.flatlaf.icons.FlatAbstractIcon;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;
import javax.swing.UIManager;

@FlatStylingSupport.StyleableField(cls=FlatAbstractIcon.class, key="scale")
public class FlatCheckBoxMenuItemIcon
extends FlatAbstractIcon
implements FlatStylingSupport.StyleableObject {
    @FlatStylingSupport.Styleable
    protected Color checkmarkColor = UIManager.getColor("CheckBoxMenuItem.icon.checkmarkColor");
    @FlatStylingSupport.Styleable
    protected Color disabledCheckmarkColor = UIManager.getColor("CheckBoxMenuItem.icon.disabledCheckmarkColor");
    @FlatStylingSupport.Styleable
    protected Color selectionForeground = UIManager.getColor("MenuItem.selectionForeground");

    public FlatCheckBoxMenuItemIcon() {
        super(15, 15, null);
    }

    @Override
    protected void paintIcon(Component c15, Graphics2D g25) {
        boolean selected;
        boolean bl4 = selected = c15 instanceof AbstractButton && ((AbstractButton)c15).isSelected();
        if (selected) {
            g25.setColor(this.getCheckmarkColor(c15));
            this.paintCheckmark(g25);
        }
    }

    protected void paintCheckmark(Graphics2D g25) {
        Path2D.Float path = new Path2D.Float(1, 3);
        path.moveTo(4.5f, 7.5f);
        path.lineTo(6.6f, 10.0f);
        path.lineTo(11.25f, 3.5f);
        g25.setStroke(new BasicStroke(1.9f, 1, 1));
        g25.draw(path);
    }

    protected Color getCheckmarkColor(Component c15) {
        if (c15 instanceof JMenuItem && ((JMenuItem)c15).isArmed() && !this.isUnderlineSelection()) {
            return this.selectionForeground;
        }
        return c15.isEnabled() ? this.checkmarkColor : this.disabledCheckmarkColor;
    }

    protected boolean isUnderlineSelection() {
        return "underline".equals(UIManager.getString("MenuItem.selectionType"));
    }
}

