/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.util;

import java.io.PrintStream;
import java.io.PrintWriter;

public class ExceptionWithContext
extends RuntimeException {
    private StringBuffer context;

    public static ExceptionWithContext withContext(Throwable ex4, String str, Object ... formatArgs) {
        ExceptionWithContext ewc = ex4 instanceof ExceptionWithContext ? (ExceptionWithContext)ex4 : new ExceptionWithContext(ex4);
        ewc.addContext(String.format(str, formatArgs));
        return ewc;
    }

    public ExceptionWithContext(String message2, Object ... formatArgs) {
        this(null, message2, formatArgs);
    }

    public ExceptionWithContext(Throwable cause) {
        this(cause, null, new Object[0]);
    }

    public ExceptionWithContext(Throwable cause, String message2, Object ... formatArgs) {
        super(message2 != null ? ExceptionWithContext.formatMessage(message2, formatArgs) : (cause != null ? cause.getMessage() : null), cause);
        if (cause instanceof ExceptionWithContext) {
            String ctx = ((ExceptionWithContext)cause).context.toString();
            this.context = new StringBuffer(ctx.length() + 200);
            this.context.append(ctx);
        } else {
            this.context = new StringBuffer(200);
        }
    }

    private static String formatMessage(String message2, Object ... formatArgs) {
        if (message2 == null) {
            return null;
        }
        return String.format(message2, formatArgs);
    }

    @Override
    public void printStackTrace(PrintStream out) {
        super.printStackTrace(out);
        out.println(this.context);
    }

    @Override
    public void printStackTrace(PrintWriter out) {
        super.printStackTrace(out);
        out.println(this.context);
    }

    public void addContext(String str) {
        if (str == null) {
            throw new NullPointerException("str == null");
        }
        this.context.append(str);
        if (!str.endsWith("\n")) {
            this.context.append('\n');
        }
    }

    public String getContext() {
        return this.context.toString();
    }

    public void printContext(PrintStream out) {
        out.println(this.getMessage());
        out.print(this.context);
    }

    public void printContext(PrintWriter out) {
        out.println(this.getMessage());
        out.print(this.context);
    }
}

