/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.androidtools;

import com.android.tools.build.bundletool.androidtools.CommandExecutor;
import com.android.tools.build.bundletool.androidtools.DefaultCommandExecutor;
import com.android.tools.build.bundletool.model.utils.OsPlatform;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Optional;
import java.util.logging.Logger;

public interface AdbCommand {
    public static final Duration DEFAULT_TIMEOUT = Duration.ofMinutes(5L);

    public ImmutableList<String> installMultiPackage(ImmutableListMultimap<String, String> var1, boolean var2, boolean var3, Optional<Duration> var4, Optional<String> var5);

    public static AdbCommand create(Path adbPath) {
        return new DefaultAdbCommand(adbPath);
    }

    public static class DefaultAdbCommand
    implements AdbCommand {
        private static final Logger logger = Logger.getLogger(DefaultAdbCommand.class.getName());
        private final Path adbPath;

        public DefaultAdbCommand(Path adbPath) {
            this.adbPath = adbPath;
        }

        @Override
        public ImmutableList<String> installMultiPackage(ImmutableListMultimap<String, String> apkToInstallByPackage, boolean staged, boolean enableRollback, Optional<Duration> timeout, Optional<String> deviceId) {
            return this.installMultiPackage(apkToInstallByPackage, staged, enableRollback, timeout, deviceId, new DefaultCommandExecutor());
        }

        @VisibleForTesting
        ImmutableList<String> installMultiPackage(ImmutableListMultimap<String, String> apkToInstallByPackage, boolean staged, boolean enableRollback, Optional<Duration> timeout, Optional<String> deviceId, CommandExecutor commandExecutor) {
            ImmutableCollection.Builder commandBuilder = ImmutableList.builder().add(this.adbPath.toString());
            deviceId.ifPresent(arg_0 -> DefaultAdbCommand.lambda$installMultiPackage$0((ImmutableList.Builder)commandBuilder, arg_0));
            ((ImmutableList.Builder)commandBuilder).add("install-multi-package");
            if (staged) {
                ((ImmutableList.Builder)commandBuilder).add("--staged");
            }
            if (enableRollback) {
                ((ImmutableList.Builder)commandBuilder).add("--enable-rollback");
            }
            if (timeout.isPresent()) {
                ((ImmutableList.Builder)((ImmutableList.Builder)commandBuilder).add("--staged-ready-timeout")).add(String.format("%d", timeout.get().toMillis()));
            }
            String splitCharacter = OsPlatform.getCurrentPlatform() == OsPlatform.WINDOWS ? ";" : ":";
            apkToInstallByPackage.keySet().forEach(arg_0 -> DefaultAdbCommand.lambda$installMultiPackage$1((ImmutableList.Builder)commandBuilder, splitCharacter, apkToInstallByPackage, arg_0));
            logger.info(String.format("Executing: %s", String.join((CharSequence)" ", ((ImmutableList.Builder)commandBuilder).build())));
            return commandExecutor.executeAndCapture((ImmutableList<String>)((ImmutableList.Builder)commandBuilder).build(), CommandExecutor.CommandOptions.builder().setTimeout(DEFAULT_TIMEOUT).build());
        }

        private static /* synthetic */ void lambda$installMultiPackage$1(ImmutableList.Builder commandBuilder, String splitCharacter, ImmutableListMultimap apkToInstallByPackage, String packageName) {
            commandBuilder.add(String.join((CharSequence)splitCharacter, apkToInstallByPackage.get(packageName)));
        }

        private static /* synthetic */ void lambda$installMultiPackage$0(ImmutableList.Builder commandBuilder, String id5) {
            commandBuilder.add(new String[]{"-s", id5});
        }
    }
}

