/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.code;

import com.android.dx.dex.code.CstInsn;
import com.android.dx.dex.code.DalvInsn;
import com.android.dx.dex.code.TargetInsn;
import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.code.RegisterSpecList;
import com.android.dx.rop.cst.CstInteger;
import com.android.dx.rop.cst.CstKnownNull;
import com.android.dx.rop.cst.CstLiteral64;
import com.android.dx.rop.cst.CstLiteralBits;
import com.android.dx.util.AnnotatedOutput;
import com.android.dx.util.Hex;
import java.util.BitSet;

public abstract class InsnFormat {
    public static final boolean ALLOW_EXTENDED_OPCODES = true;

    public final String listingString(DalvInsn insn, boolean noteIndices) {
        String op4 = insn.getOpcode().getName();
        String arg = this.insnArgString(insn);
        String comment = this.insnCommentString(insn, noteIndices);
        StringBuilder sb5 = new StringBuilder(100);
        sb5.append(op4);
        if (arg.length() != 0) {
            sb5.append(' ');
            sb5.append(arg);
        }
        if (comment.length() != 0) {
            sb5.append(" // ");
            sb5.append(comment);
        }
        return sb5.toString();
    }

    public abstract String insnArgString(DalvInsn var1);

    public abstract String insnCommentString(DalvInsn var1, boolean var2);

    public abstract int codeSize();

    public abstract boolean isCompatible(DalvInsn var1);

    public BitSet compatibleRegs(DalvInsn insn) {
        return new BitSet();
    }

    public boolean branchFits(TargetInsn insn) {
        return false;
    }

    public abstract void writeTo(AnnotatedOutput var1, DalvInsn var2);

    protected static String regListString(RegisterSpecList list2) {
        int sz4 = list2.size();
        StringBuilder sb5 = new StringBuilder(sz4 * 5 + 2);
        sb5.append('{');
        for (int i15 = 0; i15 < sz4; ++i15) {
            if (i15 != 0) {
                sb5.append(", ");
            }
            sb5.append(list2.get(i15).regString());
        }
        sb5.append('}');
        return sb5.toString();
    }

    protected static String regRangeString(RegisterSpecList list2) {
        int size = list2.size();
        StringBuilder sb5 = new StringBuilder(30);
        sb5.append("{");
        switch (size) {
            case 0: {
                break;
            }
            case 1: {
                sb5.append(list2.get(0).regString());
                break;
            }
            default: {
                RegisterSpec lastReg = list2.get(size - 1);
                if (lastReg.getCategory() == 2) {
                    lastReg = lastReg.withOffset(1);
                }
                sb5.append(list2.get(0).regString());
                sb5.append("..");
                sb5.append(lastReg.regString());
            }
        }
        sb5.append("}");
        return sb5.toString();
    }

    protected static String literalBitsString(CstLiteralBits value) {
        StringBuilder sb5 = new StringBuilder(100);
        sb5.append('#');
        if (value instanceof CstKnownNull) {
            sb5.append("null");
        } else {
            sb5.append(value.typeName());
            sb5.append(' ');
            sb5.append(value.toHuman());
        }
        return sb5.toString();
    }

    protected static String literalBitsComment(CstLiteralBits value, int width) {
        StringBuilder sb5 = new StringBuilder(20);
        sb5.append("#");
        long bits = value instanceof CstLiteral64 ? ((CstLiteral64)value).getLongBits() : (long)value.getIntBits();
        switch (width) {
            case 4: {
                sb5.append(Hex.uNibble((int)bits));
                break;
            }
            case 8: {
                sb5.append(Hex.u1((int)bits));
                break;
            }
            case 16: {
                sb5.append(Hex.u2((int)bits));
                break;
            }
            case 32: {
                sb5.append(Hex.u4((int)bits));
                break;
            }
            case 64: {
                sb5.append(Hex.u8(bits));
                break;
            }
            default: {
                throw new RuntimeException("shouldn't happen");
            }
        }
        return sb5.toString();
    }

    protected static String branchString(DalvInsn insn) {
        TargetInsn ti4 = (TargetInsn)insn;
        int address = ti4.getTargetAddress();
        return address == (char)address ? Hex.u2(address) : Hex.u4(address);
    }

    protected static String branchComment(DalvInsn insn) {
        TargetInsn ti4 = (TargetInsn)insn;
        int offset = ti4.getTargetOffset();
        return offset == (short)offset ? Hex.s2(offset) : Hex.s4(offset);
    }

    protected static boolean signedFitsInNibble(int value) {
        return value >= -8 && value <= 7;
    }

    protected static boolean unsignedFitsInNibble(int value) {
        return value == (value & 0xF);
    }

    protected static boolean signedFitsInByte(int value) {
        return (byte)value == value;
    }

    protected static boolean unsignedFitsInByte(int value) {
        return value == (value & 0xFF);
    }

    protected static boolean signedFitsInShort(int value) {
        return (short)value == value;
    }

    protected static boolean unsignedFitsInShort(int value) {
        return value == (value & 0xFFFF);
    }

    protected static boolean isRegListSequential(RegisterSpecList list2) {
        int first;
        int sz4 = list2.size();
        if (sz4 < 2) {
            return true;
        }
        int next = first = list2.get(0).getReg();
        for (int i15 = 0; i15 < sz4; ++i15) {
            RegisterSpec one = list2.get(i15);
            if (one.getReg() != next) {
                return false;
            }
            next += one.getCategory();
        }
        return true;
    }

    protected static int argIndex(DalvInsn insn) {
        int arg = ((CstInteger)((CstInsn)insn).getConstant()).getValue();
        if (arg < 0) {
            throw new IllegalArgumentException("bogus insn");
        }
        return arg;
    }

    protected static short opcodeUnit(DalvInsn insn, int arg) {
        if ((arg & 0xFF) != arg) {
            throw new IllegalArgumentException("arg out of range 0..255");
        }
        int opcode = insn.getOpcode().getOpcode();
        if ((opcode & 0xFF) != opcode) {
            throw new IllegalArgumentException("opcode out of range 0..255");
        }
        return (short)(opcode | arg << 8);
    }

    protected static short opcodeUnit(DalvInsn insn) {
        int opcode = insn.getOpcode().getOpcode();
        if (opcode < 256 || opcode > 65535) {
            throw new IllegalArgumentException("opcode out of range 0..65535");
        }
        return (short)opcode;
    }

    protected static short codeUnit(int low, int high) {
        if ((low & 0xFF) != low) {
            throw new IllegalArgumentException("low out of range 0..255");
        }
        if ((high & 0xFF) != high) {
            throw new IllegalArgumentException("high out of range 0..255");
        }
        return (short)(low | high << 8);
    }

    protected static short codeUnit(int n05, int n15, int n25, int n35) {
        if ((n05 & 0xF) != n05) {
            throw new IllegalArgumentException("n0 out of range 0..15");
        }
        if ((n15 & 0xF) != n15) {
            throw new IllegalArgumentException("n1 out of range 0..15");
        }
        if ((n25 & 0xF) != n25) {
            throw new IllegalArgumentException("n2 out of range 0..15");
        }
        if ((n35 & 0xF) != n35) {
            throw new IllegalArgumentException("n3 out of range 0..15");
        }
        return (short)(n05 | n15 << 4 | n25 << 8 | n35 << 12);
    }

    protected static int makeByte(int low, int high) {
        if ((low & 0xF) != low) {
            throw new IllegalArgumentException("low out of range 0..15");
        }
        if ((high & 0xF) != high) {
            throw new IllegalArgumentException("high out of range 0..15");
        }
        return low | high << 4;
    }

    protected static void write(AnnotatedOutput out, short c05) {
        out.writeShort(c05);
    }

    protected static void write(AnnotatedOutput out, short c05, short c15) {
        out.writeShort(c05);
        out.writeShort(c15);
    }

    protected static void write(AnnotatedOutput out, short c05, short c15, short c25) {
        out.writeShort(c05);
        out.writeShort(c15);
        out.writeShort(c25);
    }

    protected static void write(AnnotatedOutput out, short c05, short c15, short c25, short c35) {
        out.writeShort(c05);
        out.writeShort(c15);
        out.writeShort(c25);
        out.writeShort(c35);
    }

    protected static void write(AnnotatedOutput out, short c05, short c15, short c25, short c35, short c45) {
        out.writeShort(c05);
        out.writeShort(c15);
        out.writeShort(c25);
        out.writeShort(c35);
        out.writeShort(c45);
    }

    protected static void write(AnnotatedOutput out, short c05, int c1c2) {
        InsnFormat.write(out, c05, (short)c1c2, (short)(c1c2 >> 16));
    }

    protected static void write(AnnotatedOutput out, short c05, int c1c2, short c35) {
        InsnFormat.write(out, c05, (short)c1c2, (short)(c1c2 >> 16), c35);
    }

    protected static void write(AnnotatedOutput out, short c05, int c1c2, short c35, short c45) {
        InsnFormat.write(out, c05, (short)c1c2, (short)(c1c2 >> 16), c35, c45);
    }

    protected static void write(AnnotatedOutput out, short c05, long c1c2c3c4) {
        InsnFormat.write(out, c05, (short)c1c2c3c4, (short)(c1c2c3c4 >> 16), (short)(c1c2c3c4 >> 32), (short)(c1c2c3c4 >> 48));
    }
}

