/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig;

import com.android.apksig.ApkSignerEngine;
import com.android.apksig.KeyConfig;
import com.android.apksig.SigningCertificateLineage;
import com.android.apksig.apk.ApkFormatException;
import com.android.apksig.apk.ApkUtils;
import com.android.apksig.internal.apk.ApkSigningBlockUtils;
import com.android.apksig.internal.apk.ContentDigestAlgorithm;
import com.android.apksig.internal.apk.SignatureAlgorithm;
import com.android.apksig.internal.apk.stamp.V2SourceStampSigner;
import com.android.apksig.internal.apk.v1.DigestAlgorithm;
import com.android.apksig.internal.apk.v1.V1SchemeSigner;
import com.android.apksig.internal.apk.v1.V1SchemeVerifier;
import com.android.apksig.internal.apk.v2.V2SchemeSigner;
import com.android.apksig.internal.apk.v3.V3SchemeSigner;
import com.android.apksig.internal.apk.v4.V4SchemeSigner;
import com.android.apksig.internal.apk.v4.V4Signature;
import com.android.apksig.internal.jar.ManifestParser;
import com.android.apksig.internal.util.Pair;
import com.android.apksig.internal.util.TeeDataSink;
import com.android.apksig.util.DataSink;
import com.android.apksig.util.DataSinks;
import com.android.apksig.util.DataSource;
import com.android.apksig.util.RunnablesExecutor;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultApkSignerEngine
implements ApkSignerEngine {
    private final boolean mV1SigningEnabled;
    private final boolean mV2SigningEnabled;
    private final boolean mV3SigningEnabled;
    private final boolean mVerityEnabled;
    private final boolean mDebuggableApkPermitted;
    private final boolean mOtherSignersSignaturesPreserved;
    private final String mCreatedBy;
    private final List<SignerConfig> mSignerConfigs;
    private final List<SignerConfig> mTargetedSignerConfigs;
    private final SignerConfig mSourceStampSignerConfig;
    private final SigningCertificateLineage mSourceStampSigningCertificateLineage;
    private final boolean mSourceStampTimestampEnabled;
    private final int mMinSdkVersion;
    private final SigningCertificateLineage mSigningCertificateLineage;
    private List<byte[]> mPreservedV2Signers = Collections.emptyList();
    private List<Pair<byte[], Integer>> mPreservedSignatureBlocks = Collections.emptyList();
    private List<V1SchemeSigner.SignerConfig> mV1SignerConfigs = Collections.emptyList();
    private DigestAlgorithm mV1ContentDigestAlgorithm;
    private boolean mClosed;
    private boolean mV1SignaturePending;
    private Set<String> mSignatureExpectedOutputJarEntryNames = Collections.emptySet();
    private final Map<String, GetJarEntryDataDigestRequest> mOutputJarEntryDigestRequests = new HashMap<String, GetJarEntryDataDigestRequest>();
    private final Map<String, byte[]> mOutputJarEntryDigests = new HashMap<String, byte[]>();
    private final Map<String, byte[]> mEmittedSignatureJarEntryData = new HashMap<String, byte[]>();
    private final Map<String, GetJarEntryDataRequest> mOutputSignatureJarEntryDataRequests = new HashMap<String, GetJarEntryDataRequest>();
    private GetJarEntryDataRequest mInputJarManifestEntryDataRequest;
    private GetJarEntryDataRequest mOutputAndroidManifestEntryDataRequest;
    private Boolean mDebuggable;
    private OutputJarSignatureRequestImpl mAddV1SignatureRequest;
    private boolean mV2SignaturePending;
    private boolean mV3SignaturePending;
    private OutputApkSigningBlockRequestImpl mAddSigningBlockRequest;
    private RunnablesExecutor mExecutor = RunnablesExecutor.MULTI_THREADED;
    private static final Set<Integer> DISCARDED_SIGNATURE_BLOCK_IDS = new HashSet<Integer>(3);

    private DefaultApkSignerEngine(List<SignerConfig> signerConfigs, List<SignerConfig> targetedSignerConfigs, SignerConfig sourceStampSignerConfig, SigningCertificateLineage sourceStampSigningCertificateLineage, boolean sourceStampTimestampEnabled, int minSdkVersion, boolean v1SigningEnabled, boolean v2SigningEnabled, boolean v3SigningEnabled, boolean verityEnabled, boolean debuggableApkPermitted, boolean otherSignersSignaturesPreserved, String createdBy, SigningCertificateLineage signingCertificateLineage) throws InvalidKeyException {
        if (signerConfigs.isEmpty() && targetedSignerConfigs.isEmpty()) {
            throw new IllegalArgumentException("At least one signer config must be provided");
        }
        this.mV1SigningEnabled = v1SigningEnabled;
        this.mV2SigningEnabled = v2SigningEnabled;
        this.mV3SigningEnabled = v3SigningEnabled;
        this.mVerityEnabled = verityEnabled;
        this.mV1SignaturePending = v1SigningEnabled;
        this.mV2SignaturePending = v2SigningEnabled;
        this.mV3SignaturePending = v3SigningEnabled;
        this.mDebuggableApkPermitted = debuggableApkPermitted;
        this.mOtherSignersSignaturesPreserved = otherSignersSignaturesPreserved;
        this.mCreatedBy = createdBy;
        this.mSignerConfigs = signerConfigs;
        this.mTargetedSignerConfigs = targetedSignerConfigs;
        this.mSourceStampSignerConfig = sourceStampSignerConfig;
        this.mSourceStampSigningCertificateLineage = sourceStampSigningCertificateLineage;
        this.mSourceStampTimestampEnabled = sourceStampTimestampEnabled;
        this.mMinSdkVersion = minSdkVersion;
        this.mSigningCertificateLineage = signingCertificateLineage;
        if (v1SigningEnabled) {
            if (v3SigningEnabled) {
                SigningCertificateLineage subLineage;
                SignerConfig oldestConfig;
                SignerConfig signerConfig = oldestConfig = !signerConfigs.isEmpty() ? signerConfigs.get(0) : targetedSignerConfigs.get(0);
                if (signingCertificateLineage != null && (subLineage = signingCertificateLineage.getSubLineage((X509Certificate)oldestConfig.mCertificates.get(0))).size() != 1) {
                    throw new IllegalArgumentException("v1 signing enabled but the oldest signer in the SigningCertificateLineage is missing.  Please provide the oldest signer to enable v1 signing");
                }
                this.createV1SignerConfigs(Collections.singletonList(oldestConfig), minSdkVersion);
            } else {
                this.createV1SignerConfigs(signerConfigs, minSdkVersion);
            }
        }
    }

    private void createV1SignerConfigs(List<SignerConfig> signerConfigs, int minSdkVersion) throws InvalidKeyException {
        this.mV1SignerConfigs = new ArrayList<V1SchemeSigner.SignerConfig>(signerConfigs.size());
        HashMap<String, Integer> v1SignerNameToSignerIndex = new HashMap<String, Integer>(signerConfigs.size());
        DigestAlgorithm v1ContentDigestAlgorithm = null;
        for (int i15 = 0; i15 < signerConfigs.size(); ++i15) {
            SignerConfig signerConfig = signerConfigs.get(i15);
            List<X509Certificate> certificates = signerConfig.getCertificates();
            PublicKey publicKey = certificates.get(0).getPublicKey();
            String v1SignerName = V1SchemeSigner.getSafeSignerName(signerConfig.getName());
            Integer indexOfOtherSignerWithSameName = v1SignerNameToSignerIndex.put(v1SignerName, i15);
            if (indexOfOtherSignerWithSameName != null) {
                throw new IllegalArgumentException("Signers #" + (indexOfOtherSignerWithSameName + 1) + " and #" + (i15 + 1) + " have the same name: " + v1SignerName + ". v1 signer names must be unique");
            }
            DigestAlgorithm v1SignatureDigestAlgorithm = V1SchemeSigner.getSuggestedSignatureDigestAlgorithm(publicKey, minSdkVersion);
            V1SchemeSigner.SignerConfig v1SignerConfig = new V1SchemeSigner.SignerConfig();
            v1SignerConfig.name = v1SignerName;
            v1SignerConfig.keyConfig = signerConfig.getKeyConfig();
            v1SignerConfig.certificates = certificates;
            v1SignerConfig.signatureDigestAlgorithm = v1SignatureDigestAlgorithm;
            v1SignerConfig.deterministicDsaSigning = signerConfig.getDeterministicDsaSigning();
            if (v1ContentDigestAlgorithm == null) {
                v1ContentDigestAlgorithm = v1SignatureDigestAlgorithm;
            } else if (DigestAlgorithm.BY_STRENGTH_COMPARATOR.compare(v1SignatureDigestAlgorithm, v1ContentDigestAlgorithm) > 0) {
                v1ContentDigestAlgorithm = v1SignatureDigestAlgorithm;
            }
            this.mV1SignerConfigs.add(v1SignerConfig);
        }
        this.mV1ContentDigestAlgorithm = v1ContentDigestAlgorithm;
        this.mSignatureExpectedOutputJarEntryNames = V1SchemeSigner.getOutputEntryNames(this.mV1SignerConfigs);
    }

    private List<ApkSigningBlockUtils.SignerConfig> createV2SignerConfigs(boolean apkSigningBlockPaddingSupported) throws InvalidKeyException {
        if (this.mV3SigningEnabled) {
            SigningCertificateLineage subLineage;
            SignerConfig oldestConfig;
            ArrayList<ApkSigningBlockUtils.SignerConfig> signerConfig = new ArrayList<ApkSigningBlockUtils.SignerConfig>();
            SignerConfig signerConfig2 = oldestConfig = !this.mSignerConfigs.isEmpty() ? this.mSignerConfigs.get(0) : this.mTargetedSignerConfigs.get(0);
            if (this.mSigningCertificateLineage != null && (subLineage = this.mSigningCertificateLineage.getSubLineage((X509Certificate)oldestConfig.mCertificates.get(0))).size() != 1) {
                throw new IllegalArgumentException("v2 signing enabled but the oldest signer in the SigningCertificateLineage is missing.  Please provide the oldest signer to enable v2 signing.");
            }
            signerConfig.add(this.createSigningBlockSignerConfig(oldestConfig, apkSigningBlockPaddingSupported, 2));
            return signerConfig;
        }
        return this.createSigningBlockSignerConfigs(apkSigningBlockPaddingSupported, 2);
    }

    private List<ApkSigningBlockUtils.SignerConfig> processV3Configs(List<ApkSigningBlockUtils.SignerConfig> rawConfigs) throws InvalidKeyException {
        int minRequiredV3SdkVersion = Math.max(28, this.mMinSdkVersion);
        if (this.mSignerConfigs.isEmpty() && this.mTargetedSignerConfigs.get(0).getMinSdkVersion() > minRequiredV3SdkVersion) {
            throw new IllegalArgumentException("The provided targeted signer configs do not cover the SDK range for V3 support; either provide the original signer or ensure a signer targets SDK version " + minRequiredV3SdkVersion);
        }
        ArrayList<ApkSigningBlockUtils.SignerConfig> processedConfigs = new ArrayList<ApkSigningBlockUtils.SignerConfig>();
        int currentMinSdk = Integer.MAX_VALUE;
        for (int i15 = rawConfigs.size() - 1; i15 >= 0; --i15) {
            ApkSigningBlockUtils.SignerConfig config = rawConfigs.get(i15);
            if (config.signatureAlgorithms == null) {
                String keyAlgorithm = config.certificates.get(0).getPublicKey().getAlgorithm();
                throw new InvalidKeyException("Unsupported key algorithm " + keyAlgorithm + " is not supported for APK Signature Scheme v3 signing");
            }
            if (i15 == rawConfigs.size() - 1) {
                config.maxSdkVersion = Integer.MAX_VALUE;
            } else {
                ApkSigningBlockUtils.SignerConfig prevSigner = (ApkSigningBlockUtils.SignerConfig)processedConfigs.get(processedConfigs.size() - 1);
                config.maxSdkVersion = prevSigner.signerTargetsDevRelease ? prevSigner.minSdkVersion : currentMinSdk - 1;
            }
            if (config.minSdkVersion == 34) {
                config.minSdkVersion = 33;
                config.signerTargetsDevRelease = true;
            } else if (config.minSdkVersion == 0) {
                config.minSdkVersion = this.getMinSdkFromV3SignatureAlgorithms(config.signatureAlgorithms);
            }
            X509Certificate signerCert = config.certificates.get(0);
            if (config.signingCertificateLineage != null && !config.signingCertificateLineage.isCertificateLatestInLineage(signerCert)) {
                config.signingCertificateLineage = config.signingCertificateLineage.getSubLineage(signerCert);
            }
            processedConfigs.add(config);
            currentMinSdk = config.minSdkVersion;
            if (config.signerTargetsDevRelease ? currentMinSdk < minRequiredV3SdkVersion : currentMinSdk <= minRequiredV3SdkVersion) break;
        }
        if (currentMinSdk > 28 && currentMinSdk > this.mMinSdkVersion) {
            throw new InvalidKeyException("Provided key algorithms not supported on all desired Android SDK versions");
        }
        return processedConfigs;
    }

    private List<ApkSigningBlockUtils.SignerConfig> createV3SignerConfigs(boolean apkSigningBlockPaddingSupported) throws InvalidKeyException {
        return this.processV3Configs(this.createSigningBlockSignerConfigs(apkSigningBlockPaddingSupported, 3));
    }

    private List<ApkSigningBlockUtils.SignerConfig> processV31SignerConfigs(List<ApkSigningBlockUtils.SignerConfig> v3SignerConfigs) {
        if (v3SignerConfigs.size() == 1) {
            return null;
        }
        int signerMinSdkVersion = v3SignerConfigs.stream().mapToInt(signer -> signer.minSdkVersion).min().orElse(28);
        ArrayList<ApkSigningBlockUtils.SignerConfig> v31SignerConfigs = new ArrayList<ApkSigningBlockUtils.SignerConfig>();
        Iterator<ApkSigningBlockUtils.SignerConfig> v3SignerIterator = v3SignerConfigs.iterator();
        while (v3SignerIterator.hasNext()) {
            ApkSigningBlockUtils.SignerConfig signerConfig = v3SignerIterator.next();
            if (signerConfig.minSdkVersion < 33 || signerConfig.minSdkVersion <= signerMinSdkVersion && (signerConfig.minSdkVersion < signerMinSdkVersion || !signerConfig.signerTargetsDevRelease)) continue;
            v31SignerConfigs.add(signerConfig);
            v3SignerIterator.remove();
        }
        return v31SignerConfigs;
    }

    private V4SchemeSigner.SignerConfig createV4SignerConfig() throws InvalidKeyException {
        List<ApkSigningBlockUtils.SignerConfig> v4Configs = this.createSigningBlockSignerConfigs(true, 4);
        if (v4Configs.size() != 1) {
            v4Configs = this.processV3Configs(v4Configs);
        }
        List<ApkSigningBlockUtils.SignerConfig> v41configs = this.processV31SignerConfigs(v4Configs);
        return new V4SchemeSigner.SignerConfig(v4Configs, v41configs);
    }

    private ApkSigningBlockUtils.SignerConfig createSourceStampSignerConfig() throws InvalidKeyException {
        ApkSigningBlockUtils.SignerConfig config = this.createSigningBlockSignerConfig(this.mSourceStampSignerConfig, false, 0);
        if (this.mSourceStampSigningCertificateLineage != null) {
            config.signingCertificateLineage = this.mSourceStampSigningCertificateLineage.getSubLineage(config.certificates.get(0));
        }
        return config;
    }

    private int getMinSdkFromV3SignatureAlgorithms(List<SignatureAlgorithm> algorithms) {
        int min = Integer.MAX_VALUE;
        for (SignatureAlgorithm algorithm : algorithms) {
            int current = algorithm.getMinSdkVersion();
            if (current >= min) continue;
            if (current <= this.mMinSdkVersion || current <= 28) {
                return current;
            }
            min = current;
        }
        return min;
    }

    private List<ApkSigningBlockUtils.SignerConfig> createSigningBlockSignerConfigs(boolean apkSigningBlockPaddingSupported, int schemeId) throws InvalidKeyException {
        SignerConfig signerConfig;
        int i15;
        ArrayList<ApkSigningBlockUtils.SignerConfig> signerConfigs = new ArrayList<ApkSigningBlockUtils.SignerConfig>(this.mSignerConfigs.size() + this.mTargetedSignerConfigs.size());
        for (i15 = 0; i15 < this.mSignerConfigs.size(); ++i15) {
            signerConfig = this.mSignerConfigs.get(i15);
            signerConfigs.add(this.createSigningBlockSignerConfig(signerConfig, apkSigningBlockPaddingSupported, schemeId));
        }
        if (schemeId >= 3) {
            for (i15 = 0; i15 < this.mTargetedSignerConfigs.size(); ++i15) {
                signerConfig = this.mTargetedSignerConfigs.get(i15);
                signerConfigs.add(this.createSigningBlockSignerConfig(signerConfig, apkSigningBlockPaddingSupported, schemeId));
            }
        }
        return signerConfigs;
    }

    private ApkSigningBlockUtils.SignerConfig createSigningBlockSignerConfig(SignerConfig signerConfig, boolean apkSigningBlockPaddingSupported, int schemeId) throws InvalidKeyException {
        List<X509Certificate> certificates = signerConfig.getCertificates();
        PublicKey publicKey = certificates.get(0).getPublicKey();
        ApkSigningBlockUtils.SignerConfig newSignerConfig = new ApkSigningBlockUtils.SignerConfig();
        newSignerConfig.keyConfig = signerConfig.getKeyConfig();
        newSignerConfig.certificates = certificates;
        newSignerConfig.minSdkVersion = signerConfig.getMinSdkVersion();
        newSignerConfig.signerTargetsDevRelease = signerConfig.getSignerTargetsDevRelease();
        newSignerConfig.signingCertificateLineage = signerConfig.getSigningCertificateLineage();
        switch (schemeId) {
            case 2: {
                newSignerConfig.signatureAlgorithms = V2SchemeSigner.getSuggestedSignatureAlgorithms(publicKey, this.mMinSdkVersion, apkSigningBlockPaddingSupported && this.mVerityEnabled, signerConfig.getDeterministicDsaSigning());
                break;
            }
            case 3: {
                try {
                    newSignerConfig.signatureAlgorithms = V3SchemeSigner.getSuggestedSignatureAlgorithms(publicKey, this.mMinSdkVersion, apkSigningBlockPaddingSupported && this.mVerityEnabled, signerConfig.getDeterministicDsaSigning());
                }
                catch (InvalidKeyException e15) {
                    newSignerConfig.signatureAlgorithms = null;
                }
                break;
            }
            case 4: {
                try {
                    newSignerConfig.signatureAlgorithms = V4SchemeSigner.getSuggestedSignatureAlgorithms(publicKey, this.mMinSdkVersion, apkSigningBlockPaddingSupported, signerConfig.getDeterministicDsaSigning());
                }
                catch (InvalidKeyException e16) {
                    newSignerConfig.signatureAlgorithms = null;
                }
                break;
            }
            case 0: {
                newSignerConfig.signatureAlgorithms = Collections.singletonList(SignatureAlgorithm.RSA_PKCS1_V1_5_WITH_SHA256);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown APK Signature Scheme ID requested");
            }
        }
        return newSignerConfig;
    }

    private boolean isDebuggable(String entryName) {
        return this.mDebuggableApkPermitted || !"AndroidManifest.xml".equals(entryName);
    }

    @Override
    public Set<String> initWith(byte[] manifestBytes, Set<String> entryNames) {
        V1SchemeVerifier.Result result = new V1SchemeVerifier.Result();
        Pair<ManifestParser.Section, Map<String, ManifestParser.Section>> sections = V1SchemeVerifier.parseManifest(manifestBytes, entryNames, result);
        String alg = V1SchemeSigner.getJcaMessageDigestAlgorithm(this.mV1ContentDigestAlgorithm);
        for (Map.Entry<String, ManifestParser.Section> entry : sections.getSecond().entrySet()) {
            String entryName = entry.getKey();
            if (!V1SchemeSigner.isJarEntryDigestNeededInManifest(entry.getKey()) || !this.isDebuggable(entryName)) continue;
            V1SchemeVerifier.NamedDigest extractedDigest = null;
            Collection<V1SchemeVerifier.NamedDigest> digestsToVerify = V1SchemeVerifier.getDigestsToVerify(entry.getValue(), "-Digest", this.mMinSdkVersion, Integer.MAX_VALUE);
            for (V1SchemeVerifier.NamedDigest digestToVerify : digestsToVerify) {
                if (!digestToVerify.jcaDigestAlgorithm.equals(alg)) continue;
                extractedDigest = digestToVerify;
                break;
            }
            if (extractedDigest == null) continue;
            this.mOutputJarEntryDigests.put(entryName, extractedDigest.digest);
        }
        return this.mOutputJarEntryDigests.keySet();
    }

    @Override
    public void setExecutor(RunnablesExecutor executor) {
        this.mExecutor = executor;
    }

    @Override
    public void inputApkSigningBlock(DataSource apkSigningBlock) {
        this.checkNotClosed();
        if (apkSigningBlock == null || apkSigningBlock.size() == 0L) {
            return;
        }
        if (this.mOtherSignersSignaturesPreserved) {
            boolean schemeSignatureBlockPreserved = false;
            this.mPreservedSignatureBlocks = new ArrayList<Pair<byte[], Integer>>();
            try {
                List<Pair<byte[], Integer>> signatureBlocks = ApkSigningBlockUtils.getApkSignatureBlocks(apkSigningBlock);
                for (Pair<byte[], Integer> signatureBlock : signatureBlocks) {
                    if (signatureBlock.getSecond() == 1896449818) {
                        if (this.mV2SigningEnabled) {
                            List<Pair<List<X509Certificate>, byte[]>> v2Signers = ApkSigningBlockUtils.getApkSignatureBlockSigners(signatureBlock.getFirst());
                            this.mPreservedV2Signers = new ArrayList<byte[]>(v2Signers.size());
                            for (Pair<List<X509Certificate>, byte[]> v2Signer : v2Signers) {
                                if (this.isConfiguredWithSigner(v2Signer.getFirst())) continue;
                                this.mPreservedV2Signers.add(v2Signer.getSecond());
                                schemeSignatureBlockPreserved = true;
                            }
                            continue;
                        }
                        this.mPreservedSignatureBlocks.add(signatureBlock);
                        schemeSignatureBlockPreserved = true;
                        continue;
                    }
                    if (signatureBlock.getSecond() == -262969152) {
                        if (!this.mV3SigningEnabled) {
                            throw new IllegalStateException("Preserving an existing V3 signature is not supported");
                        }
                        List<Pair<List<X509Certificate>, byte[]>> v3Signers = ApkSigningBlockUtils.getApkSignatureBlockSigners(signatureBlock.getFirst());
                        if (v3Signers.size() > 1) {
                            throw new IllegalArgumentException("The provided APK signing block contains " + v3Signers.size() + " V3 signers; the V3 signature scheme only supports one signer");
                        }
                        if (v3Signers.size() != 1 || this.isConfiguredWithSigner(v3Signers.get(0).getFirst())) continue;
                        throw new IllegalStateException("The V3 signature scheme only supports one signer; a request was made to preserve the existing V3 signature, but the engine is configured to sign with a different signer");
                    }
                    if (DISCARDED_SIGNATURE_BLOCK_IDS.contains(signatureBlock.getSecond())) continue;
                    this.mPreservedSignatureBlocks.add(signatureBlock);
                }
            }
            catch (ApkFormatException | IOException | CertificateException e15) {
                throw new IllegalArgumentException("Unable to parse the provided signing block", e15);
            }
            if (this.mV3SigningEnabled && schemeSignatureBlockPreserved) {
                throw new IllegalStateException("Signature scheme V3+ only supports a single signer and cannot be appended to the existing signature scheme blocks");
            }
            return;
        }
    }

    private boolean isConfiguredWithSigner(List<X509Certificate> signerCerts) {
        for (SignerConfig signerConfig : this.mSignerConfigs) {
            if (!signerCerts.containsAll(signerConfig.getCertificates())) continue;
            return true;
        }
        return false;
    }

    @Override
    public ApkSignerEngine.InputJarEntryInstructions inputJarEntry(String entryName) {
        this.checkNotClosed();
        ApkSignerEngine.InputJarEntryInstructions.OutputPolicy outputPolicy = this.getInputJarEntryOutputPolicy(entryName);
        switch (outputPolicy) {
            case SKIP: {
                return new ApkSignerEngine.InputJarEntryInstructions(ApkSignerEngine.InputJarEntryInstructions.OutputPolicy.SKIP);
            }
            case OUTPUT: {
                return new ApkSignerEngine.InputJarEntryInstructions(ApkSignerEngine.InputJarEntryInstructions.OutputPolicy.OUTPUT);
            }
            case OUTPUT_BY_ENGINE: {
                if ("META-INF/MANIFEST.MF".equals(entryName)) {
                    this.mInputJarManifestEntryDataRequest = new GetJarEntryDataRequest(entryName);
                    return new ApkSignerEngine.InputJarEntryInstructions(ApkSignerEngine.InputJarEntryInstructions.OutputPolicy.OUTPUT_BY_ENGINE, this.mInputJarManifestEntryDataRequest);
                }
                return new ApkSignerEngine.InputJarEntryInstructions(ApkSignerEngine.InputJarEntryInstructions.OutputPolicy.OUTPUT_BY_ENGINE);
            }
        }
        throw new RuntimeException("Unsupported output policy: " + (Object)((Object)outputPolicy));
    }

    @Override
    public ApkSignerEngine.InspectJarEntryRequest outputJarEntry(String entryName) {
        this.checkNotClosed();
        this.invalidateV2Signature();
        if (!this.isDebuggable(entryName)) {
            this.forgetOutputApkDebuggableStatus();
        }
        if (!this.mV1SigningEnabled) {
            if (!this.isDebuggable(entryName)) {
                this.mOutputAndroidManifestEntryDataRequest = new GetJarEntryDataRequest(entryName);
                return this.mOutputAndroidManifestEntryDataRequest;
            }
            return null;
        }
        if (V1SchemeSigner.isJarEntryDigestNeededInManifest(entryName)) {
            this.invalidateV1Signature();
            GetJarEntryDataDigestRequest dataDigestRequest = new GetJarEntryDataDigestRequest(entryName, V1SchemeSigner.getJcaMessageDigestAlgorithm(this.mV1ContentDigestAlgorithm));
            this.mOutputJarEntryDigestRequests.put(entryName, dataDigestRequest);
            this.mOutputJarEntryDigests.remove(entryName);
            if (!this.mDebuggableApkPermitted && "AndroidManifest.xml".equals(entryName)) {
                this.mOutputAndroidManifestEntryDataRequest = new GetJarEntryDataRequest(entryName);
                return new CompoundInspectJarEntryRequest(entryName, new ApkSignerEngine.InspectJarEntryRequest[]{this.mOutputAndroidManifestEntryDataRequest, dataDigestRequest});
            }
            return dataDigestRequest;
        }
        if (this.mSignatureExpectedOutputJarEntryNames.contains(entryName)) {
            GetJarEntryDataRequest dataRequest;
            this.invalidateV1Signature();
            if ("META-INF/MANIFEST.MF".equals(entryName)) {
                this.mInputJarManifestEntryDataRequest = dataRequest = new GetJarEntryDataRequest(entryName);
            } else {
                GetJarEntryDataRequest getJarEntryDataRequest = dataRequest = this.mEmittedSignatureJarEntryData.containsKey(entryName) ? new GetJarEntryDataRequest(entryName) : null;
            }
            if (dataRequest != null) {
                this.mOutputSignatureJarEntryDataRequests.put(entryName, dataRequest);
            }
            return dataRequest;
        }
        return null;
    }

    @Override
    public ApkSignerEngine.InputJarEntryInstructions.OutputPolicy inputJarEntryRemoved(String entryName) {
        this.checkNotClosed();
        return this.getInputJarEntryOutputPolicy(entryName);
    }

    @Override
    public void outputJarEntryRemoved(String entryName) {
        this.checkNotClosed();
        this.invalidateV2Signature();
        if (!this.mV1SigningEnabled) {
            return;
        }
        if (V1SchemeSigner.isJarEntryDigestNeededInManifest(entryName)) {
            this.invalidateV1Signature();
            this.mOutputJarEntryDigests.remove(entryName);
            this.mOutputJarEntryDigestRequests.remove(entryName);
            this.mOutputSignatureJarEntryDataRequests.remove(entryName);
            return;
        }
        if (this.mSignatureExpectedOutputJarEntryNames.contains(entryName)) {
            this.invalidateV1Signature();
            return;
        }
    }

    @Override
    public ApkSignerEngine.OutputJarSignatureRequest outputJarEntries() throws ApkFormatException, InvalidKeyException, SignatureException, NoSuchAlgorithmException {
        List<Pair<String, byte[]>> signatureZipEntries;
        byte[] inputJarManifest;
        this.checkNotClosed();
        if (!this.mV1SignaturePending) {
            return null;
        }
        if (this.mInputJarManifestEntryDataRequest != null && !this.mInputJarManifestEntryDataRequest.isDone()) {
            throw new IllegalStateException("Still waiting to inspect input APK's " + this.mInputJarManifestEntryDataRequest.getEntryName());
        }
        for (GetJarEntryDataDigestRequest digestRequest : this.mOutputJarEntryDigestRequests.values()) {
            String entryName = digestRequest.getEntryName();
            if (!digestRequest.isDone()) {
                throw new IllegalStateException("Still waiting to inspect output APK's " + entryName);
            }
            this.mOutputJarEntryDigests.put(entryName, digestRequest.getDigest());
        }
        if (this.isEligibleForSourceStamp()) {
            MessageDigest messageDigest = MessageDigest.getInstance(V1SchemeSigner.getJcaMessageDigestAlgorithm(this.mV1ContentDigestAlgorithm));
            messageDigest.update(this.generateSourceStampCertificateDigest());
            this.mOutputJarEntryDigests.put("stamp-cert-sha256", messageDigest.digest());
        }
        this.mOutputJarEntryDigestRequests.clear();
        for (GetJarEntryDataRequest dataRequest : this.mOutputSignatureJarEntryDataRequests.values()) {
            if (dataRequest.isDone()) continue;
            throw new IllegalStateException("Still waiting to inspect output APK's " + dataRequest.getEntryName());
        }
        ArrayList<Integer> apkSigningSchemeIds = new ArrayList<Integer>();
        if (this.mV2SigningEnabled) {
            apkSigningSchemeIds.add(2);
        }
        if (this.mV3SigningEnabled) {
            apkSigningSchemeIds.add(3);
        }
        byte[] byArray = inputJarManifest = this.mInputJarManifestEntryDataRequest != null ? this.mInputJarManifestEntryDataRequest.getData() : null;
        if (this.isEligibleForSourceStamp()) {
            inputJarManifest = V1SchemeSigner.generateManifestFile((DigestAlgorithm)this.mV1ContentDigestAlgorithm, this.mOutputJarEntryDigests, (byte[])inputJarManifest).contents;
        }
        this.checkOutputApkNotDebuggableIfDebuggableMustBeRejected();
        if (this.mAddV1SignatureRequest == null || !this.mAddV1SignatureRequest.isDone()) {
            try {
                signatureZipEntries = V1SchemeSigner.sign(this.mV1SignerConfigs, this.mV1ContentDigestAlgorithm, this.mOutputJarEntryDigests, apkSigningSchemeIds, inputJarManifest, this.mCreatedBy);
            }
            catch (CertificateException e15) {
                throw new SignatureException("Failed to generate v1 signature", e15);
            }
        } else {
            V1SchemeSigner.OutputManifestFile newManifest = V1SchemeSigner.generateManifestFile(this.mV1ContentDigestAlgorithm, this.mOutputJarEntryDigests, inputJarManifest);
            byte[] emittedSignatureManifest = this.mEmittedSignatureJarEntryData.get("META-INF/MANIFEST.MF");
            if (!Arrays.equals(newManifest.contents, emittedSignatureManifest)) {
                try {
                    signatureZipEntries = V1SchemeSigner.signManifest(this.mV1SignerConfigs, this.mV1ContentDigestAlgorithm, apkSigningSchemeIds, this.mCreatedBy, newManifest);
                }
                catch (CertificateException e16) {
                    throw new SignatureException("Failed to generate v1 signature", e16);
                }
            } else {
                signatureZipEntries = new ArrayList<Pair<String, byte[]>>();
                for (Map.Entry<String, byte[]> expectedOutputEntry : this.mEmittedSignatureJarEntryData.entrySet()) {
                    String entryName = expectedOutputEntry.getKey();
                    byte[] expectedData = expectedOutputEntry.getValue();
                    GetJarEntryDataRequest actualDataRequest = this.mOutputSignatureJarEntryDataRequests.get(entryName);
                    if (actualDataRequest == null) {
                        signatureZipEntries.add(Pair.of(entryName, expectedData));
                        continue;
                    }
                    byte[] actualData = actualDataRequest.getData();
                    if (Arrays.equals(expectedData, actualData)) continue;
                    signatureZipEntries.add(Pair.of(entryName, expectedData));
                }
                if (signatureZipEntries.isEmpty()) {
                    return null;
                }
            }
        }
        if (signatureZipEntries.isEmpty()) {
            this.mV1SignaturePending = false;
            return null;
        }
        ArrayList<ApkSignerEngine.OutputJarSignatureRequest.JarEntry> sigEntries = new ArrayList<ApkSignerEngine.OutputJarSignatureRequest.JarEntry>(signatureZipEntries.size());
        for (Pair<String, byte[]> entry : signatureZipEntries) {
            String entryName = entry.getFirst();
            byte[] entryData = entry.getSecond();
            sigEntries.add(new ApkSignerEngine.OutputJarSignatureRequest.JarEntry(entryName, entryData));
            this.mEmittedSignatureJarEntryData.put(entryName, entryData);
        }
        this.mAddV1SignatureRequest = new OutputJarSignatureRequestImpl(sigEntries);
        return this.mAddV1SignatureRequest;
    }

    @Override
    @Deprecated
    public ApkSignerEngine.OutputApkSigningBlockRequest outputZipSections(DataSource zipEntries, DataSource zipCentralDirectory, DataSource zipEocd) throws IOException, InvalidKeyException, SignatureException, NoSuchAlgorithmException {
        return this.outputZipSectionsInternal(zipEntries, zipCentralDirectory, zipEocd, false);
    }

    @Override
    public ApkSignerEngine.OutputApkSigningBlockRequest2 outputZipSections2(DataSource zipEntries, DataSource zipCentralDirectory, DataSource zipEocd) throws IOException, InvalidKeyException, SignatureException, NoSuchAlgorithmException {
        return this.outputZipSectionsInternal(zipEntries, zipCentralDirectory, zipEocd, true);
    }

    private OutputApkSigningBlockRequestImpl outputZipSectionsInternal(DataSource zipEntries, DataSource zipCentralDirectory, DataSource zipEocd, boolean apkSigningBlockPaddingSupported) throws IOException, InvalidKeyException, SignatureException, NoSuchAlgorithmException {
        this.checkNotClosed();
        this.checkV1SigningDoneIfEnabled();
        if (!(this.mV2SigningEnabled || this.mV3SigningEnabled || this.isEligibleForSourceStamp())) {
            return null;
        }
        this.checkOutputApkNotDebuggableIfDebuggableMustBeRejected();
        Pair<DataSource, Integer> paddingPair = ApkSigningBlockUtils.generateApkSigningBlockPadding(zipEntries, apkSigningBlockPaddingSupported);
        DataSource beforeCentralDir = paddingPair.getFirst();
        int padSizeBeforeApkSigningBlock = paddingPair.getSecond();
        DataSource eocd = ApkSigningBlockUtils.copyWithModifiedCDOffset(beforeCentralDir, zipEocd);
        ArrayList<Pair<byte[], Integer>> signingSchemeBlocks = new ArrayList<Pair<byte[], Integer>>();
        ApkSigningBlockUtils.SigningSchemeBlockAndDigests v2SigningSchemeBlockAndDigests = null;
        ApkSigningBlockUtils.SigningSchemeBlockAndDigests v3SigningSchemeBlockAndDigests = null;
        if (this.mOtherSignersSignaturesPreserved && this.mPreservedSignatureBlocks != null && !this.mPreservedSignatureBlocks.isEmpty()) {
            signingSchemeBlocks.addAll(this.mPreservedSignatureBlocks);
        }
        if (this.mV2SigningEnabled) {
            this.invalidateV2Signature();
            List<ApkSigningBlockUtils.SignerConfig> v2SignerConfigs = this.createV2SignerConfigs(apkSigningBlockPaddingSupported);
            v2SigningSchemeBlockAndDigests = V2SchemeSigner.generateApkSignatureSchemeV2Block(this.mExecutor, beforeCentralDir, zipCentralDirectory, eocd, v2SignerConfigs, this.mV3SigningEnabled, this.mOtherSignersSignaturesPreserved ? this.mPreservedV2Signers : null);
            signingSchemeBlocks.add(v2SigningSchemeBlockAndDigests.signingSchemeBlock);
        }
        if (this.mV3SigningEnabled) {
            this.invalidateV3Signature();
            List<ApkSigningBlockUtils.SignerConfig> v3SignerConfigs = this.createV3SignerConfigs(apkSigningBlockPaddingSupported);
            List<ApkSigningBlockUtils.SignerConfig> v31SignerConfigs = this.processV31SignerConfigs(v3SignerConfigs);
            if (v31SignerConfigs != null && v31SignerConfigs.size() > 0) {
                ApkSigningBlockUtils.SigningSchemeBlockAndDigests v31SigningSchemeBlockAndDigests = new V3SchemeSigner.Builder(beforeCentralDir, zipCentralDirectory, eocd, v31SignerConfigs).setRunnablesExecutor(this.mExecutor).setBlockId(462663009).build().generateApkSignatureSchemeV3BlockAndDigests();
                signingSchemeBlocks.add(v31SigningSchemeBlockAndDigests.signingSchemeBlock);
            }
            V3SchemeSigner.Builder builder = new V3SchemeSigner.Builder(beforeCentralDir, zipCentralDirectory, eocd, v3SignerConfigs).setRunnablesExecutor(this.mExecutor).setBlockId(-262969152);
            if (v31SignerConfigs != null && !v31SignerConfigs.isEmpty()) {
                int minSdkVersionForV31 = v31SignerConfigs.stream().mapToInt(signer -> signer.minSdkVersion).min().orElse(33);
                builder.setMinSdkVersionForV31(minSdkVersionForV31);
            }
            v3SigningSchemeBlockAndDigests = builder.build().generateApkSignatureSchemeV3BlockAndDigests();
            signingSchemeBlocks.add(v3SigningSchemeBlockAndDigests.signingSchemeBlock);
        }
        if (this.isEligibleForSourceStamp()) {
            ApkSigningBlockUtils.SignerConfig sourceStampSignerConfig = this.createSourceStampSignerConfig();
            HashMap<Integer, Map<ContentDigestAlgorithm, byte[]>> signatureSchemeDigestInfos = new HashMap<Integer, Map<ContentDigestAlgorithm, byte[]>>();
            if (this.mV3SigningEnabled) {
                signatureSchemeDigestInfos.put(3, v3SigningSchemeBlockAndDigests.digestInfo);
            }
            if (this.mV2SigningEnabled) {
                signatureSchemeDigestInfos.put(2, v2SigningSchemeBlockAndDigests.digestInfo);
            }
            if (this.mV1SigningEnabled) {
                HashMap<ContentDigestAlgorithm, byte[]> v1SigningSchemeDigests = new HashMap<ContentDigestAlgorithm, byte[]>();
                try {
                    byte[] inputJarManifest = this.mInputJarManifestEntryDataRequest != null ? this.mInputJarManifestEntryDataRequest.getData() : null;
                    byte[] jarManifest = V1SchemeSigner.generateManifestFile((DigestAlgorithm)this.mV1ContentDigestAlgorithm, this.mOutputJarEntryDigests, (byte[])inputJarManifest).contents;
                    v1SigningSchemeDigests.put(ContentDigestAlgorithm.SHA256, ApkUtils.computeSha256DigestBytes(jarManifest));
                }
                catch (ApkFormatException e15) {
                    throw new RuntimeException("Failed to generate manifest file", e15);
                }
                signatureSchemeDigestInfos.put(1, v1SigningSchemeDigests);
            }
            V2SourceStampSigner v2SourceStampSigner = new V2SourceStampSigner.Builder(sourceStampSignerConfig, signatureSchemeDigestInfos).setSourceStampTimestampEnabled(this.mSourceStampTimestampEnabled).build();
            signingSchemeBlocks.add(v2SourceStampSigner.generateSourceStampBlock());
        }
        byte[] apkSigningBlock = ApkSigningBlockUtils.generateApkSigningBlock(signingSchemeBlocks);
        this.mAddSigningBlockRequest = new OutputApkSigningBlockRequestImpl(apkSigningBlock, padSizeBeforeApkSigningBlock);
        return this.mAddSigningBlockRequest;
    }

    @Override
    public void outputDone() {
        this.checkNotClosed();
        this.checkV1SigningDoneIfEnabled();
        this.checkSigningBlockDoneIfEnabled();
    }

    @Override
    public void signV4(DataSource dataSource, File outputFile, boolean ignoreFailures) throws SignatureException {
        if (outputFile == null) {
            if (ignoreFailures) {
                return;
            }
            throw new SignatureException("Missing V4 output file.");
        }
        try {
            V4SchemeSigner.SignerConfig v4SignerConfig = this.createV4SignerConfig();
            V4SchemeSigner.generateV4Signature(dataSource, v4SignerConfig, outputFile);
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException e15) {
            if (ignoreFailures) {
                return;
            }
            throw new SignatureException("V4 signing failed", e15);
        }
    }

    public byte[] produceV4Signature(DataSource dataSource, OutputStream sigOutput) throws SignatureException {
        if (sigOutput == null) {
            throw new SignatureException("Missing V4 output streams.");
        }
        try {
            V4SchemeSigner.SignerConfig v4SignerConfig = this.createV4SignerConfig();
            Pair<V4Signature, byte[]> pair = V4SchemeSigner.generateV4Signature(dataSource, v4SignerConfig);
            pair.getFirst().writeTo(sigOutput);
            return pair.getSecond();
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException e15) {
            throw new SignatureException("V4 signing failed", e15);
        }
    }

    @Override
    public boolean isEligibleForSourceStamp() {
        return this.mSourceStampSignerConfig != null && (this.mV2SigningEnabled || this.mV3SigningEnabled || this.mV1SigningEnabled);
    }

    @Override
    public byte[] generateSourceStampCertificateDigest() throws SignatureException {
        if (this.mSourceStampSignerConfig.getCertificates().isEmpty()) {
            throw new SignatureException("No certificates configured for stamp");
        }
        try {
            return ApkUtils.computeSha256DigestBytes(this.mSourceStampSignerConfig.getCertificates().get(0).getEncoded());
        }
        catch (CertificateEncodingException e15) {
            throw new SignatureException("Failed to encode source stamp certificate", e15);
        }
    }

    @Override
    public void close() {
        this.mClosed = true;
        this.mAddV1SignatureRequest = null;
        this.mInputJarManifestEntryDataRequest = null;
        this.mOutputAndroidManifestEntryDataRequest = null;
        this.mDebuggable = null;
        this.mOutputJarEntryDigestRequests.clear();
        this.mOutputJarEntryDigests.clear();
        this.mEmittedSignatureJarEntryData.clear();
        this.mOutputSignatureJarEntryDataRequests.clear();
        this.mAddSigningBlockRequest = null;
    }

    private void invalidateV1Signature() {
        if (this.mV1SigningEnabled) {
            this.mV1SignaturePending = true;
        }
        this.invalidateV2Signature();
    }

    private void invalidateV2Signature() {
        if (this.mV2SigningEnabled) {
            this.mV2SignaturePending = true;
            this.mAddSigningBlockRequest = null;
        }
    }

    private void invalidateV3Signature() {
        if (this.mV3SigningEnabled) {
            this.mV3SignaturePending = true;
            this.mAddSigningBlockRequest = null;
        }
    }

    private void checkNotClosed() {
        if (this.mClosed) {
            throw new IllegalStateException("Engine closed");
        }
    }

    private void checkV1SigningDoneIfEnabled() {
        if (!this.mV1SignaturePending) {
            return;
        }
        if (this.mAddV1SignatureRequest == null) {
            throw new IllegalStateException("v1 signature (JAR signature) not yet generated. Skipped outputJarEntries()?");
        }
        if (!this.mAddV1SignatureRequest.isDone()) {
            throw new IllegalStateException("v1 signature (JAR signature) addition requested by outputJarEntries() hasn't been fulfilled");
        }
        for (Map.Entry<String, byte[]> expectedOutputEntry : this.mEmittedSignatureJarEntryData.entrySet()) {
            String entryName = expectedOutputEntry.getKey();
            byte[] expectedData = expectedOutputEntry.getValue();
            GetJarEntryDataRequest actualDataRequest = this.mOutputSignatureJarEntryDataRequests.get(entryName);
            if (actualDataRequest == null) {
                throw new IllegalStateException("APK entry " + entryName + " not yet output despite this having been requested");
            }
            if (!actualDataRequest.isDone()) {
                throw new IllegalStateException("Still waiting to inspect output APK's " + entryName);
            }
            byte[] actualData = actualDataRequest.getData();
            if (Arrays.equals(expectedData, actualData)) continue;
            throw new IllegalStateException("Output APK entry " + entryName + " data differs from what was requested");
        }
        this.mV1SignaturePending = false;
    }

    private void checkSigningBlockDoneIfEnabled() {
        if (!this.mV2SignaturePending && !this.mV3SignaturePending) {
            return;
        }
        if (this.mAddSigningBlockRequest == null) {
            throw new IllegalStateException("Signed APK Signing BLock not yet generated. Skipped outputZipSections()?");
        }
        if (!this.mAddSigningBlockRequest.isDone()) {
            throw new IllegalStateException("APK Signing Block addition of signature(s) requested by outputZipSections() hasn't been fulfilled yet");
        }
        this.mAddSigningBlockRequest = null;
        this.mV2SignaturePending = false;
        this.mV3SignaturePending = false;
    }

    private void checkOutputApkNotDebuggableIfDebuggableMustBeRejected() throws SignatureException {
        if (this.mDebuggableApkPermitted) {
            return;
        }
        try {
            if (this.isOutputApkDebuggable()) {
                throw new SignatureException("APK is debuggable (see android:debuggable attribute) and this engine is configured to refuse to sign debuggable APKs");
            }
        }
        catch (ApkFormatException e15) {
            throw new SignatureException("Failed to determine whether the APK is debuggable", e15);
        }
    }

    private boolean isOutputApkDebuggable() throws ApkFormatException {
        if (this.mDebuggable != null) {
            return this.mDebuggable;
        }
        if (this.mOutputAndroidManifestEntryDataRequest == null) {
            throw new IllegalStateException("Cannot determine debuggable status of output APK because AndroidManifest.xml entry contents have not yet been requested");
        }
        if (!this.mOutputAndroidManifestEntryDataRequest.isDone()) {
            throw new IllegalStateException("Still waiting to inspect output APK's " + this.mOutputAndroidManifestEntryDataRequest.getEntryName());
        }
        this.mDebuggable = ApkUtils.getDebuggableFromBinaryAndroidManifest(ByteBuffer.wrap(this.mOutputAndroidManifestEntryDataRequest.getData()));
        return this.mDebuggable;
    }

    private void forgetOutputApkDebuggableStatus() {
        this.mDebuggable = null;
    }

    private ApkSignerEngine.InputJarEntryInstructions.OutputPolicy getInputJarEntryOutputPolicy(String entryName) {
        if (this.mSignatureExpectedOutputJarEntryNames.contains(entryName)) {
            return ApkSignerEngine.InputJarEntryInstructions.OutputPolicy.OUTPUT_BY_ENGINE;
        }
        if (this.mOtherSignersSignaturesPreserved || V1SchemeSigner.isJarEntryDigestNeededInManifest(entryName)) {
            return ApkSignerEngine.InputJarEntryInstructions.OutputPolicy.OUTPUT;
        }
        return ApkSignerEngine.InputJarEntryInstructions.OutputPolicy.SKIP;
    }

    static {
        DISCARDED_SIGNATURE_BLOCK_IDS.add(1114793335);
        DISCARDED_SIGNATURE_BLOCK_IDS.add(722016414);
        DISCARDED_SIGNATURE_BLOCK_IDS.add(1845461005);
    }

    public static class SignerConfig {
        private final String mName;
        private final KeyConfig mKeyConfig;
        private final List<X509Certificate> mCertificates;
        private final boolean mDeterministicDsaSigning;
        private final int mMinSdkVersion;
        private final boolean mSignerTargetsDevRelease;
        private final SigningCertificateLineage mSigningCertificateLineage;

        private SignerConfig(Builder builder) {
            this.mName = builder.mName;
            this.mKeyConfig = builder.mKeyConfig;
            this.mCertificates = Collections.unmodifiableList(new ArrayList(builder.mCertificates));
            this.mDeterministicDsaSigning = builder.mDeterministicDsaSigning;
            this.mMinSdkVersion = builder.mMinSdkVersion;
            this.mSignerTargetsDevRelease = builder.mSignerTargetsDevRelease;
            this.mSigningCertificateLineage = builder.mSigningCertificateLineage;
        }

        public String getName() {
            return this.mName;
        }

        @Deprecated
        public PrivateKey getPrivateKey() {
            return this.mKeyConfig.match(jca -> jca.privateKey, kms -> null);
        }

        public KeyConfig getKeyConfig() {
            return this.mKeyConfig;
        }

        public List<X509Certificate> getCertificates() {
            return this.mCertificates;
        }

        public boolean getDeterministicDsaSigning() {
            return this.mDeterministicDsaSigning;
        }

        public int getMinSdkVersion() {
            return this.mMinSdkVersion;
        }

        public boolean getSignerTargetsDevRelease() {
            return this.mSignerTargetsDevRelease;
        }

        public SigningCertificateLineage getSigningCertificateLineage() {
            return this.mSigningCertificateLineage;
        }

        public static class Builder {
            private final String mName;
            private final KeyConfig mKeyConfig;
            private final List<X509Certificate> mCertificates;
            private final boolean mDeterministicDsaSigning;
            private int mMinSdkVersion;
            private boolean mSignerTargetsDevRelease;
            private SigningCertificateLineage mSigningCertificateLineage;

            @Deprecated
            public Builder(String name, PrivateKey privateKey, List<X509Certificate> certificates) {
                this(name, privateKey, certificates, false);
            }

            @Deprecated
            public Builder(String name, PrivateKey privateKey, List<X509Certificate> certificates, boolean deterministicDsaSigning) {
                if (name.isEmpty()) {
                    throw new IllegalArgumentException("Empty name");
                }
                this.mName = name;
                this.mKeyConfig = new KeyConfig.Jca(privateKey);
                this.mCertificates = new ArrayList<X509Certificate>(certificates);
                this.mDeterministicDsaSigning = deterministicDsaSigning;
            }

            public Builder(String name, KeyConfig keyConfig, List<X509Certificate> certificates) {
                this(name, keyConfig, certificates, false);
            }

            public Builder(String name, KeyConfig keyConfig, List<X509Certificate> certificates, boolean deterministicDsaSigning) {
                if (name.isEmpty()) {
                    throw new IllegalArgumentException("Empty name");
                }
                this.mName = name;
                this.mKeyConfig = keyConfig;
                this.mCertificates = new ArrayList<X509Certificate>(certificates);
                this.mDeterministicDsaSigning = deterministicDsaSigning;
            }

            public Builder setMinSdkVersion(int minSdkVersion) {
                return this.setLineageForMinSdkVersion(null, minSdkVersion);
            }

            public Builder setLineageForMinSdkVersion(SigningCertificateLineage lineage, int minSdkVersion) {
                if (minSdkVersion < 28) {
                    throw new IllegalArgumentException("SDK targeted signing config is only supported with the V3 signature scheme on Android P (SDK version 28) and later");
                }
                if (minSdkVersion < 33) {
                    minSdkVersion = 28;
                }
                this.mMinSdkVersion = minSdkVersion;
                if (lineage != null && !lineage.isCertificateInLineage(this.mCertificates.get(0))) {
                    throw new IllegalArgumentException("The provided lineage does not contain the signing certificate, " + this.mCertificates.get(0).getSubjectDN() + ", for this SignerConfig");
                }
                this.mSigningCertificateLineage = lineage;
                return this;
            }

            private Builder setSignerTargetsDevRelease(boolean signerTargetsDevRelease) {
                if (signerTargetsDevRelease && this.mMinSdkVersion < 33) {
                    throw new IllegalArgumentException("Rotation can only target a development release for signers targeting 33 or later");
                }
                this.mSignerTargetsDevRelease = signerTargetsDevRelease;
                return this;
            }

            public SignerConfig build() {
                return new SignerConfig(this);
            }
        }
    }

    private static class GetJarEntryDataRequest
    implements ApkSignerEngine.InspectJarEntryRequest {
        private final String mEntryName;
        private final Object mLock = new Object();
        private boolean mDone;
        private DataSink mDataSink;
        private ByteArrayOutputStream mDataSinkBuf;

        private GetJarEntryDataRequest(String entryName) {
            this.mEntryName = entryName;
        }

        @Override
        public String getEntryName() {
            return this.mEntryName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DataSink getDataSink() {
            Object object = this.mLock;
            synchronized (object) {
                this.checkNotDone();
                if (this.mDataSinkBuf == null) {
                    this.mDataSinkBuf = new ByteArrayOutputStream();
                }
                if (this.mDataSink == null) {
                    this.mDataSink = DataSinks.asDataSink(this.mDataSinkBuf);
                }
                return this.mDataSink;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void done() {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mDone) {
                    return;
                }
                this.mDone = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isDone() {
            Object object = this.mLock;
            synchronized (object) {
                return this.mDone;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkNotDone() throws IllegalStateException {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mDone) {
                    throw new IllegalStateException("Already done");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] getData() {
            Object object = this.mLock;
            synchronized (object) {
                if (!this.mDone) {
                    throw new IllegalStateException("Not yet done");
                }
                return this.mDataSinkBuf != null ? this.mDataSinkBuf.toByteArray() : new byte[]{};
            }
        }
    }

    private static class GetJarEntryDataDigestRequest
    implements ApkSignerEngine.InspectJarEntryRequest {
        private final String mEntryName;
        private final String mJcaDigestAlgorithm;
        private final Object mLock = new Object();
        private boolean mDone;
        private DataSink mDataSink;
        private MessageDigest mMessageDigest;
        private byte[] mDigest;

        private GetJarEntryDataDigestRequest(String entryName, String jcaDigestAlgorithm) {
            this.mEntryName = entryName;
            this.mJcaDigestAlgorithm = jcaDigestAlgorithm;
        }

        @Override
        public String getEntryName() {
            return this.mEntryName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DataSink getDataSink() {
            Object object = this.mLock;
            synchronized (object) {
                this.checkNotDone();
                if (this.mDataSink == null) {
                    this.mDataSink = DataSinks.asDataSink(this.getMessageDigest());
                }
                return this.mDataSink;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private MessageDigest getMessageDigest() {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mMessageDigest == null) {
                    try {
                        this.mMessageDigest = MessageDigest.getInstance(this.mJcaDigestAlgorithm);
                    }
                    catch (NoSuchAlgorithmException e15) {
                        throw new RuntimeException(this.mJcaDigestAlgorithm + " MessageDigest not available", e15);
                    }
                }
                return this.mMessageDigest;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void done() {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mDone) {
                    return;
                }
                this.mDone = true;
                this.mDigest = this.getMessageDigest().digest();
                this.mMessageDigest = null;
                this.mDataSink = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isDone() {
            Object object = this.mLock;
            synchronized (object) {
                return this.mDone;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkNotDone() throws IllegalStateException {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mDone) {
                    throw new IllegalStateException("Already done");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] getDigest() {
            Object object = this.mLock;
            synchronized (object) {
                if (!this.mDone) {
                    throw new IllegalStateException("Not yet done");
                }
                return (byte[])this.mDigest.clone();
            }
        }
    }

    private static class CompoundInspectJarEntryRequest
    implements ApkSignerEngine.InspectJarEntryRequest {
        private final String mEntryName;
        private final ApkSignerEngine.InspectJarEntryRequest[] mRequests;
        private final Object mLock = new Object();
        private DataSink mSink;

        private CompoundInspectJarEntryRequest(String entryName, ApkSignerEngine.InspectJarEntryRequest ... requests) {
            this.mEntryName = entryName;
            this.mRequests = requests;
        }

        @Override
        public String getEntryName() {
            return this.mEntryName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DataSink getDataSink() {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mSink == null) {
                    DataSink[] sinks = new DataSink[this.mRequests.length];
                    for (int i15 = 0; i15 < sinks.length; ++i15) {
                        sinks[i15] = this.mRequests[i15].getDataSink();
                    }
                    this.mSink = new TeeDataSink(sinks);
                }
                return this.mSink;
            }
        }

        @Override
        public void done() {
            for (ApkSignerEngine.InspectJarEntryRequest request : this.mRequests) {
                request.done();
            }
        }
    }

    private static class OutputJarSignatureRequestImpl
    implements ApkSignerEngine.OutputJarSignatureRequest {
        private final List<ApkSignerEngine.OutputJarSignatureRequest.JarEntry> mAdditionalJarEntries;
        private volatile boolean mDone;

        private OutputJarSignatureRequestImpl(List<ApkSignerEngine.OutputJarSignatureRequest.JarEntry> additionalZipEntries) {
            this.mAdditionalJarEntries = Collections.unmodifiableList(new ArrayList<ApkSignerEngine.OutputJarSignatureRequest.JarEntry>(additionalZipEntries));
        }

        @Override
        public List<ApkSignerEngine.OutputJarSignatureRequest.JarEntry> getAdditionalJarEntries() {
            return this.mAdditionalJarEntries;
        }

        @Override
        public void done() {
            this.mDone = true;
        }

        private boolean isDone() {
            return this.mDone;
        }
    }

    private static class OutputApkSigningBlockRequestImpl
    implements ApkSignerEngine.OutputApkSigningBlockRequest,
    ApkSignerEngine.OutputApkSigningBlockRequest2 {
        private final byte[] mApkSigningBlock;
        private final int mPaddingBeforeApkSigningBlock;
        private volatile boolean mDone;

        private OutputApkSigningBlockRequestImpl(byte[] apkSigingBlock, int paddingBefore) {
            this.mApkSigningBlock = (byte[])apkSigingBlock.clone();
            this.mPaddingBeforeApkSigningBlock = paddingBefore;
        }

        @Override
        public byte[] getApkSigningBlock() {
            return (byte[])this.mApkSigningBlock.clone();
        }

        @Override
        public void done() {
            this.mDone = true;
        }

        private boolean isDone() {
            return this.mDone;
        }

        @Override
        public int getPaddingSizeBeforeApkSigningBlock() {
            return this.mPaddingBeforeApkSigningBlock;
        }
    }

    public static class Builder {
        private List<SignerConfig> mSignerConfigs;
        private List<SignerConfig> mTargetedSignerConfigs;
        private SignerConfig mStampSignerConfig;
        private SigningCertificateLineage mSourceStampSigningCertificateLineage;
        private boolean mSourceStampTimestampEnabled = true;
        private final int mMinSdkVersion;
        private boolean mV1SigningEnabled = true;
        private boolean mV2SigningEnabled = true;
        private boolean mV3SigningEnabled = true;
        private int mRotationMinSdkVersion = 33;
        private boolean mRotationTargetsDevRelease = false;
        private boolean mVerityEnabled = false;
        private boolean mDebuggableApkPermitted = true;
        private boolean mOtherSignersSignaturesPreserved;
        private String mCreatedBy = "1.0 (Android)";
        private SigningCertificateLineage mSigningCertificateLineage;
        private boolean mV3SigningExplicitlyDisabled = false;
        private boolean mV3SigningExplicitlyEnabled = false;

        public Builder(List<SignerConfig> signerConfigs, int minSdkVersion) {
            if (signerConfigs.isEmpty()) {
                throw new IllegalArgumentException("At least one signer config must be provided");
            }
            if (signerConfigs.size() > 1) {
                this.mV3SigningEnabled = false;
            }
            this.mSignerConfigs = new ArrayList<SignerConfig>(signerConfigs);
            this.mMinSdkVersion = minSdkVersion;
        }

        private void setEnabledSignatureSchemes() {
            if (this.mV3SigningExplicitlyDisabled && this.mV3SigningExplicitlyEnabled) {
                throw new IllegalStateException("Builder configured to both enable and disable APK Signature Scheme v3 signing");
            }
            if (this.mV3SigningExplicitlyDisabled) {
                this.mV3SigningEnabled = false;
            } else if (this.mV3SigningExplicitlyEnabled) {
                this.mV3SigningEnabled = true;
            }
        }

        private void setTargetedSignerConfigs() throws InvalidKeyException {
            this.mSignerConfigs.sort((signerConfig1, signerConfig2) -> signerConfig1.getMinSdkVersion() - signerConfig2.getMinSdkVersion());
            this.mTargetedSignerConfigs = new ArrayList<SignerConfig>();
            for (int i15 = 0; i15 < this.mSignerConfigs.size(); ++i15) {
                if (this.mSignerConfigs.get(i15).getMinSdkVersion() <= 0) continue;
                this.mTargetedSignerConfigs = this.mSignerConfigs.subList(i15, this.mSignerConfigs.size());
                this.mSignerConfigs = this.mSignerConfigs.subList(0, i15);
                break;
            }
            if (this.mSigningCertificateLineage != null) {
                int firstTargetedSdkVersion;
                if (!this.mTargetedSignerConfigs.isEmpty() && this.mRotationMinSdkVersion >= (firstTargetedSdkVersion = this.mTargetedSignerConfigs.get(0).getMinSdkVersion())) {
                    throw new IllegalStateException("The rotation-min-sdk-version, " + this.mRotationMinSdkVersion + ", must be less than the first targeted SDK version, " + firstTargetedSdkVersion);
                }
                try {
                    this.mSignerConfigs = this.mSigningCertificateLineage.sortSignerConfigs(this.mSignerConfigs);
                }
                catch (IllegalArgumentException e15) {
                    throw new IllegalStateException("Provided signer configs do not match the provided SigningCertificateLineage", e15);
                }
                SignerConfig rotatedSignerConfig = this.mSignerConfigs.remove(this.mSignerConfigs.size() - 1);
                SignerConfig.Builder rotatedConfigBuilder = new SignerConfig.Builder(rotatedSignerConfig.getName(), rotatedSignerConfig.getKeyConfig(), rotatedSignerConfig.getCertificates(), rotatedSignerConfig.getDeterministicDsaSigning());
                rotatedConfigBuilder.setLineageForMinSdkVersion(this.mSigningCertificateLineage, this.mRotationMinSdkVersion);
                rotatedConfigBuilder.setSignerTargetsDevRelease(this.mRotationTargetsDevRelease);
                this.mTargetedSignerConfigs.add(0, rotatedConfigBuilder.build());
            }
            this.mSigningCertificateLineage = this.mergeTargetedSigningConfigLineages();
        }

        private SigningCertificateLineage mergeTargetedSigningConfigLineages() throws InvalidKeyException {
            SigningCertificateLineage mergedLineage = null;
            int prevSdkVersion = 0;
            for (SignerConfig signerConfig : this.mTargetedSignerConfigs) {
                int signerMinSdkVersion = signerConfig.getMinSdkVersion();
                if (signerMinSdkVersion < 28) {
                    throw new IllegalStateException("Targeted signing config is not supported prior to SDK version 28; received value " + signerMinSdkVersion);
                }
                SigningCertificateLineage signerLineage = signerConfig.getSigningCertificateLineage();
                if (signerLineage == null) {
                    try {
                        signerLineage = new SigningCertificateLineage.Builder(new SigningCertificateLineage.SignerConfig.Builder(signerConfig.mKeyConfig, (X509Certificate)signerConfig.mCertificates.get(0)).build()).build();
                    }
                    catch (NoSuchAlgorithmException | SignatureException | CertificateEncodingException e15) {
                        throw new IllegalStateException("Unable to create a SignerConfig for signer from certificate " + ((X509Certificate)signerConfig.mCertificates.get(0)).getSubjectDN());
                    }
                }
                if (signerMinSdkVersion < 33) {
                    signerMinSdkVersion = 28;
                }
                if (signerMinSdkVersion == prevSdkVersion) {
                    throw new IllegalStateException("Multiple SignerConfigs were found targeting SDK version " + signerMinSdkVersion);
                }
                if (mergedLineage == null) {
                    mergedLineage = signerLineage;
                } else {
                    try {
                        mergedLineage = mergedLineage.mergeLineageWith(signerLineage);
                    }
                    catch (IllegalArgumentException e16) {
                        throw new IllegalStateException("The provided lineage targeting SDK " + signerMinSdkVersion + " is not in the signing history of the other targeted signing configs", e16);
                    }
                }
                prevSdkVersion = signerMinSdkVersion;
            }
            return mergedLineage;
        }

        public DefaultApkSignerEngine build() throws InvalidKeyException {
            this.setEnabledSignatureSchemes();
            this.setTargetedSignerConfigs();
            if (this.mSigningCertificateLineage != null) {
                if (!this.mV3SigningEnabled && this.mSignerConfigs.size() > 1) {
                    throw new IllegalStateException("Provided multiple signers which are part of the SigningCertificateLineage, but not signing with APK Signature Scheme v3");
                }
            } else if (this.mV3SigningEnabled && this.mSignerConfigs.size() > 1) {
                throw new IllegalStateException("Multiple signing certificates provided for use with APK Signature Scheme v3 without an accompanying SigningCertificateLineage");
            }
            return new DefaultApkSignerEngine(this.mSignerConfigs, this.mTargetedSignerConfigs, this.mStampSignerConfig, this.mSourceStampSigningCertificateLineage, this.mSourceStampTimestampEnabled, this.mMinSdkVersion, this.mV1SigningEnabled, this.mV2SigningEnabled, this.mV3SigningEnabled, this.mVerityEnabled, this.mDebuggableApkPermitted, this.mOtherSignersSignaturesPreserved, this.mCreatedBy, this.mSigningCertificateLineage);
        }

        public Builder setStampSignerConfig(SignerConfig stampSignerConfig) {
            this.mStampSignerConfig = stampSignerConfig;
            return this;
        }

        public Builder setSourceStampSigningCertificateLineage(SigningCertificateLineage sourceStampSigningCertificateLineage) {
            this.mSourceStampSigningCertificateLineage = sourceStampSigningCertificateLineage;
            return this;
        }

        public Builder setSourceStampTimestampEnabled(boolean value) {
            this.mSourceStampTimestampEnabled = value;
            return this;
        }

        public Builder setV1SigningEnabled(boolean enabled) {
            this.mV1SigningEnabled = enabled;
            return this;
        }

        public Builder setV2SigningEnabled(boolean enabled) {
            this.mV2SigningEnabled = enabled;
            return this;
        }

        public Builder setV3SigningEnabled(boolean enabled) {
            this.mV3SigningEnabled = enabled;
            if (enabled) {
                this.mV3SigningExplicitlyEnabled = true;
            } else {
                this.mV3SigningExplicitlyDisabled = true;
            }
            return this;
        }

        public Builder setVerityEnabled(boolean enabled) {
            this.mVerityEnabled = enabled;
            return this;
        }

        public Builder setDebuggableApkPermitted(boolean permitted) {
            this.mDebuggableApkPermitted = permitted;
            return this;
        }

        public Builder setOtherSignersSignaturesPreserved(boolean preserved) {
            this.mOtherSignersSignaturesPreserved = preserved;
            return this;
        }

        public Builder setCreatedBy(String createdBy) {
            if (createdBy == null) {
                throw new NullPointerException();
            }
            this.mCreatedBy = createdBy;
            return this;
        }

        public Builder setSigningCertificateLineage(SigningCertificateLineage signingCertificateLineage) {
            if (signingCertificateLineage != null) {
                this.mV3SigningEnabled = true;
                this.mSigningCertificateLineage = signingCertificateLineage;
            }
            return this;
        }

        public Builder setMinSdkVersionForRotation(int minSdkVersion) {
            this.mRotationMinSdkVersion = minSdkVersion < 33 ? 28 : minSdkVersion;
            return this;
        }

        public Builder setRotationTargetsDevRelease(boolean enabled) {
            this.mRotationTargetsDevRelease = enabled;
            return this;
        }
    }
}

