/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.util;

import ch.qos.logback.core.spi.ContextAware;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;

public class StringToObjectConverter {
    private static final Class<?>[] STRING_CLASS_PARAMETER = new Class[]{String.class};

    public static boolean canBeBuiltFromSimpleString(Class<?> parameterClass) {
        Package p15 = parameterClass.getPackage();
        if (parameterClass.isPrimitive()) {
            return true;
        }
        if (p15 != null && "java.lang".equals(p15.getName())) {
            return true;
        }
        if (StringToObjectConverter.followsTheValueOfConvention(parameterClass)) {
            return true;
        }
        if (parameterClass.isEnum()) {
            return true;
        }
        return StringToObjectConverter.isOfTypeCharset(parameterClass);
    }

    public static Object convertArg(ContextAware ca5, String val, Class<?> type) {
        if (val == null) {
            return null;
        }
        String v15 = val.trim();
        if (String.class.isAssignableFrom(type)) {
            return v15;
        }
        if (Integer.TYPE.isAssignableFrom(type)) {
            return Integer.valueOf(v15);
        }
        if (Long.TYPE.isAssignableFrom(type)) {
            return Long.valueOf(v15);
        }
        if (Float.TYPE.isAssignableFrom(type)) {
            return Float.valueOf(v15);
        }
        if (Double.TYPE.isAssignableFrom(type)) {
            return Double.valueOf(v15);
        }
        if (Boolean.TYPE.isAssignableFrom(type)) {
            if ("true".equalsIgnoreCase(v15)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(v15)) {
                return Boolean.FALSE;
            }
        } else {
            if (type.isEnum()) {
                return StringToObjectConverter.convertToEnum(ca5, v15, type);
            }
            if (StringToObjectConverter.followsTheValueOfConvention(type)) {
                return StringToObjectConverter.convertByValueOfMethod(ca5, type, v15);
            }
            if (StringToObjectConverter.isOfTypeCharset(type)) {
                return StringToObjectConverter.convertToCharset(ca5, val);
            }
        }
        return null;
    }

    private static boolean isOfTypeCharset(Class<?> type) {
        return Charset.class.isAssignableFrom(type);
    }

    private static Charset convertToCharset(ContextAware ca5, String val) {
        if ("null".equalsIgnoreCase(val)) {
            ca5.addInfo("Converting the string \"null\" as Charset.defaultCharset()");
            return Charset.defaultCharset();
        }
        try {
            return Charset.forName(val);
        }
        catch (UnsupportedCharsetException e15) {
            ca5.addError("Failed to get charset [" + val + "]", e15);
            return null;
        }
    }

    public static Method getValueOfMethod(Class<?> type) {
        try {
            return type.getMethod("valueOf", STRING_CLASS_PARAMETER);
        }
        catch (NoSuchMethodException e15) {
            return null;
        }
        catch (SecurityException e16) {
            return null;
        }
    }

    public static boolean followsTheValueOfConvention(Class<?> parameterClass) {
        Method valueOfMethod = StringToObjectConverter.getValueOfMethod(parameterClass);
        if (valueOfMethod == null) {
            return false;
        }
        int mod = valueOfMethod.getModifiers();
        return Modifier.isStatic(mod);
    }

    private static Object convertByValueOfMethod(ContextAware ca5, Class<?> type, String val) {
        try {
            Method valueOfMethod = type.getMethod("valueOf", STRING_CLASS_PARAMETER);
            return valueOfMethod.invoke(null, val);
        }
        catch (Exception e15) {
            ca5.addError("Failed to invoke valueOf{} method in class [" + type.getName() + "] with value [" + val + "]");
            return null;
        }
    }

    private static Object convertToEnum(ContextAware ca5, String val, Class<? extends Enum> enumType) {
        return Enum.valueOf(enumType, val);
    }

    boolean isBuildableFromSimpleString() {
        return false;
    }
}

