/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.classic.spi.ClassPackagingData;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.CoreConstants;

public class ThrowableProxyUtil {
    public static final int REGULAR_EXCEPTION_INDENT = 1;
    public static final int SUPPRESSED_EXCEPTION_INDENT = 1;
    private static final int BUILDER_CAPACITY = 2048;

    public static void build(ThrowableProxy nestedTP, Throwable nestedThrowable, ThrowableProxy parentTP) {
        StackTraceElement[] nestedSTE = nestedThrowable.getStackTrace();
        int commonFramesCount = -1;
        if (parentTP != null) {
            commonFramesCount = ThrowableProxyUtil.findNumberOfCommonFrames(nestedSTE, parentTP.getStackTraceElementProxyArray());
        }
        nestedTP.commonFrames = commonFramesCount;
        nestedTP.stackTraceElementProxyArray = ThrowableProxyUtil.steArrayToStepArray(nestedSTE);
    }

    static StackTraceElementProxy[] steArrayToStepArray(StackTraceElement[] stea) {
        if (stea == null) {
            return new StackTraceElementProxy[0];
        }
        StackTraceElementProxy[] stepa = new StackTraceElementProxy[stea.length];
        for (int i15 = 0; i15 < stepa.length; ++i15) {
            stepa[i15] = new StackTraceElementProxy(stea[i15]);
        }
        return stepa;
    }

    static int findNumberOfCommonFrames(StackTraceElement[] steArray, StackTraceElementProxy[] parentSTEPArray) {
        StackTraceElement otherSte;
        StackTraceElement ste;
        if (parentSTEPArray == null || steArray == null) {
            return 0;
        }
        int steIndex = steArray.length - 1;
        int count = 0;
        for (int parentIndex = parentSTEPArray.length - 1; steIndex >= 0 && parentIndex >= 0 && (ste = steArray[steIndex]).equals(otherSte = parentSTEPArray[parentIndex].ste); --steIndex, --parentIndex) {
            ++count;
        }
        return count;
    }

    public static void appendNominalFirstLine(StringBuilder buf, String classname, String message2) {
        buf.append(classname).append(": ").append(message2);
    }

    public static String asString(IThrowableProxy tp4) {
        StringBuilder sb5 = new StringBuilder(2048);
        ThrowableProxyUtil.recursiveAppend(sb5, null, 1, tp4);
        return sb5.toString();
    }

    private static void recursiveAppend(StringBuilder sb5, String prefix, int indent, IThrowableProxy tp4) {
        if (tp4 == null) {
            return;
        }
        ThrowableProxyUtil.subjoinFirstLine(sb5, prefix, indent, tp4);
        sb5.append(CoreConstants.LINE_SEPARATOR);
        ThrowableProxyUtil.subjoinSTEPArray(sb5, indent, tp4);
        IThrowableProxy[] suppressed = tp4.getSuppressed();
        if (suppressed != null) {
            for (IThrowableProxy current : suppressed) {
                ThrowableProxyUtil.recursiveAppend(sb5, "Suppressed: ", indent + 1, current);
            }
        }
        ThrowableProxyUtil.recursiveAppend(sb5, "Caused by: ", indent, tp4.getCause());
    }

    public static void indent(StringBuilder buf, int indent) {
        for (int j15 = 0; j15 < indent; ++j15) {
            buf.append('\t');
        }
    }

    private static void subjoinFirstLine(StringBuilder buf, String prefix, int indent, IThrowableProxy tp4) {
        ThrowableProxyUtil.indent(buf, indent - 1);
        if (prefix != null) {
            buf.append(prefix);
        }
        ThrowableProxyUtil.subjoinExceptionMessage(buf, tp4);
    }

    public static void subjoinPackagingData(StringBuilder builder, StackTraceElementProxy step) {
        ClassPackagingData cpd;
        if (step != null && (cpd = step.getClassPackagingData()) != null) {
            if (!cpd.isExact()) {
                builder.append(" ~[");
            } else {
                builder.append(" [");
            }
            builder.append(cpd.getCodeLocation()).append(':').append(cpd.getVersion()).append(']');
        }
    }

    public static void subjoinSTEP(StringBuilder sb5, StackTraceElementProxy step) {
        sb5.append(step.toString());
        ThrowableProxyUtil.subjoinPackagingData(sb5, step);
    }

    public static void subjoinSTEPArray(StringBuilder sb5, IThrowableProxy tp4) {
        ThrowableProxyUtil.subjoinSTEPArray(sb5, 1, tp4);
    }

    public static void subjoinSTEPArray(StringBuilder sb5, int indentLevel, IThrowableProxy tp4) {
        StackTraceElementProxy[] stepArray = tp4.getStackTraceElementProxyArray();
        int commonFrames = tp4.getCommonFrames();
        for (int i15 = 0; i15 < stepArray.length - commonFrames; ++i15) {
            StackTraceElementProxy step = stepArray[i15];
            ThrowableProxyUtil.indent(sb5, indentLevel);
            ThrowableProxyUtil.subjoinSTEP(sb5, step);
            sb5.append(CoreConstants.LINE_SEPARATOR);
        }
        if (commonFrames > 0) {
            ThrowableProxyUtil.indent(sb5, indentLevel);
            sb5.append("... ").append(commonFrames).append(" common frames omitted").append(CoreConstants.LINE_SEPARATOR);
        }
    }

    public static void subjoinFirstLine(StringBuilder buf, IThrowableProxy tp4) {
        int commonFrames = tp4.getCommonFrames();
        if (commonFrames > 0) {
            buf.append("Caused by: ");
        }
        ThrowableProxyUtil.subjoinExceptionMessage(buf, tp4);
    }

    public static void subjoinFirstLineRootCauseFirst(StringBuilder buf, IThrowableProxy tp4) {
        if (tp4.getCause() != null) {
            buf.append("Wrapped by: ");
        }
        ThrowableProxyUtil.subjoinExceptionMessage(buf, tp4);
    }

    public static void subjoinExceptionMessage(StringBuilder stringBuilder, IThrowableProxy tp4) {
        if (tp4.isCyclic()) {
            stringBuilder.append("[CIRCULAR REFERENCE: ");
            ThrowableProxyUtil.appendNominalOrOverridingMessage(stringBuilder, tp4);
            stringBuilder.append(']');
        } else {
            ThrowableProxyUtil.appendNominalOrOverridingMessage(stringBuilder, tp4);
        }
    }

    private static void appendNominalOrOverridingMessage(StringBuilder stringBuilder, IThrowableProxy tp4) {
        if (tp4.getOverridingMessage() == null) {
            ThrowableProxyUtil.appendNominalFirstLine(stringBuilder, tp4.getClassName(), tp4.getMessage());
        } else {
            stringBuilder.append(tp4.getOverridingMessage());
        }
    }
}

