/*
 * Copyright 2021 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.internal.logging.events;

import org.gradle.api.logging.LogLevel;
import org.gradle.internal.operations.logging.LogEventLevel;

class LogLevelConverter {
    public static LogEventLevel convert(LogLevel level) {
        switch (level) {
            case DEBUG:
                return LogEventLevel.DEBUG;
            case QUIET:
                return LogEventLevel.QUIET;
            case INFO:
                return LogEventLevel.INFO;
            case LIFECYCLE:
                return LogEventLevel.LIFECYCLE;
            case WARN:
                return LogEventLevel.WARN;
            case ERROR:
                return LogEventLevel.ERROR;
            default:
                throw new AssertionError();
        }
    }
}
