/*
 * Exynos specific definitions for Samsung pinctrl and gpiolib driver.
 *
 * Copyright (c) 2012 Samsung Electronics Co., Ltd.
 *		http://www.samsung.com
 * Copyright (c) 2012 Linaro Ltd
 *		http://www.linaro.org
 *
 * This file contains the Exynos specific definitions for the Samsung
 * pinctrl/gpiolib interface drivers.
 *
 * Author: Thomas Abraham <thomas.ab@samsung.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#define EXYNOS_GPIO_START(__gpio)	((__gpio##_START) + (__gpio##_NR))

#define EXYNOS4210_GPIO_A0_NR	(8)
#define EXYNOS4210_GPIO_A1_NR	(6)
#define EXYNOS4210_GPIO_B_NR	(8)
#define EXYNOS4210_GPIO_C0_NR	(5)
#define EXYNOS4210_GPIO_C1_NR	(5)
#define EXYNOS4210_GPIO_D0_NR	(4)
#define EXYNOS4210_GPIO_D1_NR	(4)
#define EXYNOS4210_GPIO_E0_NR	(5)
#define EXYNOS4210_GPIO_E1_NR	(8)
#define EXYNOS4210_GPIO_E2_NR	(6)
#define EXYNOS4210_GPIO_E3_NR	(8)
#define EXYNOS4210_GPIO_E4_NR	(8)
#define EXYNOS4210_GPIO_F0_NR	(8)
#define EXYNOS4210_GPIO_F1_NR	(8)
#define EXYNOS4210_GPIO_F2_NR	(8)
#define EXYNOS4210_GPIO_F3_NR	(6)
#define EXYNOS4210_GPIO_J0_NR	(8)
#define EXYNOS4210_GPIO_J1_NR	(5)
#define EXYNOS4210_GPIO_K0_NR	(7)
#define EXYNOS4210_GPIO_K1_NR	(7)
#define EXYNOS4210_GPIO_K2_NR	(7)
#define EXYNOS4210_GPIO_K3_NR	(7)
#define EXYNOS4210_GPIO_L0_NR	(8)
#define EXYNOS4210_GPIO_L1_NR	(3)
#define EXYNOS4210_GPIO_L2_NR	(8)
#define EXYNOS4210_GPIO_Y0_NR	(6)
#define EXYNOS4210_GPIO_Y1_NR	(4)
#define EXYNOS4210_GPIO_Y2_NR	(6)
#define EXYNOS4210_GPIO_Y3_NR	(8)
#define EXYNOS4210_GPIO_Y4_NR	(8)
#define EXYNOS4210_GPIO_Y5_NR	(8)
#define EXYNOS4210_GPIO_Y6_NR	(8)
#define EXYNOS4210_GPIO_X0_NR	(8)
#define EXYNOS4210_GPIO_X1_NR	(8)
#define EXYNOS4210_GPIO_X2_NR	(8)
#define EXYNOS4210_GPIO_X3_NR	(8)
#define EXYNOS4210_GPIO_Z_NR	(7)

enum exynos4210_gpio_xa_start {
	EXYNOS4210_GPIO_A0_START	= 0,
	EXYNOS4210_GPIO_A1_START	= EXYNOS_GPIO_START(EXYNOS4210_GPIO_A0),
	EXYNOS4210_GPIO_B_START		= EXYNOS_GPIO_START(EXYNOS4210_GPIO_A1),
	EXYNOS4210_GPIO_C0_START	= EXYNOS_GPIO_START(EXYNOS4210_GPIO_B),
	EXYNOS4210_GPIO_C1_START	= EXYNOS_GPIO_START(EXYNOS4210_GPIO_C0),
	EXYNOS4210_GPIO_D0_START	= EXYNOS_GPIO_START(EXYNOS4210_GPIO_C1),
	EXYNOS4210_GPIO_D1_START	= EXYNOS_GPIO_START(EXYNOS4210_GPIO_D0),
	EXYNOS4210_GPIO_E0_START	= EXYNOS_GPIO_START(EXYNOS4210_GPIO_D1),
	EXYNOS4210_GPIO_E1_START	= EXYNOS_GPIO_START(EXYNOS4210_GPIO_E0),
	EXYNOS4210_GPIO_E2_START	= EXYNOS_GPIO_START(EXYNOS4210_GPIO_E1),
	EXYNOS4210_GPIO_E3_START	= EXYNOS_GPIO_START(EXYNOS4210_GPIO_E2),
	EXYNOS4210_GPIO_E4_START	= EXYNOS_GPIO_START(EXYNOS4210_GPIO_E3),
	EXYNOS4210_GPIO_F0_START	= EXYNOS_GPIO_START(EXYNOS4210_GPIO_E4),
	EXYNOS4210_GPIO_F1_START	= EXYNOS_GPIO_START(EXYNOS4210_GPIO_F0),
	EXYNOS4210_GPIO_F2_START	= EXYNOS_GPIO_START(EXYNOS4210_GPIO_F1),
	EXYNOS4210_GPIO_F3_START	= EXYNOS_GPIO_START(EXYNOS4210_GPIO_F2),
};

enum exynos4210_gpio_xb_start {
	EXYNOS4210_GPIO_J0_START	= 0,
	EXYNOS4210_GPIO_J1_START	= EXYNOS_GPIO_START(EXYNOS4210_GPIO_J0),
	EXYNOS4210_GPIO_K0_START	= EXYNOS_GPIO_START(EXYNOS4210_GPIO_J1),
	EXYNOS4210_GPIO_K1_START	= EXYNOS_GPIO_START(EXYNOS4210_GPIO_K0),
	EXYNOS4210_GPIO_K2_START	= EXYNOS_GPIO_START(EXYNOS4210_GPIO_K1),
	EXYNOS4210_GPIO_K3_START	= EXYNOS_GPIO_START(EXYNOS4210_GPIO_K2),
	EXYNOS4210_GPIO_L0_START	= EXYNOS_GPIO_START(EXYNOS4210_GPIO_K3),
	EXYNOS4210_GPIO_L1_START	= EXYNOS_GPIO_START(EXYNOS4210_GPIO_L0),
	EXYNOS4210_GPIO_L2_START	= EXYNOS_GPIO_START(EXYNOS4210_GPIO_L1),
	EXYNOS4210_GPIO_Y0_START	= EXYNOS_GPIO_START(EXYNOS4210_GPIO_L2),
	EXYNOS4210_GPIO_Y1_START	= EXYNOS_GPIO_START(EXYNOS4210_GPIO_Y0),
	EXYNOS4210_GPIO_Y2_START	= EXYNOS_GPIO_START(EXYNOS4210_GPIO_Y1),
	EXYNOS4210_GPIO_Y3_START	= EXYNOS_GPIO_START(EXYNOS4210_GPIO_Y2),
	EXYNOS4210_GPIO_Y4_START	= EXYNOS_GPIO_START(EXYNOS4210_GPIO_Y3),
	EXYNOS4210_GPIO_Y5_START	= EXYNOS_GPIO_START(EXYNOS4210_GPIO_Y4),
	EXYNOS4210_GPIO_Y6_START	= EXYNOS_GPIO_START(EXYNOS4210_GPIO_Y5),
	EXYNOS4210_GPIO_X0_START	= EXYNOS_GPIO_START(EXYNOS4210_GPIO_Y6),
	EXYNOS4210_GPIO_X1_START	= EXYNOS_GPIO_START(EXYNOS4210_GPIO_X0),
	EXYNOS4210_GPIO_X2_START	= EXYNOS_GPIO_START(EXYNOS4210_GPIO_X1),
	EXYNOS4210_GPIO_X3_START	= EXYNOS_GPIO_START(EXYNOS4210_GPIO_X2),
};

enum exynos4210_gpio_xc_start {
	EXYNOS4210_GPIO_Z_START		= 0,
};

#define	EXYNOS4210_GPIO_A0_IRQ		EXYNOS4210_GPIO_A0_START
#define	EXYNOS4210_GPIO_A1_IRQ		EXYNOS4210_GPIO_A1_START
#define	EXYNOS4210_GPIO_B_IRQ		EXYNOS4210_GPIO_B_START
#define	EXYNOS4210_GPIO_C0_IRQ		EXYNOS4210_GPIO_C0_START
#define	EXYNOS4210_GPIO_C1_IRQ		EXYNOS4210_GPIO_C1_START
#define	EXYNOS4210_GPIO_D0_IRQ		EXYNOS4210_GPIO_D0_START
#define	EXYNOS4210_GPIO_D1_IRQ		EXYNOS4210_GPIO_D1_START
#define	EXYNOS4210_GPIO_E0_IRQ		EXYNOS4210_GPIO_E0_START
#define	EXYNOS4210_GPIO_E1_IRQ		EXYNOS4210_GPIO_E1_START
#define	EXYNOS4210_GPIO_E2_IRQ		EXYNOS4210_GPIO_E2_START
#define	EXYNOS4210_GPIO_E3_IRQ		EXYNOS4210_GPIO_E3_START
#define	EXYNOS4210_GPIO_E4_IRQ		EXYNOS4210_GPIO_E4_START
#define	EXYNOS4210_GPIO_F0_IRQ		EXYNOS4210_GPIO_F0_START
#define	EXYNOS4210_GPIO_F1_IRQ		EXYNOS4210_GPIO_F1_START
#define	EXYNOS4210_GPIO_F2_IRQ		EXYNOS4210_GPIO_F2_START
#define	EXYNOS4210_GPIO_F3_IRQ		EXYNOS4210_GPIO_F3_START
#define	EXYNOS4210_GPIO_J0_IRQ		EXYNOS4210_GPIO_J0_START
#define	EXYNOS4210_GPIO_J1_IRQ		EXYNOS4210_GPIO_J1_START
#define	EXYNOS4210_GPIO_K0_IRQ		EXYNOS4210_GPIO_K0_START
#define	EXYNOS4210_GPIO_K1_IRQ		EXYNOS4210_GPIO_K1_START
#define	EXYNOS4210_GPIO_K2_IRQ		EXYNOS4210_GPIO_K2_START
#define	EXYNOS4210_GPIO_K3_IRQ		EXYNOS4210_GPIO_K3_START
#define	EXYNOS4210_GPIO_L0_IRQ		EXYNOS4210_GPIO_L0_START
#define	EXYNOS4210_GPIO_L1_IRQ		EXYNOS4210_GPIO_L1_START
#define	EXYNOS4210_GPIO_L2_IRQ		EXYNOS4210_GPIO_L2_START
#define	EXYNOS4210_GPIO_Z_IRQ		EXYNOS4210_GPIO_Z_START

#define EXYNOS4210_GPIOA_NR_PINS	EXYNOS_GPIO_START(EXYNOS4210_GPIO_F3)
#define EXYNOS4210_GPIOA_NR_GINT	EXYNOS_GPIO_START(EXYNOS4210_GPIO_F3)
#define EXYNOS4210_GPIOB_NR_PINS	EXYNOS_GPIO_START(EXYNOS4210_GPIO_X3)
#define EXYNOS4210_GPIOB_NR_GINT	EXYNOS_GPIO_START(EXYNOS4210_GPIO_L2)
#define EXYNOS4210_GPIOC_NR_PINS	EXYNOS_GPIO_START(EXYNOS4210_GPIO_Z)

/* External GPIO and wakeup interrupt related definitions */
#define EXYNOS_GPIO_ECON_OFFSET		0x700
#define EXYNOS_GPIO_EMASK_OFFSET	0x900
#define EXYNOS_GPIO_EPEND_OFFSET	0xA00
#define EXYNOS_WKUP_ECON_OFFSET		0xE00
#define EXYNOS_WKUP_EMASK_OFFSET	0xF00
#define EXYNOS_WKUP_EPEND_OFFSET	0xF40
#define EXYNOS_SVC_OFFSET		0xB08
#define EXYNOS_EINT_FUNC		0xF

/* helpers to access interrupt service register */
#define EXYNOS_SVC_GROUP_SHIFT		3
#define EXYNOS_SVC_GROUP_MASK		0x1f
#define EXYNOS_SVC_NUM_MASK		7
#define EXYNOS_SVC_GROUP(x)		((x >> EXYNOS_SVC_GROUP_SHIFT) & \
						EXYNOS_SVC_GROUP_MASK)

/* Exynos specific external interrupt trigger types */
#define EXYNOS_EINT_LEVEL_LOW		0
#define EXYNOS_EINT_LEVEL_HIGH		1
#define EXYNOS_EINT_EDGE_FALLING	2
#define EXYNOS_EINT_EDGE_RISING		3
#define EXYNOS_EINT_EDGE_BOTH		4
#define EXYNOS_EINT_CON_MASK		0xF
#define EXYNOS_EINT_CON_LEN		4

#define EXYNOS_EINT_MAX_PER_BANK	8
#define EXYNOS_EINT_NR_WKUP_EINT

#define EXYNOS_PIN_BANK_EINTN(reg, __gpio, id)		\
	{						\
		.pctl_offset	= reg,			\
		.pin_base	= (__gpio##_START),	\
		.nr_pins	= (__gpio##_NR),	\
		.func_width	= 4,			\
		.pud_width	= 2,			\
		.drv_width	= 2,			\
		.conpdn_width	= 2,			\
		.pudpdn_width	= 2,			\
		.eint_type	= EINT_TYPE_NONE,	\
		.name		= id			\
	}

#define EXYNOS_PIN_BANK_EINTG(reg, __gpio, id)		\
	{						\
		.pctl_offset	= reg,			\
		.pin_base	= (__gpio##_START),	\
		.nr_pins	= (__gpio##_NR),	\
		.func_width	= 4,			\
		.pud_width	= 2,			\
		.drv_width	= 2,			\
		.conpdn_width	= 2,			\
		.pudpdn_width	= 2,			\
		.eint_type	= EINT_TYPE_GPIO,	\
		.irq_base	= (__gpio##_IRQ),	\
		.name		= id			\
	}

/**
 * struct exynos_geint_data: gpio eint specific data for irq_chip callbacks.
 * @bank: pin bank from which this gpio interrupt originates.
 * @pin: pin number within the bank.
 * @eint_offset: offset to be added to the con/pend/mask register bank base.
 */
struct exynos_geint_data {
	struct samsung_pin_bank	*bank;
	u32			pin;
	u32			eint_offset;
};

/**
 * struct exynos_weint_data: irq specific data for all the wakeup interrupts
 * generated by the external wakeup interrupt controller.
 * @domain: irq domain representing the external wakeup interrupts
 * @irq: interrupt number within the domain.
 */
struct exynos_weint_data {
	struct irq_domain	*domain;
	u32			irq;
};
