/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalAStar2.memorymanager;

import com.sun.electric.tool.routing.experimentalAStar2.memorymanager.ObjectFactory;
import com.sun.electric.tool.routing.experimentalAStar2.memorymanager.ObjectPool;
import java.util.LinkedList;

public class LinkedListObjectPool<E>
implements ObjectPool<E> {
    private LinkedList<E> pool;
    private LinkedList<E> used;
    private final ObjectFactory<E> factory;

    public LinkedListObjectPool(int initialCapacity, ObjectFactory<E> factory) {
        if (initialCapacity < 1) {
            throw new IllegalArgumentException("Capacity of the object pool must be 1 or greater.");
        }
        this.pool = new LinkedList();
        for (int i = 0; i < initialCapacity; ++i) {
            this.pool.add(factory.create());
        }
        this.used = new LinkedList();
        this.factory = factory;
    }

    @Override
    public synchronized E acquire() {
        E object = this.pool.isEmpty() ? this.factory.create() : this.pool.remove();
        this.used.add(object);
        return object;
    }

    @Override
    public synchronized void release(E object) {
        if (!this.used.remove(object)) {
            throw new IllegalArgumentException("The given object does not belong to this object pool.");
        }
        this.pool.add(object);
    }
}

