/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <string.h>
#include "gtk_java.h"
#include <libebook/e-contact.h>
#include "org_gnu_libebook_EVCardAttribute.h"
#ifdef __cplusplus
extern "C" 
{
#endif

/*
 * Class:     org_gnu_libebook_EVCardAttribute
 * Method:    e_vcard_attribute_new
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EVCardAttribute_e_1vcard_1attribute_1new
(JNIEnv *env, jclass cls, jstring group, jstring name)
{
    char* group_g = group == NULL ? NULL : (char*)(*env)->GetStringUTFChars(env, group, 0);
    char* name_g = (char*)(*env)->GetStringUTFChars(env, name, 0);
    EVCardAttribute *evcardattribute = e_vcard_attribute_new(group_g, name_g);

    if(group != NULL)
        (*env)->ReleaseStringUTFChars(env, group, group_g);
    (*env)->ReleaseStringUTFChars(env, name, name_g);
    return getStructHandle(env, evcardattribute, (JGCopyFunc)e_vcard_attribute_copy, (JGFreeFunc)e_vcard_attribute_free);
}

/*
 * Class:     org_gnu_libebook_EVCardAttribute
 * Method:    e_vcard_attribute_copy
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EVCardAttribute_e_1vcard_1attribute_1copy
(JNIEnv *env, jclass cls, jobject obj)
{
    EVCardAttribute *evcardattribute = e_vcard_attribute_copy((EVCardAttribute*)getPointerFromHandle(env, obj));
    return getStructHandle(env, evcardattribute, (JGCopyFunc)e_vcard_attribute_copy, (JGFreeFunc)e_vcard_attribute_free);
}

/*
 * Class:     org_gnu_libebook_EVCardAttribute
 * Method:    e_vcard_attribute_add_value
 */
JNIEXPORT void JNICALL Java_org_gnu_libebook_EVCardAttribute_e_1vcard_1attribute_1add_1value
(JNIEnv *env, jclass cls, jobject obj, jstring value)
{
    char* value_g = (char*)(*env)->GetStringUTFChars(env, value, 0);
    EVCardAttribute *evcardattribute = (EVCardAttribute *)getPointerFromHandle(env, obj);
    e_vcard_attribute_add_value(evcardattribute, value_g);
    (*env)->ReleaseStringUTFChars(env, value, value_g);
}

/*
 * Class:     org_gnu_libebook_EVCardAttribute
 * Method:    e_vcard_attribute_add_value_decoded
 */
JNIEXPORT void JNICALL Java_org_gnu_libebook_EVCardAttribute_e_1vcard_1attribute_1add_1value_1decoded
(JNIEnv *env, jclass cls, jobject obj, jbyteArray value, jint len)
{
    EVCardAttribute *evcardattribute = (EVCardAttribute *)getPointerFromHandle(env, obj);
    char* value_g = (char*)malloc(len + 1);
    (*env)->GetByteArrayRegion(env, value, 0, len, (jbyte*)value_g);
    value_g[len] = 0;
    e_vcard_attribute_add_value_decoded(evcardattribute, value_g, len);
}

/*
 * Class:     org_gnu_libebook_EVCardAttribute
 * Method:    e_vcard_attribute_remove_values
 */
JNIEXPORT void JNICALL Java_org_gnu_libebook_EVCardAttribute_e_1vcard_1attribute_1remove_1values
(JNIEnv *env, jclass cls, jobject obj)
{
    e_vcard_attribute_remove_values((EVCardAttribute *)getPointerFromHandle(env, obj));
}

/*
 * Class:     org_gnu_libebook_EVCardAttribute
 * Method:    e_vcard_attribute_remove_params
 */
JNIEXPORT void JNICALL Java_org_gnu_libebook_EVCardAttribute_e_1vcard_1attribute_1remove_1params
(JNIEnv *env, jclass cls, jobject obj)
{
    e_vcard_attribute_remove_params((EVCardAttribute *)getPointerFromHandle(env, obj));
}

/*
 * Class:     org_gnu_libebook_EVCardAttribute
 * Method:    e_vcard_attribute_add_param
 */
JNIEXPORT void JNICALL Java_org_gnu_libebook_EVCardAttribute_e_1vcard_1attribute_1add_1param
(JNIEnv *env, jclass cls, jobject obj, jobject param)
{
    EVCardAttribute *evcardattribute = (EVCardAttribute *)getPointerFromHandle(env, obj);
    EVCardAttributeParam *evcardattributeparam = (EVCardAttributeParam *)getPointerFromHandle(env, param);
    e_vcard_attribute_add_param(evcardattribute, e_vcard_attribute_param_copy(evcardattributeparam));
}

/*
 * Class:     org_gnu_libebook_EVCardAttribute
 * Method:    e_vcard_attribute_add_param_with_value
 */
JNIEXPORT void JNICALL Java_org_gnu_libebook_EVCardAttribute_e_1vcard_1attribute_1add_1param_1with_1value
(JNIEnv *env, jclass cls, jobject obj, jobject param, jstring value)
{
    EVCardAttribute *evcardattribute = (EVCardAttribute *)getPointerFromHandle(env, obj);
    EVCardAttributeParam *evcardattributeparam = (EVCardAttributeParam *)getPointerFromHandle(env, param);
    char* value_g = (char*)(*env)->GetStringUTFChars(env, value, 0);
    e_vcard_attribute_add_param_with_value(evcardattribute, e_vcard_attribute_param_copy(evcardattributeparam), value_g);
    (*env)->ReleaseStringUTFChars(env, value, value_g);
}

/*
 * Class:     org_gnu_libebook_EVCardAttribute
 * Method:    e_vcard_attribute_get_group
 */
JNIEXPORT jstring JNICALL Java_org_gnu_libebook_EVCardAttribute_e_1vcard_1attribute_1get_1group
(JNIEnv *env, jclass cls, jobject obj)
{
    EVCardAttribute *evcardattribute = (EVCardAttribute *)getPointerFromHandle(env, obj);
    return (*env)->NewStringUTF(env, e_vcard_attribute_get_group(evcardattribute));
}

/*
 * Class:     org_gnu_libebook_EVCardAttribute
 * Method:    e_vcard_attribute_get_name
 */
JNIEXPORT jstring JNICALL Java_org_gnu_libebook_EVCardAttribute_e_1vcard_1attribute_1get_1name
(JNIEnv *env, jclass cls, jobject obj)
{
    EVCardAttribute *evcardattribute = (EVCardAttribute *)getPointerFromHandle(env, obj);
    return (*env)->NewStringUTF(env, e_vcard_attribute_get_name(evcardattribute));
}

/*
 * Class:     org_gnu_libebook_EVCardAttribute
 * Method:    e_vcard_attribute_get_values
 */
JNIEXPORT jobjectArray JNICALL Java_org_gnu_libebook_EVCardAttribute_e_1vcard_1attribute_1get_1values
(JNIEnv *env, jclass cls, jobject obj)
{
    EVCardAttribute *evcardattribute = (EVCardAttribute *)getPointerFromHandle(env, obj);
    GList *values = e_vcard_attribute_get_values(evcardattribute);
    GList *item;
    int i;
    gchar* value;
    jstring str;
    jobjectArray result;

    result = (*env)->NewObjectArray(env, g_list_length(values), (*env)->FindClass(env, "java/lang/String"), NULL);
    item = values;
    for (i = 0; item != NULL; item = item->next, ++i) {
        value = (gchar*)item->data;
        str = (*env)->NewStringUTF(env, value);
        (*env)->SetObjectArrayElement(env, result, i, str);
    }
    return result;
}

/*
 * Class:     org_gnu_libebook_EVCardAttribute
 * Method:    e_vcard_attribute_get_values_decoded
 */
JNIEXPORT jobjectArray JNICALL Java_org_gnu_libebook_EVCardAttribute_e_1vcard_1attribute_1get_1values_1decoded
(JNIEnv *env, jclass cls, jobject obj)
{
    EVCardAttribute *evcardattribute = (EVCardAttribute *)getPointerFromHandle(env, obj);
    GList *values = e_vcard_attribute_get_values_decoded(evcardattribute);
    GList *item;
    int i;
    gchar* value;
    jstring str;
    jobjectArray result = NULL;
    jbyteArray byteArray;

    item = values;
    for (i = 0; item != NULL; item = item->next, ++i) {
        value = (gchar*)((GString*)item->data)->str;
        jbyteArray byteArray = (*env)->NewByteArray (env, ((GString*)item->data)->len);

        if(result == NULL)
            result = (jobjectArray)(*env)->NewObjectArray(env, g_list_length(values), (*env)->GetObjectClass(env, byteArray), NULL); // last maybe null?

        (*env)->SetByteArrayRegion (env, byteArray, 0, ((GString*)item->data)->len, (jbyte *)value);
        (*env)->SetObjectArrayElement(env, result, i, byteArray);
    }
    return result;
}


jobject getEVCardAttributeParamHandle(JNIEnv* env, EVCardAttributeParam* param)
{
    return getHandleFromPointer(env, param);
//    return getStructHandle(env, param, (JGCopyFunc)e_vcard_attribute_param_copy, (JGFreeFunc)e_vcard_attribute_param_free);
}

/*
 * Class:     org_gnu_libebook_EVCardAttribute
 * Method:    e_vcard_attribute_get_params
 */
JNIEXPORT jobjectArray JNICALL Java_org_gnu_libebook_EVCardAttribute_e_1vcard_1attribute_1get_1params
(JNIEnv *env, jclass cls, jobject obj)
{
    EVCardAttribute *evcardattribute = (EVCardAttribute *)getPointerFromHandle(env, obj);
    return getStructHandlesFromGList(env, e_vcard_attribute_get_params(evcardattribute), (GetHandleFunc)getEVCardAttributeParamHandle);
}



#ifdef __cplusplus
}

#endif
