/* readonlymap.c generated by valac 0.12.0, the Vala compiler
 * generated from readonlymap.vala, do not modify */

/* readonlymap.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>


#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;

#define GEE_TYPE_MAP (gee_map_get_type ())
#define GEE_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_MAP, GeeMap))
#define GEE_IS_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_MAP))
#define GEE_MAP_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_MAP, GeeMapIface))

typedef struct _GeeMap GeeMap;
typedef struct _GeeMapIface GeeMapIface;

#define GEE_TYPE_MAP_ITERATOR (gee_map_iterator_get_type ())
#define GEE_MAP_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_MAP_ITERATOR, GeeMapIterator))
#define GEE_IS_MAP_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_MAP_ITERATOR))
#define GEE_MAP_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_MAP_ITERATOR, GeeMapIteratorIface))

typedef struct _GeeMapIterator GeeMapIterator;
typedef struct _GeeMapIteratorIface GeeMapIteratorIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

#define GEE_TYPE_SET (gee_set_get_type ())
#define GEE_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_SET, GeeSet))
#define GEE_IS_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_SET))
#define GEE_SET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_SET, GeeSetIface))

typedef struct _GeeSet GeeSet;
typedef struct _GeeSetIface GeeSetIface;

#define GEE_MAP_TYPE_ENTRY (gee_map_entry_get_type ())
#define GEE_MAP_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_MAP_TYPE_ENTRY, GeeMapEntry))
#define GEE_MAP_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_MAP_TYPE_ENTRY, GeeMapEntryClass))
#define GEE_MAP_IS_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_MAP_TYPE_ENTRY))
#define GEE_MAP_IS_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_MAP_TYPE_ENTRY))
#define GEE_MAP_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_MAP_TYPE_ENTRY, GeeMapEntryClass))

typedef struct _GeeMapEntry GeeMapEntry;
typedef struct _GeeMapEntryClass GeeMapEntryClass;

#define GEE_TYPE_READ_ONLY_MAP (gee_read_only_map_get_type ())
#define GEE_READ_ONLY_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_READ_ONLY_MAP, GeeReadOnlyMap))
#define GEE_READ_ONLY_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_READ_ONLY_MAP, GeeReadOnlyMapClass))
#define GEE_IS_READ_ONLY_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_READ_ONLY_MAP))
#define GEE_IS_READ_ONLY_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_READ_ONLY_MAP))
#define GEE_READ_ONLY_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_READ_ONLY_MAP, GeeReadOnlyMapClass))

typedef struct _GeeReadOnlyMap GeeReadOnlyMap;
typedef struct _GeeReadOnlyMapClass GeeReadOnlyMapClass;
typedef struct _GeeReadOnlyMapPrivate GeeReadOnlyMapPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GEE_READ_ONLY_MAP_TYPE_MAP_ITERATOR (gee_read_only_map_map_iterator_get_type ())
#define GEE_READ_ONLY_MAP_MAP_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_READ_ONLY_MAP_TYPE_MAP_ITERATOR, GeeReadOnlyMapMapIterator))
#define GEE_READ_ONLY_MAP_MAP_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_READ_ONLY_MAP_TYPE_MAP_ITERATOR, GeeReadOnlyMapMapIteratorClass))
#define GEE_READ_ONLY_MAP_IS_MAP_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_READ_ONLY_MAP_TYPE_MAP_ITERATOR))
#define GEE_READ_ONLY_MAP_IS_MAP_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_READ_ONLY_MAP_TYPE_MAP_ITERATOR))
#define GEE_READ_ONLY_MAP_MAP_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_READ_ONLY_MAP_TYPE_MAP_ITERATOR, GeeReadOnlyMapMapIteratorClass))

typedef struct _GeeReadOnlyMapMapIterator GeeReadOnlyMapMapIterator;
typedef struct _GeeReadOnlyMapMapIteratorClass GeeReadOnlyMapMapIteratorClass;
typedef struct _GeeReadOnlyMapMapIteratorPrivate GeeReadOnlyMapMapIteratorPrivate;

struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gboolean (*first) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GeeIterator* (*iterator) (GeeIterable* self);
	GType (*get_element_type) (GeeIterable* self);
};

struct _GeeMapIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeMapIterator* self);
	gboolean (*has_next) (GeeMapIterator* self);
	gboolean (*first) (GeeMapIterator* self);
	gpointer (*get_key) (GeeMapIterator* self);
	gpointer (*get_value) (GeeMapIterator* self);
	void (*set_value) (GeeMapIterator* self, gconstpointer value);
	void (*unset) (GeeMapIterator* self);
};

struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gboolean (*add_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeCollection* self, GeeCollection* collection);
	gpointer* (*to_array) (GeeCollection* self, int* result_length1);
	gint (*get_size) (GeeCollection* self);
	gboolean (*get_is_empty) (GeeCollection* self);
	GeeCollection* (*get_read_only_view) (GeeCollection* self);
};

struct _GeeSetIface {
	GTypeInterface parent_iface;
	GeeSet* (*get_read_only_view) (GeeSet* self);
};

struct _GeeMapIface {
	GTypeInterface parent_iface;
	gboolean (*has_key) (GeeMap* self, gconstpointer key);
	gboolean (*contains) (GeeMap* self, gconstpointer key);
	gboolean (*has) (GeeMap* self, gconstpointer key, gconstpointer value);
	gpointer (*get) (GeeMap* self, gconstpointer key);
	void (*set) (GeeMap* self, gconstpointer key, gconstpointer value);
	gboolean (*unset) (GeeMap* self, gconstpointer key, gpointer* value);
	gboolean (*remove) (GeeMap* self, gconstpointer key, gpointer* value);
	void (*clear) (GeeMap* self);
	GeeMapIterator* (*map_iterator) (GeeMap* self);
	void (*set_all) (GeeMap* self, GeeMap* map);
	gboolean (*unset_all) (GeeMap* self, GeeMap* map);
	gboolean (*remove_all) (GeeMap* self, GeeMap* map);
	gboolean (*has_all) (GeeMap* self, GeeMap* map);
	gboolean (*contains_all) (GeeMap* self, GeeMap* map);
	gint (*get_size) (GeeMap* self);
	gboolean (*get_is_empty) (GeeMap* self);
	GeeSet* (*get_keys) (GeeMap* self);
	GeeCollection* (*get_values) (GeeMap* self);
	GeeSet* (*get_entries) (GeeMap* self);
	GeeMap* (*get_read_only_view) (GeeMap* self);
	GType (*get_key_type) (GeeMap* self);
	GType (*get_value_type) (GeeMap* self);
};

struct _GeeReadOnlyMap {
	GObject parent_instance;
	GeeReadOnlyMapPrivate * priv;
};

struct _GeeReadOnlyMapClass {
	GObjectClass parent_class;
	GeeMap* (*get_read_only_view) (GeeReadOnlyMap* self);
};

struct _GeeReadOnlyMapPrivate {
	GType k_type;
	GBoxedCopyFunc k_dup_func;
	GDestroyNotify k_destroy_func;
	GType v_type;
	GBoxedCopyFunc v_dup_func;
	GDestroyNotify v_destroy_func;
	GeeMap* _map;
};

struct _GeeReadOnlyMapMapIterator {
	GObject parent_instance;
	GeeReadOnlyMapMapIteratorPrivate * priv;
	GeeMapIterator* _iter;
};

struct _GeeReadOnlyMapMapIteratorClass {
	GObjectClass parent_class;
};

struct _GeeReadOnlyMapMapIteratorPrivate {
	GType k_type;
	GBoxedCopyFunc k_dup_func;
	GDestroyNotify k_destroy_func;
	GType v_type;
	GBoxedCopyFunc v_dup_func;
	GDestroyNotify v_destroy_func;
};


static gpointer gee_read_only_map_parent_class = NULL;
static gpointer gee_read_only_map_map_iterator_parent_class = NULL;
static GeeMapIteratorIface* gee_read_only_map_map_iterator_gee_map_iterator_parent_iface = NULL;
static GeeIterableIface* gee_read_only_map_gee_iterable_parent_iface = NULL;
static GeeMapIface* gee_read_only_map_gee_map_parent_iface = NULL;

GType gee_iterator_get_type (void) G_GNUC_CONST;
GType gee_iterable_get_type (void) G_GNUC_CONST;
GType gee_map_iterator_get_type (void) G_GNUC_CONST;
GType gee_collection_get_type (void) G_GNUC_CONST;
GType gee_set_get_type (void) G_GNUC_CONST;
GType gee_map_entry_get_type (void) G_GNUC_CONST;
GType gee_map_get_type (void) G_GNUC_CONST;
GType gee_read_only_map_get_type (void) G_GNUC_CONST;
#define GEE_READ_ONLY_MAP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TYPE_READ_ONLY_MAP, GeeReadOnlyMapPrivate))
enum  {
	GEE_READ_ONLY_MAP_DUMMY_PROPERTY,
	GEE_READ_ONLY_MAP_K_TYPE,
	GEE_READ_ONLY_MAP_K_DUP_FUNC,
	GEE_READ_ONLY_MAP_K_DESTROY_FUNC,
	GEE_READ_ONLY_MAP_V_TYPE,
	GEE_READ_ONLY_MAP_V_DUP_FUNC,
	GEE_READ_ONLY_MAP_V_DESTROY_FUNC,
	GEE_READ_ONLY_MAP_SIZE,
	GEE_READ_ONLY_MAP_IS_EMPTY,
	GEE_READ_ONLY_MAP_KEYS,
	GEE_READ_ONLY_MAP_VALUES,
	GEE_READ_ONLY_MAP_ENTRIES,
	GEE_READ_ONLY_MAP_READ_ONLY_VIEW,
	GEE_READ_ONLY_MAP_KEY_TYPE,
	GEE_READ_ONLY_MAP_VALUE_TYPE,
	GEE_READ_ONLY_MAP_ELEMENT_TYPE
};
GeeReadOnlyMap* gee_read_only_map_new (GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, GeeMap* map);
GeeReadOnlyMap* gee_read_only_map_construct (GType object_type, GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, GeeMap* map);
static gboolean gee_read_only_map_real_has_key (GeeMap* base, gconstpointer key);
gboolean gee_map_has_key (GeeMap* self, gconstpointer key);
static gboolean gee_read_only_map_real_contains (GeeMap* base, gconstpointer key);
static gboolean gee_read_only_map_real_has (GeeMap* base, gconstpointer key, gconstpointer value);
gboolean gee_map_has (GeeMap* self, gconstpointer key, gconstpointer value);
static gpointer gee_read_only_map_real_get (GeeMap* base, gconstpointer key);
gpointer gee_map_get (GeeMap* self, gconstpointer key);
static void gee_read_only_map_real_set (GeeMap* base, gconstpointer key, gconstpointer value);
static gboolean gee_read_only_map_real_unset (GeeMap* base, gconstpointer key, gpointer* value);
static gboolean gee_read_only_map_real_remove (GeeMap* base, gconstpointer key, gpointer* value);
static void gee_read_only_map_real_clear (GeeMap* base);
static GeeMapIterator* gee_read_only_map_real_map_iterator (GeeMap* base);
GeeMapIterator* gee_map_map_iterator (GeeMap* self);
GeeReadOnlyMapMapIterator* gee_read_only_map_map_iterator_new (GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, GeeMapIterator* iterator);
GeeReadOnlyMapMapIterator* gee_read_only_map_map_iterator_construct (GType object_type, GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, GeeMapIterator* iterator);
GType gee_read_only_map_map_iterator_get_type (void) G_GNUC_CONST;
static void gee_read_only_map_real_set_all (GeeMap* base, GeeMap* map);
static gboolean gee_read_only_map_real_unset_all (GeeMap* base, GeeMap* map);
static gboolean gee_read_only_map_real_remove_all (GeeMap* base, GeeMap* map);
static gboolean gee_read_only_map_real_has_all (GeeMap* base, GeeMap* map);
gboolean gee_map_has_all (GeeMap* self, GeeMap* map);
static gboolean gee_read_only_map_real_contains_all (GeeMap* base, GeeMap* map);
static GeeIterator* gee_read_only_map_real_iterator (GeeIterable* base);
GeeSet* gee_map_get_entries (GeeMap* self);
GeeIterator* gee_iterable_iterator (GeeIterable* self);
gint gee_map_get_size (GeeMap* self);
gboolean gee_map_get_is_empty (GeeMap* self);
GeeSet* gee_map_get_keys (GeeMap* self);
GeeCollection* gee_map_get_values (GeeMap* self);
GeeMap* gee_read_only_map_get_read_only_view (GeeReadOnlyMap* self);
#define GEE_READ_ONLY_MAP_MAP_ITERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_READ_ONLY_MAP_TYPE_MAP_ITERATOR, GeeReadOnlyMapMapIteratorPrivate))
enum  {
	GEE_READ_ONLY_MAP_MAP_ITERATOR_DUMMY_PROPERTY,
	GEE_READ_ONLY_MAP_MAP_ITERATOR_K_TYPE,
	GEE_READ_ONLY_MAP_MAP_ITERATOR_K_DUP_FUNC,
	GEE_READ_ONLY_MAP_MAP_ITERATOR_K_DESTROY_FUNC,
	GEE_READ_ONLY_MAP_MAP_ITERATOR_V_TYPE,
	GEE_READ_ONLY_MAP_MAP_ITERATOR_V_DUP_FUNC,
	GEE_READ_ONLY_MAP_MAP_ITERATOR_V_DESTROY_FUNC
};
static gboolean gee_read_only_map_map_iterator_real_next (GeeMapIterator* base);
gboolean gee_map_iterator_next (GeeMapIterator* self);
static gboolean gee_read_only_map_map_iterator_real_has_next (GeeMapIterator* base);
gboolean gee_map_iterator_has_next (GeeMapIterator* self);
static gboolean gee_read_only_map_map_iterator_real_first (GeeMapIterator* base);
gboolean gee_map_iterator_first (GeeMapIterator* self);
static gpointer gee_read_only_map_map_iterator_real_get_key (GeeMapIterator* base);
gpointer gee_map_iterator_get_key (GeeMapIterator* self);
static gpointer gee_read_only_map_map_iterator_real_get_value (GeeMapIterator* base);
gpointer gee_map_iterator_get_value (GeeMapIterator* self);
static void gee_read_only_map_map_iterator_real_set_value (GeeMapIterator* base, gconstpointer value);
static void gee_read_only_map_map_iterator_real_unset (GeeMapIterator* base);
static void gee_read_only_map_map_iterator_finalize (GObject* obj);
static void _vala_gee_read_only_map_map_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gee_read_only_map_map_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void gee_read_only_map_finalize (GObject* obj);
GType gee_map_get_key_type (GeeMap* self);
GType gee_map_get_value_type (GeeMap* self);
GType gee_iterable_get_element_type (GeeIterable* self);
static void _vala_gee_read_only_map_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gee_read_only_map_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
 * Constructs a read-only map that mirrors the content of the specified map.
 *
 * @param map the map to decorate.
 */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GeeReadOnlyMap* gee_read_only_map_construct (GType object_type, GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, GeeMap* map) {
	GeeReadOnlyMap * self = NULL;
	GeeMap* _tmp0_;
	g_return_val_if_fail (map != NULL, NULL);
	self = (GeeReadOnlyMap*) g_object_new (object_type, NULL);
	self->priv->k_type = k_type;
	self->priv->k_dup_func = k_dup_func;
	self->priv->k_destroy_func = k_destroy_func;
	self->priv->v_type = v_type;
	self->priv->v_dup_func = v_dup_func;
	self->priv->v_destroy_func = v_destroy_func;
	_tmp0_ = _g_object_ref0 (map);
	_g_object_unref0 (self->priv->_map);
	self->priv->_map = _tmp0_;
	return self;
}


GeeReadOnlyMap* gee_read_only_map_new (GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, GeeMap* map) {
	return gee_read_only_map_construct (GEE_TYPE_READ_ONLY_MAP, k_type, k_dup_func, k_destroy_func, v_type, v_dup_func, v_destroy_func, map);
}


/**
 * {@inheritDoc}
 */
static gboolean gee_read_only_map_real_has_key (GeeMap* base, gconstpointer key) {
	GeeReadOnlyMap * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	self = (GeeReadOnlyMap*) base;
	_tmp0_ = gee_map_has_key (self->priv->_map, key);
	result = _tmp0_;
	return result;
}


/**
 * {@inheritDoc}
 */
static gboolean gee_read_only_map_real_contains (GeeMap* base, gconstpointer key) {
	GeeReadOnlyMap * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	self = (GeeReadOnlyMap*) base;
	_tmp0_ = gee_map_has_key (self->priv->_map, key);
	result = _tmp0_;
	return result;
}


/**
 * {@inheritDoc}
 */
static gboolean gee_read_only_map_real_has (GeeMap* base, gconstpointer key, gconstpointer value) {
	GeeReadOnlyMap * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	self = (GeeReadOnlyMap*) base;
	_tmp0_ = gee_map_has (self->priv->_map, key, value);
	result = _tmp0_;
	return result;
}


/**
 * {@inheritDoc}
 */
static gpointer gee_read_only_map_real_get (GeeMap* base, gconstpointer key) {
	GeeReadOnlyMap * self;
	gpointer result = NULL;
	gpointer _tmp0_ = NULL;
	self = (GeeReadOnlyMap*) base;
	_tmp0_ = gee_map_get (self->priv->_map, key);
	result = _tmp0_;
	return result;
}


/**
 * Unimplemented method (read only map).
 */
static void gee_read_only_map_real_set (GeeMap* base, gconstpointer key, gconstpointer value) {
	GeeReadOnlyMap * self;
	self = (GeeReadOnlyMap*) base;
	g_assert_not_reached ();
}


/**
 * Unimplemented method (read only map).
 */
static gboolean gee_read_only_map_real_unset (GeeMap* base, gconstpointer key, gpointer* value) {
	GeeReadOnlyMap * self;
	gpointer _value = NULL;
	gboolean result = FALSE;
	self = (GeeReadOnlyMap*) base;
	g_assert_not_reached ();
	if (value) {
		*value = _value;
	} else {
		((_value == NULL) || (self->priv->v_destroy_func == NULL)) ? NULL : (_value = (self->priv->v_destroy_func (_value), NULL));
	}
	return result;
}


/**
 * Unimplemented method (read only map).
 */
static gboolean gee_read_only_map_real_remove (GeeMap* base, gconstpointer key, gpointer* value) {
	GeeReadOnlyMap * self;
	gpointer _value = NULL;
	gboolean result = FALSE;
	self = (GeeReadOnlyMap*) base;
	g_assert_not_reached ();
	if (value) {
		*value = _value;
	} else {
		((_value == NULL) || (self->priv->v_destroy_func == NULL)) ? NULL : (_value = (self->priv->v_destroy_func (_value), NULL));
	}
	return result;
}


/**
 * Unimplemented method (read only map).
 */
static void gee_read_only_map_real_clear (GeeMap* base) {
	GeeReadOnlyMap * self;
	self = (GeeReadOnlyMap*) base;
	g_assert_not_reached ();
}


/**
 * {@inheritDoc}
 */
static GeeMapIterator* gee_read_only_map_real_map_iterator (GeeMap* base) {
	GeeReadOnlyMap * self;
	GeeMapIterator* result = NULL;
	GeeMapIterator* _tmp0_ = NULL;
	GeeMapIterator* _tmp1_;
	GeeReadOnlyMapMapIterator* _tmp2_ = NULL;
	GeeMapIterator* _tmp3_;
	self = (GeeReadOnlyMap*) base;
	_tmp0_ = gee_map_map_iterator (self->priv->_map);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_read_only_map_map_iterator_new (self->priv->k_type, (GBoxedCopyFunc) self->priv->k_dup_func, self->priv->k_destroy_func, self->priv->v_type, (GBoxedCopyFunc) self->priv->v_dup_func, self->priv->v_destroy_func, _tmp1_);
	_tmp3_ = (GeeMapIterator*) _tmp2_;
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}


/**
 * Unimplemented method (read only map).
 */
static void gee_read_only_map_real_set_all (GeeMap* base, GeeMap* map) {
	GeeReadOnlyMap * self;
	self = (GeeReadOnlyMap*) base;
	g_return_if_fail (map != NULL);
	g_assert_not_reached ();
}


/**
 * Unimplemented method (read only map).
 */
static gboolean gee_read_only_map_real_unset_all (GeeMap* base, GeeMap* map) {
	GeeReadOnlyMap * self;
	gboolean result = FALSE;
	self = (GeeReadOnlyMap*) base;
	g_return_val_if_fail (map != NULL, FALSE);
	g_assert_not_reached ();
	return result;
}


/**
 * Unimplemented method (read only map).
 */
static gboolean gee_read_only_map_real_remove_all (GeeMap* base, GeeMap* map) {
	GeeReadOnlyMap * self;
	gboolean result = FALSE;
	self = (GeeReadOnlyMap*) base;
	g_return_val_if_fail (map != NULL, FALSE);
	g_assert_not_reached ();
	return result;
}


/**
 * {@inheritDoc}
 */
static gboolean gee_read_only_map_real_has_all (GeeMap* base, GeeMap* map) {
	GeeReadOnlyMap * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	self = (GeeReadOnlyMap*) base;
	g_return_val_if_fail (map != NULL, FALSE);
	_tmp0_ = gee_map_has_all (self->priv->_map, map);
	result = _tmp0_;
	return result;
}


/**
 * {@inheritDoc}
 */
static gboolean gee_read_only_map_real_contains_all (GeeMap* base, GeeMap* map) {
	GeeReadOnlyMap * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	self = (GeeReadOnlyMap*) base;
	g_return_val_if_fail (map != NULL, FALSE);
	_tmp0_ = gee_map_has_all (self->priv->_map, map);
	result = _tmp0_;
	return result;
}


/**
 * {@inheritDoc}
 */
static GeeIterator* gee_read_only_map_real_iterator (GeeIterable* base) {
	GeeReadOnlyMap * self;
	GeeIterator* result = NULL;
	GeeSet* _tmp0_ = NULL;
	GeeSet* _tmp1_;
	GeeIterator* _tmp2_ = NULL;
	GeeIterator* _tmp3_;
	self = (GeeReadOnlyMap*) base;
	_tmp0_ = gee_map_get_entries ((GeeMap*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}


static gint gee_read_only_map_real_get_size (GeeMap* base) {
	gint result;
	GeeReadOnlyMap* self;
	gint _tmp0_;
	self = (GeeReadOnlyMap*) base;
	_tmp0_ = gee_map_get_size (self->priv->_map);
	result = _tmp0_;
	return result;
}


static gboolean gee_read_only_map_real_get_is_empty (GeeMap* base) {
	gboolean result;
	GeeReadOnlyMap* self;
	gboolean _tmp0_;
	self = (GeeReadOnlyMap*) base;
	_tmp0_ = gee_map_get_is_empty (self->priv->_map);
	result = _tmp0_;
	return result;
}


static GeeSet* gee_read_only_map_real_get_keys (GeeMap* base) {
	GeeSet* result;
	GeeReadOnlyMap* self;
	GeeSet* _tmp0_ = NULL;
	self = (GeeReadOnlyMap*) base;
	_tmp0_ = gee_map_get_keys (self->priv->_map);
	result = _tmp0_;
	return result;
}


static GeeCollection* gee_read_only_map_real_get_values (GeeMap* base) {
	GeeCollection* result;
	GeeReadOnlyMap* self;
	GeeCollection* _tmp0_ = NULL;
	self = (GeeReadOnlyMap*) base;
	_tmp0_ = gee_map_get_values (self->priv->_map);
	result = _tmp0_;
	return result;
}


static GeeSet* gee_read_only_map_real_get_entries (GeeMap* base) {
	GeeSet* result;
	GeeReadOnlyMap* self;
	GeeSet* _tmp0_ = NULL;
	self = (GeeReadOnlyMap*) base;
	_tmp0_ = gee_map_get_entries (self->priv->_map);
	result = _tmp0_;
	return result;
}


GeeMap* gee_read_only_map_get_read_only_view (GeeReadOnlyMap* self) {
	return GEE_READ_ONLY_MAP_GET_CLASS (self)->get_read_only_view (self);
}


static GeeMap* gee_read_only_map_real_get_read_only_view (GeeReadOnlyMap* base) {
	GeeMap* result;
	GeeReadOnlyMap* self;
	GeeMap* _tmp0_;
	self = base;
	_tmp0_ = _g_object_ref0 ((GeeMap*) self);
	result = _tmp0_;
	return result;
}


static GType gee_read_only_map_real_get_key_type (GeeMap* base) {
	GType result;
	GeeReadOnlyMap* self;
	self = (GeeReadOnlyMap*) base;
	result = self->priv->k_type;
	return result;
}


static GType gee_read_only_map_real_get_value_type (GeeMap* base) {
	GType result;
	GeeReadOnlyMap* self;
	self = (GeeReadOnlyMap*) base;
	result = self->priv->v_type;
	return result;
}


static GType gee_read_only_map_real_get_element_type (GeeIterable* base) {
	GType result;
	GeeReadOnlyMap* self;
	self = (GeeReadOnlyMap*) base;
	result = GEE_MAP_TYPE_ENTRY;
	return result;
}


GeeReadOnlyMapMapIterator* gee_read_only_map_map_iterator_construct (GType object_type, GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, GeeMapIterator* iterator) {
	GeeReadOnlyMapMapIterator * self = NULL;
	GeeMapIterator* _tmp0_;
	g_return_val_if_fail (iterator != NULL, NULL);
	self = (GeeReadOnlyMapMapIterator*) g_object_new (object_type, NULL);
	self->priv->k_type = k_type;
	self->priv->k_dup_func = k_dup_func;
	self->priv->k_destroy_func = k_destroy_func;
	self->priv->v_type = v_type;
	self->priv->v_dup_func = v_dup_func;
	self->priv->v_destroy_func = v_destroy_func;
	_tmp0_ = _g_object_ref0 (iterator);
	_g_object_unref0 (self->_iter);
	self->_iter = _tmp0_;
	return self;
}


GeeReadOnlyMapMapIterator* gee_read_only_map_map_iterator_new (GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, GeeMapIterator* iterator) {
	return gee_read_only_map_map_iterator_construct (GEE_READ_ONLY_MAP_TYPE_MAP_ITERATOR, k_type, k_dup_func, k_destroy_func, v_type, v_dup_func, v_destroy_func, iterator);
}


static gboolean gee_read_only_map_map_iterator_real_next (GeeMapIterator* base) {
	GeeReadOnlyMapMapIterator * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	self = (GeeReadOnlyMapMapIterator*) base;
	_tmp0_ = gee_map_iterator_next (self->_iter);
	result = _tmp0_;
	return result;
}


static gboolean gee_read_only_map_map_iterator_real_has_next (GeeMapIterator* base) {
	GeeReadOnlyMapMapIterator * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	self = (GeeReadOnlyMapMapIterator*) base;
	_tmp0_ = gee_map_iterator_has_next (self->_iter);
	result = _tmp0_;
	return result;
}


static gboolean gee_read_only_map_map_iterator_real_first (GeeMapIterator* base) {
	GeeReadOnlyMapMapIterator * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	self = (GeeReadOnlyMapMapIterator*) base;
	_tmp0_ = gee_map_iterator_first (self->_iter);
	result = _tmp0_;
	return result;
}


static gpointer gee_read_only_map_map_iterator_real_get_key (GeeMapIterator* base) {
	GeeReadOnlyMapMapIterator * self;
	gpointer result = NULL;
	gpointer _tmp0_ = NULL;
	self = (GeeReadOnlyMapMapIterator*) base;
	_tmp0_ = gee_map_iterator_get_key (self->_iter);
	result = _tmp0_;
	return result;
}


static gpointer gee_read_only_map_map_iterator_real_get_value (GeeMapIterator* base) {
	GeeReadOnlyMapMapIterator * self;
	gpointer result = NULL;
	gpointer _tmp0_ = NULL;
	self = (GeeReadOnlyMapMapIterator*) base;
	_tmp0_ = gee_map_iterator_get_value (self->_iter);
	result = _tmp0_;
	return result;
}


static void gee_read_only_map_map_iterator_real_set_value (GeeMapIterator* base, gconstpointer value) {
	GeeReadOnlyMapMapIterator * self;
	self = (GeeReadOnlyMapMapIterator*) base;
	g_assert_not_reached ();
}


static void gee_read_only_map_map_iterator_real_unset (GeeMapIterator* base) {
	GeeReadOnlyMapMapIterator * self;
	self = (GeeReadOnlyMapMapIterator*) base;
	g_assert_not_reached ();
}


static void gee_read_only_map_map_iterator_class_init (GeeReadOnlyMapMapIteratorClass * klass) {
	gee_read_only_map_map_iterator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeReadOnlyMapMapIteratorPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_read_only_map_map_iterator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_read_only_map_map_iterator_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_read_only_map_map_iterator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_MAP_MAP_ITERATOR_K_TYPE, g_param_spec_gtype ("k-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_MAP_MAP_ITERATOR_K_DUP_FUNC, g_param_spec_pointer ("k-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_MAP_MAP_ITERATOR_K_DESTROY_FUNC, g_param_spec_pointer ("k-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_MAP_MAP_ITERATOR_V_TYPE, g_param_spec_gtype ("v-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_MAP_MAP_ITERATOR_V_DUP_FUNC, g_param_spec_pointer ("v-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_MAP_MAP_ITERATOR_V_DESTROY_FUNC, g_param_spec_pointer ("v-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void gee_read_only_map_map_iterator_gee_map_iterator_interface_init (GeeMapIteratorIface * iface) {
	gee_read_only_map_map_iterator_gee_map_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->next = (gboolean (*)(GeeMapIterator*)) gee_read_only_map_map_iterator_real_next;
	iface->has_next = (gboolean (*)(GeeMapIterator*)) gee_read_only_map_map_iterator_real_has_next;
	iface->first = (gboolean (*)(GeeMapIterator*)) gee_read_only_map_map_iterator_real_first;
	iface->get_key = (gpointer (*)(GeeMapIterator*)) gee_read_only_map_map_iterator_real_get_key;
	iface->get_value = (gpointer (*)(GeeMapIterator*)) gee_read_only_map_map_iterator_real_get_value;
	iface->set_value = (void (*)(GeeMapIterator* ,gconstpointer)) gee_read_only_map_map_iterator_real_set_value;
	iface->unset = (void (*)(GeeMapIterator*)) gee_read_only_map_map_iterator_real_unset;
}


static void gee_read_only_map_map_iterator_instance_init (GeeReadOnlyMapMapIterator * self) {
	self->priv = GEE_READ_ONLY_MAP_MAP_ITERATOR_GET_PRIVATE (self);
}


static void gee_read_only_map_map_iterator_finalize (GObject* obj) {
	GeeReadOnlyMapMapIterator * self;
	self = GEE_READ_ONLY_MAP_MAP_ITERATOR (obj);
	_g_object_unref0 (self->_iter);
	G_OBJECT_CLASS (gee_read_only_map_map_iterator_parent_class)->finalize (obj);
}


GType gee_read_only_map_map_iterator_get_type (void) {
	static volatile gsize gee_read_only_map_map_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&gee_read_only_map_map_iterator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeReadOnlyMapMapIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_read_only_map_map_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeReadOnlyMapMapIterator), 0, (GInstanceInitFunc) gee_read_only_map_map_iterator_instance_init, NULL };
		static const GInterfaceInfo gee_map_iterator_info = { (GInterfaceInitFunc) gee_read_only_map_map_iterator_gee_map_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_read_only_map_map_iterator_type_id;
		gee_read_only_map_map_iterator_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeReadOnlyMapMapIterator", &g_define_type_info, 0);
		g_type_add_interface_static (gee_read_only_map_map_iterator_type_id, GEE_TYPE_MAP_ITERATOR, &gee_map_iterator_info);
		g_once_init_leave (&gee_read_only_map_map_iterator_type_id__volatile, gee_read_only_map_map_iterator_type_id);
	}
	return gee_read_only_map_map_iterator_type_id__volatile;
}


static void _vala_gee_read_only_map_map_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeReadOnlyMapMapIterator * self;
	self = GEE_READ_ONLY_MAP_MAP_ITERATOR (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gee_read_only_map_map_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeReadOnlyMapMapIterator * self;
	self = GEE_READ_ONLY_MAP_MAP_ITERATOR (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GEE_READ_ONLY_MAP_MAP_ITERATOR_K_TYPE:
		self->priv->k_type = g_value_get_gtype (value);
		break;
		case GEE_READ_ONLY_MAP_MAP_ITERATOR_K_DUP_FUNC:
		self->priv->k_dup_func = g_value_get_pointer (value);
		break;
		case GEE_READ_ONLY_MAP_MAP_ITERATOR_K_DESTROY_FUNC:
		self->priv->k_destroy_func = g_value_get_pointer (value);
		break;
		case GEE_READ_ONLY_MAP_MAP_ITERATOR_V_TYPE:
		self->priv->v_type = g_value_get_gtype (value);
		break;
		case GEE_READ_ONLY_MAP_MAP_ITERATOR_V_DUP_FUNC:
		self->priv->v_dup_func = g_value_get_pointer (value);
		break;
		case GEE_READ_ONLY_MAP_MAP_ITERATOR_V_DESTROY_FUNC:
		self->priv->v_destroy_func = g_value_get_pointer (value);
		break;
	}
}


static void gee_read_only_map_class_init (GeeReadOnlyMapClass * klass) {
	gee_read_only_map_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeReadOnlyMapPrivate));
	GEE_READ_ONLY_MAP_CLASS (klass)->get_read_only_view = gee_read_only_map_real_get_read_only_view;
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_read_only_map_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_read_only_map_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_read_only_map_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_MAP_K_TYPE, g_param_spec_gtype ("k-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_MAP_K_DUP_FUNC, g_param_spec_pointer ("k-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_MAP_K_DESTROY_FUNC, g_param_spec_pointer ("k-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_MAP_V_TYPE, g_param_spec_gtype ("v-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_MAP_V_DUP_FUNC, g_param_spec_pointer ("v-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_MAP_V_DESTROY_FUNC, g_param_spec_pointer ("v-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_MAP_SIZE, "size");
	/**
	 * {@inheritDoc}
	 */
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_MAP_IS_EMPTY, "is-empty");
	/**
	 * {@inheritDoc}
	 */
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_MAP_KEYS, "keys");
	/**
	 * {@inheritDoc}
	 */
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_MAP_VALUES, "values");
	/**
	 * {@inheritDoc}
	 */
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_MAP_ENTRIES, "entries");
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_MAP_READ_ONLY_VIEW, "read-only-view");
	/**
	 * {@inheritDoc}
	 */
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_MAP_KEY_TYPE, "key-type");
	/**
	 * {@inheritDoc}
	 */
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_MAP_VALUE_TYPE, "value-type");
	/**
	 * {@inheritDoc}
	 */
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_MAP_ELEMENT_TYPE, "element-type");
}


static void gee_read_only_map_gee_iterable_interface_init (GeeIterableIface * iface) {
	gee_read_only_map_gee_iterable_parent_iface = g_type_interface_peek_parent (iface);
	iface->iterator = (GeeIterator* (*)(GeeIterable*)) gee_read_only_map_real_iterator;
	iface->get_element_type = gee_read_only_map_real_get_element_type;
}


static void gee_read_only_map_gee_map_interface_init (GeeMapIface * iface) {
	gee_read_only_map_gee_map_parent_iface = g_type_interface_peek_parent (iface);
	iface->has_key = (gboolean (*)(GeeMap* ,gconstpointer)) gee_read_only_map_real_has_key;
	iface->contains = (gboolean (*)(GeeMap* ,gconstpointer)) gee_read_only_map_real_contains;
	iface->has = (gboolean (*)(GeeMap* ,gconstpointer ,gconstpointer)) gee_read_only_map_real_has;
	iface->get = (gpointer (*)(GeeMap* ,gconstpointer)) gee_read_only_map_real_get;
	iface->set = (void (*)(GeeMap* ,gconstpointer ,gconstpointer)) gee_read_only_map_real_set;
	iface->unset = (gboolean (*)(GeeMap* ,gconstpointer ,gpointer*)) gee_read_only_map_real_unset;
	iface->remove = (gboolean (*)(GeeMap* ,gconstpointer ,gpointer*)) gee_read_only_map_real_remove;
	iface->clear = (void (*)(GeeMap*)) gee_read_only_map_real_clear;
	iface->map_iterator = (GeeMapIterator* (*)(GeeMap*)) gee_read_only_map_real_map_iterator;
	iface->set_all = (void (*)(GeeMap* ,GeeMap*)) gee_read_only_map_real_set_all;
	iface->unset_all = (gboolean (*)(GeeMap* ,GeeMap*)) gee_read_only_map_real_unset_all;
	iface->remove_all = (gboolean (*)(GeeMap* ,GeeMap*)) gee_read_only_map_real_remove_all;
	iface->has_all = (gboolean (*)(GeeMap* ,GeeMap*)) gee_read_only_map_real_has_all;
	iface->contains_all = (gboolean (*)(GeeMap* ,GeeMap*)) gee_read_only_map_real_contains_all;
	iface->get_size = gee_read_only_map_real_get_size;
	iface->get_is_empty = gee_read_only_map_real_get_is_empty;
	iface->get_keys = gee_read_only_map_real_get_keys;
	iface->get_values = gee_read_only_map_real_get_values;
	iface->get_entries = gee_read_only_map_real_get_entries;
	iface->get_read_only_view = (GeeMap* (*) (GeeMap *)) gee_read_only_map_get_read_only_view;
	iface->get_key_type = gee_read_only_map_real_get_key_type;
	iface->get_value_type = gee_read_only_map_real_get_value_type;
}


static void gee_read_only_map_instance_init (GeeReadOnlyMap * self) {
	self->priv = GEE_READ_ONLY_MAP_GET_PRIVATE (self);
}


static void gee_read_only_map_finalize (GObject* obj) {
	GeeReadOnlyMap * self;
	self = GEE_READ_ONLY_MAP (obj);
	_g_object_unref0 (self->priv->_map);
	G_OBJECT_CLASS (gee_read_only_map_parent_class)->finalize (obj);
}


/**
 * Read-only view for {@link Map} collections.
 *
 * This class decorates any class which implements the {@link Map} interface
 * by making it read only. Any method which normally modify data will throw an
 * error.
 *
 * @see Map
 */
GType gee_read_only_map_get_type (void) {
	static volatile gsize gee_read_only_map_type_id__volatile = 0;
	if (g_once_init_enter (&gee_read_only_map_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeReadOnlyMapClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_read_only_map_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeReadOnlyMap), 0, (GInstanceInitFunc) gee_read_only_map_instance_init, NULL };
		static const GInterfaceInfo gee_iterable_info = { (GInterfaceInitFunc) gee_read_only_map_gee_iterable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_map_info = { (GInterfaceInitFunc) gee_read_only_map_gee_map_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_read_only_map_type_id;
		gee_read_only_map_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeReadOnlyMap", &g_define_type_info, 0);
		g_type_add_interface_static (gee_read_only_map_type_id, GEE_TYPE_ITERABLE, &gee_iterable_info);
		g_type_add_interface_static (gee_read_only_map_type_id, GEE_TYPE_MAP, &gee_map_info);
		g_once_init_leave (&gee_read_only_map_type_id__volatile, gee_read_only_map_type_id);
	}
	return gee_read_only_map_type_id__volatile;
}


static void _vala_gee_read_only_map_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeReadOnlyMap * self;
	self = GEE_READ_ONLY_MAP (object);
	switch (property_id) {
		case GEE_READ_ONLY_MAP_SIZE:
		g_value_set_int (value, gee_map_get_size ((GeeMap*) self));
		break;
		case GEE_READ_ONLY_MAP_IS_EMPTY:
		g_value_set_boolean (value, gee_map_get_is_empty ((GeeMap*) self));
		break;
		case GEE_READ_ONLY_MAP_KEYS:
		g_value_take_object (value, gee_map_get_keys ((GeeMap*) self));
		break;
		case GEE_READ_ONLY_MAP_VALUES:
		g_value_take_object (value, gee_map_get_values ((GeeMap*) self));
		break;
		case GEE_READ_ONLY_MAP_ENTRIES:
		g_value_take_object (value, gee_map_get_entries ((GeeMap*) self));
		break;
		case GEE_READ_ONLY_MAP_READ_ONLY_VIEW:
		g_value_take_object (value, gee_read_only_map_get_read_only_view (self));
		break;
		case GEE_READ_ONLY_MAP_KEY_TYPE:
		g_value_set_gtype (value, gee_map_get_key_type ((GeeMap*) self));
		break;
		case GEE_READ_ONLY_MAP_VALUE_TYPE:
		g_value_set_gtype (value, gee_map_get_value_type ((GeeMap*) self));
		break;
		case GEE_READ_ONLY_MAP_ELEMENT_TYPE:
		g_value_set_gtype (value, gee_iterable_get_element_type ((GeeIterable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gee_read_only_map_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeReadOnlyMap * self;
	self = GEE_READ_ONLY_MAP (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GEE_READ_ONLY_MAP_K_TYPE:
		self->priv->k_type = g_value_get_gtype (value);
		break;
		case GEE_READ_ONLY_MAP_K_DUP_FUNC:
		self->priv->k_dup_func = g_value_get_pointer (value);
		break;
		case GEE_READ_ONLY_MAP_K_DESTROY_FUNC:
		self->priv->k_destroy_func = g_value_get_pointer (value);
		break;
		case GEE_READ_ONLY_MAP_V_TYPE:
		self->priv->v_type = g_value_get_gtype (value);
		break;
		case GEE_READ_ONLY_MAP_V_DUP_FUNC:
		self->priv->v_dup_func = g_value_get_pointer (value);
		break;
		case GEE_READ_ONLY_MAP_V_DESTROY_FUNC:
		self->priv->v_destroy_func = g_value_get_pointer (value);
		break;
	}
}



