# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work environment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=cairo
VER=1.6.4-2
THIS=$MOD-$VER
HEX=`echo $THIS | md5sum | cut -d' ' -f1`
sed -e 's/need_relink=yes/need_relink=no # no way --tml/' <ltmain.sh >ltmain.temp && mv ltmain.temp ltmain.sh

# Avoid using "file" in libtool. Otherwise libtool won't create a
# shared library, and give the extremely confusing and annoying
# warning "Trying to link with static lib archive [...] But I can only
# do this if you have shared version of the library, which you do not
# appear to have."  Screw libtool. I know what I am doing. Yes, I do
# want to link with a static libpixman-1.

sed -e 's!file /!dont-want-to-use-file!' <configure >configure.temp && mv configure.temp configure

usedev
usemsvs6

unset MY_PKG_CONFIG_PATH
DEPS=`/devel/src/tml/latest.sh pixman libpng`
for D in $DEPS; do
    PATH=/devel/dist/$D/bin:$PATH
    MY_PKG_CONFIG_PATH=/devel/dist/$D/lib/pkgconfig:$MY_PKG_CONFIG_PATH
done

PKG_CONFIG_PATH=$MY_PKG_CONFIG_PATH:$PKG_CONFIG_PATH CC='gcc -mtune=pentium3' CPPFLAGS='-I/opt/misc/include -I/opt/gnu/include' LDFLAGS='-L/opt/misc/lib' CFLAGS=-O2 ./configure --disable-static --enable-freetype=no --prefix=c:/devel/target/$HEX &&

PATH=/devel/target/$HEX/bin:$PATH make -j3 zips &&

( (
[ $VER = 1.6.4-2 ] && {
mv /tmp/$MOD-1.6.4.zip /tmp/$MOD-$VER.zip &&
mv /tmp/$MOD-dev-1.6.4.zip /tmp/$MOD-dev-$VER.zip
}
) || true) &&

cp -p src/cairo.def /devel/target/$HEX/lib &&
mkdir -p /devel/target/$HEX/share/doc/$MOD-$VER &&
cp -p COPYING COPYING-LGPL-2.1 COPYING-MPL-1.1 /devel/target/$HEX/share/doc/$MOD-$VER &&
(cd /devel/target/$HEX/lib &&
lib.exe -def:cairo.def -out:cairo.lib &&
cd .. &&
zip /tmp/$MOD-dev-$VER.zip lib/cairo.def lib/cairo.lib &&
zip -r /tmp/$MOD-$VER.zip share/doc/$MOD-$VER &&
sed -e 's/ pixman-1 >= 0.10.0//' <lib/pkgconfig/cairo.pc >lib/pkgconfig/cairo.pc.temp && mv lib/pkgconfig/cairo.pc.temp lib/pkgconfig/cairo.pc &&
zip /tmp/$MOD-dev-$VER.zip lib/pkgconfig/cairo.pc &&

cd /devel/src/tml && 
zip /tmp/$MOD-dev-$VER.zip make/$THIS.sh) &&

manifestify /tmp/$MOD-$VER.zip /tmp/$MOD-dev-$VER.zip
