/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.tests;

import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wildwebdeveloper.tests.AllCleanRule;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={AllCleanRule.class})
public class TestSyntaxHighlighting {
    private IProject project;

    @BeforeEach
    public void initializeHostProject() throws CoreException {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject("blah");
        this.project.create(null);
        this.project.open(null);
    }

    @Test
    public void testJSXHighlighting() throws CoreException {
        IFile file = this.project.getFile("test.jsx");
        file.create("var n = 4;\n".getBytes(), true, false, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        StyledText widget = (StyledText)editor.getAdapter(Control.class);
        Color defaultTextColor = widget.getForeground();
        Assertions.assertTrue((boolean)DisplayHelper.waitForCondition((Display)widget.getDisplay(), (long)5000L, () -> Arrays.stream(widget.getStyleRanges()).anyMatch(range -> range.foreground != null && !defaultTextColor.equals((Object)range.foreground))), (String)"Missing syntax highlighting");
    }
}

